/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.internal.operators.single;

import io.reactivex.Scheduler;
import io.reactivex.Single;
import io.reactivex.SingleObserver;
import io.reactivex.SingleSource;
import io.reactivex.disposables.Disposable;
import io.reactivex.internal.disposables.SequentialDisposable;
import java.util.concurrent.TimeUnit;

public final class SingleDelay<T>
extends Single<T> {
    final SingleSource<? extends T> source;
    final long time;
    final TimeUnit unit;
    final Scheduler scheduler;

    public SingleDelay(SingleSource<? extends T> source, long time, TimeUnit unit, Scheduler scheduler) {
        this.source = source;
        this.time = time;
        this.unit = unit;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(final SingleObserver<? super T> s) {
        final SequentialDisposable sd = new SequentialDisposable();
        s.onSubscribe(sd);
        this.source.subscribe(new SingleObserver<T>(){

            @Override
            public void onSubscribe(Disposable d) {
                sd.replace(d);
            }

            @Override
            public void onSuccess(final T value) {
                sd.replace(SingleDelay.this.scheduler.scheduleDirect(new Runnable(){

                    @Override
                    public void run() {
                        s.onSuccess(value);
                    }
                }, SingleDelay.this.time, SingleDelay.this.unit));
            }

            @Override
            public void onError(final Throwable e) {
                sd.replace(SingleDelay.this.scheduler.scheduleDirect(new Runnable(){

                    @Override
                    public void run() {
                        s.onError(e);
                    }
                }, 0L, SingleDelay.this.unit));
            }
        });
    }
}

