/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.realtransform;

import java.util.Arrays;
import net.imglib2.realtransform.AffineInterpolator;
import net.imglib2.realtransform.AffineTransform2D;
import net.imglib2.util.LinAlgHelpers;
import org.janelia.utility.geom.GeomUtils;

public class SimilarityTransformInterpolator2D
implements AffineInterpolator {
    private final double thtDiff;
    private final AffineTransform2D tform = new AffineTransform2D();
    private final double[] c;
    private final double[] pDiff;
    private final double sDiff;

    public SimilarityTransformInterpolator2D(AffineTransform2D transform, double[] c) {
        AffineTransform2D transformEnd = new AffineTransform2D();
        transformEnd.set(transform);
        transformEnd.translate(new double[]{-c[0], -c[1]});
        double[] params = GeomUtils.scalesAngle(transformEnd);
        this.thtDiff = params[2];
        this.sDiff = (params[0] + params[1]) / 2.0 - 1.0;
        this.c = new double[2];
        System.arraycopy(c, 0, this.c, 0, 2);
        this.pDiff = new double[2];
        double[] tmp = new double[2];
        AffineTransform2D t1 = this.get(1.0);
        t1.apply(c, tmp);
        transform.apply(c, this.pDiff);
        LinAlgHelpers.subtract((double[])this.pDiff, (double[])tmp, (double[])this.pDiff);
    }

    public AffineTransform2D get(double t) {
        this.tform.set(new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0});
        this.tform.rotate(t * this.thtDiff);
        this.tform.scale(1.0 + t * this.sDiff);
        double[] pCurrent = new double[2];
        double[] pTgt = new double[2];
        this.tform.apply(this.c, pCurrent);
        LinAlgHelpers.scale((double[])this.pDiff, (double)t, (double[])pTgt);
        LinAlgHelpers.add((double[])this.c, (double[])pTgt, (double[])pTgt);
        LinAlgHelpers.subtract((double[])pTgt, (double[])pCurrent, (double[])pTgt);
        this.tform.translate(pTgt);
        return this.tform;
    }

    public static void main(String[] args) {
        double tht = 3.041592653589793;
        double scale = 2.2;
        double[] c = new double[]{-10.0, 20.0};
        AffineTransform2D t = GeomUtils.centeredSimilarity(3.041592653589793, 2.2, c);
        System.out.println(t);
        double[] ps = GeomUtils.scalesAngle(t, c);
        System.out.println(Arrays.toString(ps));
        double sx = ps[0];
        double sy = ps[1];
        double thtEst = ps[2];
        double sEst = 0.5 * (sx + sy);
        System.out.println("\ntht: 3.041592653589793 vs " + thtEst);
        System.out.println("scl: " + sEst + " vs " + 2.2 + "\n");
        AffineTransform2D tEst = GeomUtils.centeredSimilarity(thtEst, sEst, c);
        System.out.println(tEst);
        SimilarityTransformInterpolator2D interp = new SimilarityTransformInterpolator2D(t, c);
        System.out.println(t);
        System.out.println(interp.get(1.0));
    }
}

