/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.transforms;

import mpicbg.models.InvertibleCoordinateTransform;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPositionable;
import net.imglib2.realtransform.InvertibleRealTransform;

public class WrappedCoordinateTransform
implements InvertibleRealTransform {
    private final InvertibleCoordinateTransform ct;
    private final InvertibleCoordinateTransform ct_inv;
    private final int nd;

    public WrappedCoordinateTransform(InvertibleCoordinateTransform ct, int nd) {
        this.nd = nd;
        this.ct = ct;
        this.ct_inv = ct.createInverse();
    }

    public InvertibleCoordinateTransform getTransform() {
        return this.ct;
    }

    public void apply(double[] src, double[] tgt) {
        double[] res = this.ct.apply(src);
        System.arraycopy(res, 0, tgt, 0, res.length);
    }

    public void apply(RealLocalizable src, RealPositionable tgt) {
        double[] srcpt = new double[src.numDimensions()];
        src.localize(srcpt);
        double[] res = this.ct.apply(srcpt);
        tgt.setPosition(res);
    }

    public int numSourceDimensions() {
        return this.nd;
    }

    public int numTargetDimensions() {
        return this.nd;
    }

    public void applyInverse(double[] src, double[] tgt) {
        double[] res = this.ct_inv.apply(tgt);
        System.arraycopy(res, 0, src, 0, res.length);
    }

    public void applyInverse(RealPositionable src, RealLocalizable tgt) {
        double[] tgtpt = new double[tgt.numDimensions()];
        tgt.localize(tgtpt);
        double[] res = this.ct_inv.apply(tgtpt);
        src.setPosition(res);
    }

    public WrappedCoordinateTransform copy() {
        return new WrappedCoordinateTransform(this.ct, this.nd);
    }

    public WrappedCoordinateTransform inverse() {
        return new WrappedCoordinateTransform(this.ct_inv, this.nd);
    }
}

