/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.source;

import net.imglib2.AbstractRealLocalizable;
import net.imglib2.Localizable;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccess;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.type.numeric.RealType;

public class WarpMagnitudeRandomAccess<T extends RealType<T>>
extends AbstractRealLocalizable
implements RealRandomAccess<T> {
    RealTransform warp;
    RealTransform baseline;
    T value;
    final double[] warpRes;
    final double[] baseRes;
    final RealPoint warpResPt;
    final RealPoint baseResPt;

    protected WarpMagnitudeRandomAccess(double[] dimensions) {
        this(dimensions, null, null, null);
    }

    protected WarpMagnitudeRandomAccess(double[] dimensions, T value, RealTransform warp, RealTransform baseline) {
        super(dimensions.length);
        if (warp != null) {
            this.warp = warp.copy();
        }
        if (baseline != null) {
            this.baseline = baseline.copy();
        }
        this.value = value;
        this.warpRes = new double[this.numDimensions()];
        this.baseRes = new double[this.numDimensions()];
        this.warpResPt = RealPoint.wrap((double[])this.warpRes);
        this.baseResPt = RealPoint.wrap((double[])this.baseRes);
    }

    public T get() {
        RealType out = (RealType)this.value.copy();
        if (this.warp == null || this.baseline == null) {
            out.setZero();
            return (T)out;
        }
        this.warp.apply((RealLocalizable)this, (RealPositionable)this.warpResPt);
        this.baseline.apply((RealLocalizable)this, (RealPositionable)this.baseResPt);
        double dist = 0.0;
        for (int d = 0; d < this.warpRes.length; ++d) {
            dist += (this.warpRes[d] - this.baseRes[d]) * (this.warpRes[d] - this.baseRes[d]);
        }
        out.setReal(Math.sqrt(dist));
        return (T)out;
    }

    private boolean withinRad(double[] pt1, double[] pt2, double rad) {
        double radSquared = rad * rad;
        double distSquared = 0.0;
        for (int d = 0; d < pt2.length; ++d) {
            distSquared += (pt1[d] - pt2[d]) * (pt1[d] - pt2[d]);
        }
        return distSquared < radSquared;
    }

    public RealRandomAccess<T> copy() {
        return new WarpMagnitudeRandomAccess<RealType>(new double[this.position.length], (RealType)this.value.copy(), this.warp, this.baseline);
    }

    public RealRandomAccess<T> copyRandomAccess() {
        return this.copy();
    }

    public RealRandomAccess<T> copyRealRandomAccess() {
        return this.copy();
    }

    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1.0;
    }

    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1.0;
    }

    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(Localizable localizable) {
        int d = 0;
        while (d < this.n) {
            int distance = localizable.getIntPosition(d);
            int n = d++;
            this.position[n] = this.position[n] + (double)distance;
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void setPosition(Localizable localizable) {
        localizable.localize(this.position);
    }

    public void setPosition(int[] pos) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = pos[d];
        }
    }

    public void setPosition(long[] pos) {
        for (int d = 0; d < this.n; ++d) {
            int p = (int)pos[d];
            this.position[d] = p;
        }
    }

    public void setPosition(int pos, int d) {
        this.position[d] = pos;
    }

    public void setPosition(long pos, int d) {
        this.position[d] = (int)pos;
    }

    public void move(float distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (double)distance;
    }

    public void move(double distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    public void move(RealLocalizable localizable) {
        int d = 0;
        while (d < this.n) {
            double distance = localizable.getDoublePosition(d);
            int n = d++;
            this.position[n] = this.position[n] + distance;
        }
    }

    public void move(float[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (double)distance[d];
        }
    }

    public void move(double[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
        }
    }

    public void setPosition(RealLocalizable localizable) {
        for (int d = 0; d < this.n; ++d) {
            double pos;
            this.position[d] = pos = localizable.getDoublePosition(d);
        }
    }

    public void setPosition(float[] p) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = p[d];
        }
    }

    public void setPosition(double[] p) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = p[d];
        }
    }

    public void setPosition(float p, int d) {
        this.position[d] = p;
    }

    public void setPosition(double p, int d) {
        this.position[d] = p;
    }
}

