/*
 * Decompiled with CFR 0.152.
 */
package bigwarp.source;

import net.imglib2.AbstractLocalizable;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.type.numeric.RealType;

public class GridRandomAccess<T extends RealType<T>>
extends AbstractLocalizable
implements RandomAccess<T> {
    RealTransform warp;
    T value;

    protected GridRandomAccess(long[] dimensions) {
        this(dimensions, null, null);
    }

    protected GridRandomAccess(long[] dimensions, T value, RealTransform warp) {
        super(dimensions.length);
        this.value = value;
    }

    public T get() {
        double[] mypt = new double[this.numDimensions()];
        this.localize(mypt);
        double[] warpRes = new double[this.warp.numTargetDimensions()];
        this.warp.apply(mypt, warpRes);
        RealType out = (RealType)this.value.copy();
        out.setReal(warpRes[0] % 50.0 + warpRes[1] % 50.0);
        return (T)out;
    }

    private boolean withinRad(double[] pt1, double[] pt2, double rad) {
        double radSquared = rad * rad;
        double distSquared = 0.0;
        for (int d = 0; d < pt2.length; ++d) {
            distSquared += (pt1[d] - pt2[d]) * (pt1[d] - pt2[d]);
        }
        return distSquared < radSquared;
    }

    public RandomAccess<T> copy() {
        return new GridRandomAccess<RealType>(new long[this.position.length], (RealType)this.value.copy(), this.warp);
    }

    public RandomAccess<T> copyRandomAccess() {
        return this.copy();
    }

    public void fwd(int d) {
        int n = d;
        this.position[n] = this.position[n] + 1L;
    }

    public void bck(int d) {
        int n = d;
        this.position[n] = this.position[n] - 1L;
    }

    public void move(int distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + (long)distance;
    }

    public void move(long distance, int d) {
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    public void move(Localizable localizable) {
        int d = 0;
        while (d < this.n) {
            int distance = localizable.getIntPosition(d);
            int n = d++;
            this.position[n] = this.position[n] + (long)distance;
        }
    }

    public void move(int[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + (long)distance[d];
        }
    }

    public void move(long[] distance) {
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
        }
    }

    public void setPosition(Localizable localizable) {
        localizable.localize(this.position);
    }

    public void setPosition(int[] pos) {
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = pos[d];
        }
    }

    public void setPosition(long[] pos) {
        for (int d = 0; d < this.n; ++d) {
            int p = (int)pos[d];
            this.position[d] = p;
        }
    }

    public void setPosition(int pos, int d) {
        this.position[d] = pos;
    }

    public void setPosition(long pos, int d) {
        this.position[d] = (int)pos;
    }
}

