/*
 * Decompiled with CFR 0.152.
 */
package bigwarp;

import bdv.gui.BigWarpViewerFrame;
import bdv.tools.ToggleDialogAction;
import bdv.util.Prefs;
import bdv.viewer.AbstractViewerPanel;
import bigwarp.BigWarp;
import bigwarp.landmarks.LandmarkGridGenerator;
import bigwarp.source.GridSource;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.table.TableCellEditor;
import mpicbg.models.AbstractModel;
import org.scijava.plugin.Plugin;
import org.scijava.ui.behaviour.KeyStrokeAdder;
import org.scijava.ui.behaviour.io.gui.CommandDescriptionProvider;
import org.scijava.ui.behaviour.io.gui.CommandDescriptions;
import org.scijava.ui.behaviour.util.AbstractNamedAction;
import org.scijava.ui.behaviour.util.Actions;
import org.scijava.ui.behaviour.util.InputActionBindings;

public class BigWarpActions
extends Actions {
    public static final CommandDescriptionProvider.Scope BIGWARP = new CommandDescriptionProvider.Scope("bigwarp");
    public static final String BIGWARP_CTXT = "bigwarp";
    public static final String NOT_MAPPED = "not mapped";
    public static final String LANDMARK_MODE_ON = "landmark mode on";
    public static final String LANDMARK_MODE_OFF = "landmark mode off";
    public static final String TRANSFORM_TYPE = "transform type";
    public static final String CLOSE_DIALOG = "close dialog window";
    public static final String[] CLOSE_DIALOG_KEYS = new String[]{"not mapped"};
    public static final String LOAD_PROJECT = "load project";
    public static final String[] LOAD_PROJECT_KEYS = new String[]{"ctrl shift O"};
    public static final String SAVE_PROJECT = "save project";
    public static final String[] SAVE_PROJECT_KEYS = new String[]{"ctrl shift S"};
    public static final String EXPAND_CARDS = "expand and focus cards panel";
    public static final String[] EXPAND_CARDS_KEYS = new String[]{"P"};
    public static final String COLLAPSE_CARDS = "collapse cards panel";
    public static final String[] COLLAPSE_CARDS_KEYS = new String[]{"shift P", "shift ESCAPE"};
    public static final String PREFERENCES_DIALOG = "Preferences";
    public static final String[] PREFERENCES_DIALOG_KEYS = new String[]{"meta COMMA", "ctrl COMMA"};
    public static final String TOGGLE_LANDMARK_MODE = "landmark mode toggle";
    public static final String[] TOGGLE_LANDMARK_MODE_KEYS = new String[]{"SPACE"};
    public static final String TOGGLE_POINTS_VISIBLE = "toggle points visible";
    public static final String[] TOGGLE_POINTS_VISIBLE_KEYS = new String[]{"V"};
    public static final String TOGGLE_POINT_NAMES_VISIBLE = "toggle point names visible";
    public static final String[] TOGGLE_POINT_NAMES_VISIBLE_KEYS = new String[]{"N"};
    public static final String TOGGLE_MOVING_IMAGE_DISPLAY = "toggle moving image display";
    public static final String[] TOGGLE_MOVING_IMAGE_DISPLAY_KEYS = new String[]{"T"};
    public static final String TOGGLE_BOX_AND_TEXT_OVERLAY_VISIBLE = "toggle box and text overlay visible";
    public static final String[] TOGGLE_BOX_AND_TEXT_OVERLAY_VISIBLE_KEYS = new String[]{"F8"};
    public static final String ESTIMATE_WARP = "estimate warp";
    public static final String[] ESTIMATE_WARP_KEYS = new String[]{"C"};
    public static final String PRINT_TRANSFORM = "print transform";
    public static final String[] PRINT_TRANSFORM_KEYS = new String[]{"ctrl shift T"};
    public static final String TOGGLE_ESTIMATE_WARP_ONDRAG = "toggle estimate warp on drag";
    public static final String[] TOGGLE_ESTIMATE_WARP_ONDRAG_KEYS = new String[]{"not mapped"};
    public static final String SAVE_SETTINGS = "save settings";
    public static final String[] SAVE_SETTINGS_KEYS = new String[]{"not mapped"};
    public static final String LOAD_SETTINGS = "load settings";
    public static final String[] LOAD_SETTINGS_KEYS = new String[]{"not mapped"};
    public static final String BRIGHTNESS_SETTINGS = "brightness settings";
    public static final String[] BRIGHTNESS_SETTINGS_KEYS = new String[]{"S"};
    public static final String VISIBILITY_AND_GROUPING = "visibility and grouping %s";
    public static final String VISIBILITY_AND_GROUPING_MVG = String.format("visibility and grouping %s", "moving");
    public static final String[] VISIBILITY_AND_GROUPING_MVG_KEYS = new String[]{"F3"};
    public static final String VISIBILITY_AND_GROUPING_TGT = String.format("visibility and grouping %s", "target");
    public static final String[] VISIBILITY_AND_GROUPING_TGT_KEYS = new String[]{"F4"};
    public static final String SHOW_HELP = "help";
    public static final String[] SHOW_HELP_KEYS = new String[]{"F1"};
    public static final String SHOW_SOURCE_INFO = "show source info";
    public static final String SHOW_WARPTYPE_DIALOG = "show warp vis dialog";
    public static final String[] SHOW_WARPTYPE_DIALOG_KEYS = new String[]{"U"};
    public static final String SET_WARPTYPE_VIS = "set warp vis type %s";
    public static final String SET_WARPTYPE_VIS_P = "p set warp vis type %s";
    public static final String SET_WARPTYPE_VIS_Q = "q set warp vis type %s";
    public static final String WARPMAG_BASE = "set warpmag base %s";
    public static final String WARPVISGRID = "set warp vis grid %s";
    public static final String WARPVISDIALOG = "warp vis dialog";
    public static final String RESET_VIEWER = "reset active viewer";
    public static final String[] RESET_VIEWER_KEYS = new String[]{"R"};
    public static final String ALIGN_VIEW_TRANSFORMS = "align view transforms %s";
    public static final String ALIGN_OTHER_TO_ACTIVE = String.format("align view transforms %s", new Object[]{AlignViewerPanelAction.TYPE.OTHER_TO_ACTIVE});
    public static final String[] ALIGN_OTHER_TO_ACTIVE_KEYS = new String[]{"Q"};
    public static final String ALIGN_ACTIVE_TO_OTHER = String.format("align view transforms %s", new Object[]{AlignViewerPanelAction.TYPE.ACTIVE_TO_OTHER});
    public static final String[] ALIGN_ACTIVE_TO_OTHER_KEYS = new String[]{"W"};
    public static final String JUMP_TO_SELECTED_POINT = "center on selected landmark";
    public static final String[] JUMP_TO_SELECTED_POINT_KEYS = new String[]{"D"};
    public static final String JUMP_TO_NEXT_POINT = "center on next landmark";
    public static final String[] JUMP_TO_NEXT_POINT_KEYS = new String[]{"ctrl D"};
    public static final String JUMP_TO_PREV_POINT = "center on prev landmark";
    public static final String[] JUMP_TO_PREV_POINT_KEYS = new String[]{"ctrl shift D"};
    public static final String JUMP_TO_NEAREST_POINT = "center on nearest landmark";
    public static final String[] JUMP_TO_NEAREST_POINT_KEYS = new String[]{"E"};
    public static final String LOAD_LANDMARKS = "load landmarks";
    public static final String[] LOAD_LANDMARKS_KEYS = new String[]{"ctrl O"};
    public static final String SAVE_LANDMARKS = "save landmarks";
    public static final String[] SAVE_LANDMARKS_KEYS = new String[]{"ctrl S"};
    public static final String QUICK_SAVE_LANDMARKS = "quick save landmarks";
    public static final String[] QUICK_SAVE_LANDMARKS_KEYS = new String[]{"ctrl Q"};
    public static final String SET_BOOKMARK = "set bookmark";
    public static final String[] SET_BOOKMARK_KEYS = new String[]{"shift B"};
    public static final String GO_TO_BOOKMARK = "go to bookmark";
    public static final String[] GO_TO_BOOKMARK_KEYS = new String[]{"B"};
    public static final String GO_TO_BOOKMARK_ROTATION = "go to bookmark rotation";
    public static final String[] GO_TO_BOOKMARK_ROTATION_KEYS = new String[]{"ctrl shift B"};
    public static final String UNDO = "undo";
    public static final String[] UNDO_KEYS = new String[]{"ctrl Z"};
    public static final String REDO = "redo";
    public static final String[] REDO_KEYS = new String[]{"ctrl shift Z", "ctrl Y"};
    public static final String SELECT_TABLE_ROWS = "select table row %d";
    public static final String LANDMARK_SELECT_ALL = "select all landmarks";
    public static final String[] LANDMARK_SELECT_ALL_KEYS = new String[]{"ctrl A"};
    public static final String LANDMARK_DESELECT_ALL = "deselect all landmarks";
    public static final String[] LANDMARK_DESELECT_ALL_KEYS = new String[]{"ESCAPE", "ctrl shift A"};
    public static final String LANDMARK_SELECT_ABOVE = "select landmark above";
    public static final String[] LANDMARK_SELECT_ABOVE_KEYS = new String[]{"ctrl UP"};
    public static final String LANDMARK_SELECT_ALL_ABOVE = "select all landmarks above";
    public static final String[] LANDMARK_SELECT_ALL_ABOVE_KEYS = new String[]{"ctrl shift UP"};
    public static final String LANDMARK_SELECT_BELOW = "select landmark below";
    public static final String[] LANDMARK_SELECT_BELOW_KEYS = new String[]{"ctrl DOWN"};
    public static final String LANDMARK_SELECT_ALL_BELOW = "select all landmarks below";
    public static final String[] LANDMARK_SELECT_ALL_BELOW_KEYS = new String[]{"ctrl shift DOWN"};
    public static final String LANDMARK_DELETE_SELECTED = "delete selected landmarks";
    public static final String[] LANDMARK_DELETE_SELECTED_KEYS = new String[]{"DELETE"};
    public static final String LANDMARK_DEACTIVATE_SELECTED = "deactivate selected landmarks";
    public static final String[] LANDMARK_DEACTIVATE_SELECTED_KEYS = new String[]{"BACK_SPACE"};
    public static final String[] LANDMARK_ACTIVATE_SELECTED_KEYS = new String[]{"ctrl BACK_SPACE"};
    public static final String LANDMARK_ACTIVATE_SELECTED = "activate selected landmarks";
    public static final String[] LANDMARK_GRID_DIALOG_KEYS = new String[]{"not mapped"};
    public static final String LANDMARK_GRID_DIALOG = "landmark grid dialog";
    public static final String MASK_IMPORT = "import mask";
    public static final String[] MASK_IMPORT_KEYS = new String[]{"ctrl shift M"};
    public static final String MASK_REMOVE = "remove mask";
    public static final String[] MASK_REMOVE_KEYS = new String[]{"alt M"};
    public static final String MASK_SIZE_EDIT = "mask edit";
    public static final String[] MASK_SIZE_EDIT_KEYS = new String[]{"M"};
    public static final String MASK_VIS_TOGGLE = "mask vis toggle";
    public static final String[] MASK_VIS_TOGGLE_KEYS = new String[]{"ctrl M"};
    public static final String SAVE_WARPED = "save warped";
    public static final String SAVE_WARPED_XML = "save warped xml";
    public static final String[] SAVE_WARPED_XML_KEYS = new String[]{"ctrl shift E"};
    public static final String EXPORT_IMAGE = "export image";
    public static final String[] EXPORT_IMAGE_KEYS = new String[]{"ctrl E"};
    public static final String EXPORT_WARP = "export warp field";
    public static final String[] EXPORT_WARP_KEYS = new String[]{"ctrl W"};
    public static final String EXPORT_AFFINE = "print affine";
    public static final String[] EXPORT_AFFINE_KEYS = new String[]{"F5"};
    public static final String CLEAR_MOVING = "table clear moving";
    public static final String[] CLEAR_MOVING_KEYS = new String[]{"BACK_SPACE"};
    public static final String CLEAR_FIXED = "table clear fixed";
    public static final String[] CLEAR_FIXED_KEYS = new String[]{"ctrl BACK_SPACE"};
    public static final String CLEAR_SELECTED_MOVING = "table clear selected moving";
    public static final String[] CLEAR_SELECTED_MOVING_KEYS = new String[]{"ctrl BACK_SPACE"};
    public static final String CLEAR_SELECTED_FIXED = "table clear selected fixed";
    public static final String[] CLEAR_SELECTED_FIXED_KEYS = new String[]{"ctrl BACK_SPACE"};
    public static final String DELETE = "table delete";
    public static final String[] DELETE_KEYS = new String[]{"not mapped"};
    public static final String DELETE_SELECTED = "table delete selected";
    public static final String[] DELETE_SELECTED_KEYS = new String[]{"DELETE"};
    public static final String ACTIVATE_SELECTED = "table activate selected";
    public static final String[] ACTIVATE_SELECTED_KEYS = new String[]{"not mapped"};
    public static final String DEACTIVATE_SELECTED = "table deactivate selected ";
    public static final String[] DEACTIVATE_SELECTED_KEYS = new String[]{"not mapped"};
    public static final String DEBUG = "debug";
    public static final String[] DEBUG_KEYS = new String[]{"F11"};
    public static final String GARBAGE_COLLECTION = "garbage collection";
    public static final String[] GARBAGE_COLLECTION_KEYS = new String[]{"F9"};
    public static final String XYPLANE = "xyPlane";
    public static final String[] XYPLANE_KEYS = new String[]{"shift Z"};
    public static final String YZPLANE = "yzPlane";
    public static final String[] YZPLANE_KEYS = new String[]{"shift X"};
    public static final String XZPLANE = "xzPlane";
    public static final String[] XZPLANE_KEYS = new String[]{"shift Y", "shift A"};

    public BigWarpActions(KeyStrokeAdder.Factory keyConfig, String name) {
        this(keyConfig, BIGWARP_CTXT, name);
    }

    public BigWarpActions(KeyStrokeAdder.Factory keyConfig, String context, String name) {
        super(keyConfig, new String[]{context, name});
    }

    public static void installViewerActions(Actions actions, BigWarpViewerFrame bwFrame, BigWarp<?> bw) {
        InputActionBindings inputActionBindings = bwFrame.getKeybindings();
        actions.install(inputActionBindings, "bw");
        actions.runnableAction(bw::saveProject, SAVE_PROJECT, SAVE_PROJECT_KEYS);
        actions.runnableAction(bw::loadProject, LOAD_PROJECT, LOAD_PROJECT_KEYS);
        actions.runnableAction(bw::saveSettings, SAVE_SETTINGS, SAVE_SETTINGS_KEYS);
        actions.runnableAction(bw::loadSettings, LOAD_SETTINGS, LOAD_SETTINGS_KEYS);
        actions.runnableAction(() -> bw.getBwTransform().transformToString(), PRINT_TRANSFORM, PRINT_TRANSFORM_KEYS);
        actions.runnableAction(bw::toggleInLandmarkMode, TOGGLE_LANDMARK_MODE, TOGGLE_LANDMARK_MODE_KEYS);
        actions.runnableAction(bw::toggleMovingImageDisplay, TOGGLE_MOVING_IMAGE_DISPLAY, TOGGLE_MOVING_IMAGE_DISPLAY_KEYS);
        actions.namedAction((AbstractNamedAction)new TogglePointsVisibleAction(TOGGLE_POINTS_VISIBLE, bw), TOGGLE_POINTS_VISIBLE_KEYS);
        actions.namedAction((AbstractNamedAction)new TogglePointNameVisibleAction(TOGGLE_POINT_NAMES_VISIBLE, bw), TOGGLE_POINT_NAMES_VISIBLE_KEYS);
        actions.runnableAction(bw::resetView, RESET_VIEWER, RESET_VIEWER_KEYS);
        actions.runnableAction(bw::matchOtherViewerPanelToActive, ALIGN_OTHER_TO_ACTIVE, ALIGN_OTHER_TO_ACTIVE_KEYS);
        actions.runnableAction(bw::matchActiveViewerPanelToOther, ALIGN_ACTIVE_TO_OTHER, ALIGN_ACTIVE_TO_OTHER_KEYS);
        actions.runnableAction(bw::jumpToSelectedLandmark, JUMP_TO_SELECTED_POINT, JUMP_TO_SELECTED_POINT_KEYS);
        actions.runnableAction(bw::jumpToNearestLandmark, JUMP_TO_NEAREST_POINT, JUMP_TO_NEAREST_POINT_KEYS);
        actions.runnableAction(bw::jumpToNextLandmark, JUMP_TO_NEXT_POINT, JUMP_TO_NEXT_POINT_KEYS);
        actions.runnableAction(bw::jumpToPrevLandmark, JUMP_TO_PREV_POINT, JUMP_TO_PREV_POINT_KEYS);
        actions.runnableAction(bw::goToBookmark, GO_TO_BOOKMARK, GO_TO_BOOKMARK_KEYS);
        actions.runnableAction(bw::goToBookmarkRotation, GO_TO_BOOKMARK_ROTATION, GO_TO_BOOKMARK_ROTATION_KEYS);
        actions.runnableAction(bw::setBookmark, SET_BOOKMARK, SET_BOOKMARK_KEYS);
        actions.runnableAction(bwFrame::expandAndFocusCardPanel, EXPAND_CARDS, EXPAND_CARDS_KEYS);
        actions.runnableAction(bwFrame::collapseCardPanel, COLLAPSE_CARDS, COLLAPSE_CARDS_KEYS);
        actions.runnableAction(() -> bw.exportAsImagePlus(false), EXPORT_IMAGE, EXPORT_IMAGE_KEYS);
        actions.runnableAction(bw::exportWarpField, EXPORT_WARP, EXPORT_WARP_KEYS);
        actions.runnableAction(() -> bw.getBwTransform().printAffine(), EXPORT_AFFINE, EXPORT_AFFINE_KEYS);
        actions.namedAction((AbstractNamedAction)new ToggleDialogAction(SHOW_HELP, (Dialog)bw.helpDialog), SHOW_HELP_KEYS);
        actions.namedAction((AbstractNamedAction)new ToggleDialogAction(VISIBILITY_AND_GROUPING_MVG, (Dialog)bw.activeSourcesDialogP), VISIBILITY_AND_GROUPING_MVG_KEYS);
        actions.namedAction((AbstractNamedAction)new ToggleDialogAction(VISIBILITY_AND_GROUPING_TGT, (Dialog)bw.activeSourcesDialogQ), VISIBILITY_AND_GROUPING_TGT_KEYS);
        actions.namedAction((AbstractNamedAction)new ToggleDialogAction(SHOW_WARPTYPE_DIALOG, (Dialog)bw.warpVisDialog), SHOW_WARPTYPE_DIALOG_KEYS);
        actions.namedAction((AbstractNamedAction)new ToggleDialogAction(PREFERENCES_DIALOG, (Dialog)bw.preferencesDialog), PREFERENCES_DIALOG_KEYS);
        for (BigWarp.WarpVisType t : BigWarp.WarpVisType.values()) {
            actions.namedAction((AbstractNamedAction)new SetWarpVisTypeAction(t, bw), new String[]{NOT_MAPPED});
        }
        actions.runnableAction(() -> bw.getLandmarkPanel().getJTable().selectAll(), LANDMARK_SELECT_ALL, new String[]{NOT_MAPPED});
        actions.runnableAction(() -> bw.getLandmarkPanel().getJTable().clearSelection(), LANDMARK_DESELECT_ALL, new String[]{NOT_MAPPED});
        actions.namedAction((AbstractNamedAction)bw.landmarkPopupMenu.deleteSelectedHandler, LANDMARK_DELETE_SELECTED_KEYS);
        actions.namedAction((AbstractNamedAction)bw.landmarkPopupMenu.activateSelectedHandler, LANDMARK_ACTIVATE_SELECTED_KEYS);
        actions.namedAction((AbstractNamedAction)bw.landmarkPopupMenu.deactivateSelectedHandler, LANDMARK_DEACTIVATE_SELECTED_KEYS);
        actions.namedAction((AbstractNamedAction)bw.landmarkPopupMenu.addAboveHandler, LANDMARK_SELECT_ABOVE_KEYS);
        actions.namedAction((AbstractNamedAction)bw.landmarkPopupMenu.addAllAboveHandler, LANDMARK_SELECT_ALL_ABOVE_KEYS);
        actions.namedAction((AbstractNamedAction)bw.landmarkPopupMenu.addBelowHandler, LANDMARK_SELECT_BELOW_KEYS);
        actions.namedAction((AbstractNamedAction)bw.landmarkPopupMenu.addAllBelowHandler, LANDMARK_SELECT_ALL_BELOW_KEYS);
        actions.runnableAction(bw::loadLandmarks, LOAD_LANDMARKS, LOAD_LANDMARKS_KEYS);
        actions.runnableAction(bw::saveLandmarks, SAVE_LANDMARKS, SAVE_LANDMARKS_KEYS);
        actions.runnableAction(bw::quickSaveLandmarks, QUICK_SAVE_LANDMARKS, QUICK_SAVE_LANDMARKS_KEYS);
        actions.namedAction((AbstractNamedAction)new UndoRedoAction(UNDO, bw), UNDO_KEYS);
        actions.namedAction((AbstractNamedAction)new UndoRedoAction(REDO, bw), REDO_KEYS);
        actions.namedAction((AbstractNamedAction)new ToggleBoxAndTexOverlayVisibility(TOGGLE_BOX_AND_TEXT_OVERLAY_VISIBLE, bw), TOGGLE_BOX_AND_TEXT_OVERLAY_VISIBLE_KEYS);
        actions.namedAction((AbstractNamedAction)new TogglePointsVisibleAction(TOGGLE_POINTS_VISIBLE, bw), TOGGLE_POINTS_VISIBLE_KEYS);
        actions.namedAction((AbstractNamedAction)new TogglePointNameVisibleAction(TOGGLE_POINT_NAMES_VISIBLE, bw), TOGGLE_POINT_NAMES_VISIBLE_KEYS);
        actions.runnableAction(() -> bw.alignActive(AbstractViewerPanel.AlignPlane.XY), XYPLANE, XYPLANE_KEYS);
        actions.runnableAction(() -> bw.alignActive(AbstractViewerPanel.AlignPlane.XZ), XZPLANE, XZPLANE_KEYS);
        actions.runnableAction(() -> bw.alignActive(AbstractViewerPanel.AlignPlane.ZY), YZPLANE, YZPLANE_KEYS);
        actions.namedAction((AbstractNamedAction)new DebugAction(DEBUG, bw), DEBUG_KEYS);
        actions.namedAction((AbstractNamedAction)new GarbageCollectionAction(GARBAGE_COLLECTION), GARBAGE_COLLECTION_KEYS);
        actions.namedAction((AbstractNamedAction)new MaskSizeEdit(bw), MASK_SIZE_EDIT_KEYS);
        actions.namedAction((AbstractNamedAction)new MaskVisToggle(bw), MASK_VIS_TOGGLE_KEYS);
        actions.namedAction((AbstractNamedAction)new MaskImport(bw), MASK_IMPORT_KEYS);
        actions.namedAction((AbstractNamedAction)new MaskRemove(bw), MASK_REMOVE_KEYS);
    }

    public static void installTableActions(Actions actions, InputActionBindings inputActionBindings, BigWarp<?> bw) {
        actions.install(inputActionBindings, "bw-table");
        actions.runnableAction(bw::saveProject, SAVE_PROJECT, SAVE_PROJECT_KEYS);
        actions.runnableAction(bw::loadProject, LOAD_PROJECT, LOAD_PROJECT_KEYS);
        actions.runnableAction(bw::saveSettings, SAVE_SETTINGS, SAVE_SETTINGS_KEYS);
        actions.runnableAction(bw::loadSettings, LOAD_SETTINGS, LOAD_SETTINGS_KEYS);
        actions.runnableAction(() -> bw.getBwTransform().transformToString(), PRINT_TRANSFORM, PRINT_TRANSFORM_KEYS);
        actions.runnableAction(bw::toggleInLandmarkMode, TOGGLE_LANDMARK_MODE, TOGGLE_LANDMARK_MODE_KEYS);
        actions.runnableAction(bw::toggleMovingImageDisplay, TOGGLE_MOVING_IMAGE_DISPLAY, TOGGLE_MOVING_IMAGE_DISPLAY_KEYS);
        actions.runnableAction(bw::resetView, RESET_VIEWER, new String[]{NOT_MAPPED});
        actions.runnableAction(bw::matchOtherViewerPanelToActive, ALIGN_OTHER_TO_ACTIVE, new String[]{NOT_MAPPED});
        actions.runnableAction(bw::matchActiveViewerPanelToOther, ALIGN_ACTIVE_TO_OTHER, new String[]{NOT_MAPPED});
        actions.runnableAction(bw::jumpToSelectedLandmark, JUMP_TO_SELECTED_POINT, new String[]{NOT_MAPPED});
        actions.runnableAction(bw::jumpToNearestLandmark, JUMP_TO_NEAREST_POINT, new String[]{NOT_MAPPED});
        actions.runnableAction(bw::jumpToNextLandmark, JUMP_TO_NEXT_POINT, new String[]{NOT_MAPPED});
        actions.runnableAction(bw::jumpToPrevLandmark, JUMP_TO_PREV_POINT, new String[]{NOT_MAPPED});
        actions.runnableAction(bw::goToBookmark, GO_TO_BOOKMARK, new String[]{NOT_MAPPED});
        actions.runnableAction(bw::goToBookmarkRotation, GO_TO_BOOKMARK_ROTATION, new String[]{NOT_MAPPED});
        actions.runnableAction(bw::setBookmark, SET_BOOKMARK, new String[]{NOT_MAPPED});
        actions.runnableAction(() -> {}, EXPAND_CARDS, new String[]{NOT_MAPPED});
        actions.runnableAction(() -> {}, COLLAPSE_CARDS, new String[]{NOT_MAPPED});
        actions.runnableAction(() -> bw.exportAsImagePlus(false), EXPORT_IMAGE, EXPORT_IMAGE_KEYS);
        actions.runnableAction(bw::exportWarpField, EXPORT_WARP, EXPORT_WARP_KEYS);
        actions.runnableAction(() -> bw.getBwTransform().printAffine(), EXPORT_AFFINE, EXPORT_AFFINE_KEYS);
        actions.namedAction((AbstractNamedAction)new ToggleDialogAction(SHOW_HELP, (Dialog)bw.helpDialog), SHOW_HELP_KEYS);
        actions.namedAction((AbstractNamedAction)new ToggleDialogAction(VISIBILITY_AND_GROUPING_MVG, (Dialog)bw.activeSourcesDialogP), VISIBILITY_AND_GROUPING_MVG_KEYS);
        actions.namedAction((AbstractNamedAction)new ToggleDialogAction(VISIBILITY_AND_GROUPING_TGT, (Dialog)bw.activeSourcesDialogQ), VISIBILITY_AND_GROUPING_TGT_KEYS);
        actions.namedAction((AbstractNamedAction)new ToggleDialogAction(SHOW_WARPTYPE_DIALOG, (Dialog)bw.warpVisDialog), SHOW_WARPTYPE_DIALOG_KEYS);
        actions.namedAction((AbstractNamedAction)new ToggleDialogAction(PREFERENCES_DIALOG, (Dialog)bw.preferencesDialog), PREFERENCES_DIALOG_KEYS);
        for (BigWarp.WarpVisType t : BigWarp.WarpVisType.values()) {
            actions.namedAction((AbstractNamedAction)new SetWarpVisTypeAction(t, bw), new String[]{NOT_MAPPED});
        }
        actions.runnableAction(() -> bw.getLandmarkPanel().getJTable().selectAll(), LANDMARK_SELECT_ALL, LANDMARK_SELECT_ALL_KEYS);
        actions.runnableAction(() -> bw.getLandmarkPanel().getJTable().clearSelection(), LANDMARK_DESELECT_ALL, LANDMARK_DESELECT_ALL_KEYS);
        actions.namedAction((AbstractNamedAction)bw.landmarkPopupMenu.deleteSelectedHandler, LANDMARK_DELETE_SELECTED_KEYS);
        actions.namedAction((AbstractNamedAction)bw.landmarkPopupMenu.activateSelectedHandler, LANDMARK_ACTIVATE_SELECTED_KEYS);
        actions.namedAction((AbstractNamedAction)bw.landmarkPopupMenu.deactivateSelectedHandler, LANDMARK_DEACTIVATE_SELECTED_KEYS);
        actions.namedAction((AbstractNamedAction)bw.landmarkPopupMenu.addAboveHandler, LANDMARK_SELECT_ABOVE_KEYS);
        actions.namedAction((AbstractNamedAction)bw.landmarkPopupMenu.addAllAboveHandler, LANDMARK_SELECT_ALL_ABOVE_KEYS);
        actions.namedAction((AbstractNamedAction)bw.landmarkPopupMenu.addBelowHandler, LANDMARK_SELECT_BELOW_KEYS);
        actions.namedAction((AbstractNamedAction)bw.landmarkPopupMenu.addAllBelowHandler, LANDMARK_SELECT_ALL_BELOW_KEYS);
        actions.runnableAction(bw::loadLandmarks, LOAD_LANDMARKS, LOAD_LANDMARKS_KEYS);
        actions.runnableAction(bw::saveLandmarks, SAVE_LANDMARKS, SAVE_LANDMARKS_KEYS);
        actions.runnableAction(bw::quickSaveLandmarks, QUICK_SAVE_LANDMARKS, QUICK_SAVE_LANDMARKS_KEYS);
        actions.namedAction((AbstractNamedAction)new LandmarkGridDialogAction(bw), LANDMARK_GRID_DIALOG_KEYS);
        actions.namedAction((AbstractNamedAction)new UndoRedoAction(UNDO, bw), UNDO_KEYS);
        actions.namedAction((AbstractNamedAction)new UndoRedoAction(REDO, bw), REDO_KEYS);
        actions.namedAction((AbstractNamedAction)new ToggleBoxAndTexOverlayVisibility(TOGGLE_BOX_AND_TEXT_OVERLAY_VISIBLE, bw), new String[]{NOT_MAPPED});
        actions.namedAction((AbstractNamedAction)new TogglePointsVisibleAction(TOGGLE_POINTS_VISIBLE, bw), TOGGLE_POINTS_VISIBLE_KEYS);
        actions.namedAction((AbstractNamedAction)new TogglePointNameVisibleAction(TOGGLE_POINT_NAMES_VISIBLE, bw), TOGGLE_POINT_NAMES_VISIBLE_KEYS);
        actions.namedAction((AbstractNamedAction)new DebugAction(DEBUG, bw), DEBUG_KEYS);
        actions.namedAction((AbstractNamedAction)new GarbageCollectionAction(GARBAGE_COLLECTION), GARBAGE_COLLECTION_KEYS);
        actions.namedAction((AbstractNamedAction)new MaskSizeEdit(bw), MASK_SIZE_EDIT_KEYS);
        actions.namedAction((AbstractNamedAction)new MaskVisToggle(bw), MASK_VIS_TOGGLE_KEYS);
        actions.namedAction((AbstractNamedAction)new MaskImport(bw), MASK_IMPORT_KEYS);
        actions.namedAction((AbstractNamedAction)new MaskRemove(bw), MASK_REMOVE_KEYS);
    }

    public static void installActionBindings(InputActionBindings inputActionBindings, BigWarp<?> bw, KeyStrokeAdder.Factory keyProperties) {
        inputActionBindings.addActionMap("bw", BigWarpActions.createActionMap(bw));
        inputActionBindings.addInputMap("bw", BigWarpActions.createInputMap(keyProperties), new String[0]);
        inputActionBindings.addActionMap("bwV", BigWarpActions.createActionMapViewer(bw));
        inputActionBindings.addInputMap("bwv", BigWarpActions.createInputMapViewer(keyProperties), new String[0]);
    }

    public static void installLandmarkPanelActionBindings(InputActionBindings inputActionBindings, BigWarp<?> bw, JTable landmarkTable, KeyStrokeAdder.Factory keyProperties) {
        inputActionBindings.addActionMap("bw", BigWarpActions.createActionMap(bw));
        inputActionBindings.addInputMap("bw", BigWarpActions.createInputMap(keyProperties), new String[0]);
        TableCellEditor celled = landmarkTable.getCellEditor(0, 1);
        Component c = celled.getTableCellEditorComponent(landmarkTable, Boolean.TRUE, true, 0, 1);
        InputMap parentInputMap = ((JCheckBox)c).getInputMap().getParent();
        parentInputMap.clear();
        KeyStroke enterDownKS = KeyStroke.getKeyStroke("pressed ENTER");
        KeyStroke enterUpKS = KeyStroke.getKeyStroke("released ENTER");
        parentInputMap.put(enterDownKS, "pressed");
        parentInputMap.put(enterUpKS, "released");
    }

    public static InputMap createInputMapViewer(KeyStrokeAdder.Factory keyProperties) {
        InputMap inputMap = new InputMap();
        KeyStrokeAdder map = keyProperties.keyStrokeAdder(inputMap, new String[0]);
        map.put(RESET_VIEWER, new String[]{"R"});
        map.put(String.format(VISIBILITY_AND_GROUPING, "moving"), new String[]{"F3"});
        map.put(String.format(VISIBILITY_AND_GROUPING, "target"), new String[]{"F4"});
        map.put(TRANSFORM_TYPE, new String[]{"F2"});
        map.put(String.format(ALIGN_VIEW_TRANSFORMS, new Object[]{AlignViewerPanelAction.TYPE.OTHER_TO_ACTIVE}), new String[]{"Q"});
        map.put(String.format(ALIGN_VIEW_TRANSFORMS, new Object[]{AlignViewerPanelAction.TYPE.ACTIVE_TO_OTHER}), new String[]{"W"});
        map.put(TOGGLE_MOVING_IMAGE_DISPLAY, new String[]{"T"});
        map.put(JUMP_TO_SELECTED_POINT, new String[]{"D"});
        map.put(JUMP_TO_NEXT_POINT, new String[]{"ctrl D"});
        map.put(JUMP_TO_PREV_POINT, new String[]{"ctrl shift D"});
        map.put(JUMP_TO_NEAREST_POINT, new String[]{"E"});
        map.put(EXPORT_IMAGE, new String[]{"ctrl E"});
        map.put(EXPORT_WARP, new String[]{"ctrl W"});
        map.put(EXPORT_AFFINE, new String[]{"ctrl A"});
        map.put(GO_TO_BOOKMARK, new String[]{"B"});
        map.put(GO_TO_BOOKMARK_ROTATION, new String[]{"O"});
        map.put(SET_BOOKMARK, new String[]{"shift B"});
        return inputMap;
    }

    public static ActionMap createActionMapViewer(BigWarp<?> bw) {
        ActionMap actionMap = new ActionMap();
        new ToggleDialogAction(String.format(VISIBILITY_AND_GROUPING, "moving"), (Dialog)bw.activeSourcesDialogP).put(actionMap);
        new ToggleDialogAction(String.format(VISIBILITY_AND_GROUPING, "target"), (Dialog)bw.activeSourcesDialogQ).put(actionMap);
        new ToggleDialogAction(TRANSFORM_TYPE, (Dialog)bw.transformSelector).put(actionMap);
        for (BigWarp.WarpVisType warpVisType : BigWarp.WarpVisType.values()) {
            new SetWarpVisTypeAction(warpVisType, bw).put(actionMap);
        }
        new ResetActiveViewerAction(bw).put(actionMap);
        new AlignViewerPanelAction(bw, AlignViewerPanelAction.TYPE.ACTIVE_TO_OTHER).put(actionMap);
        new AlignViewerPanelAction(bw, AlignViewerPanelAction.TYPE.OTHER_TO_ACTIVE).put(actionMap);
        new JumpToSelectedAction(bw).put(actionMap);
        new JumpToNextAction(bw, true).put(actionMap);
        new JumpToNextAction(bw, false).put(actionMap);
        new JumpToNearest(bw).put(actionMap);
        for (Enum enum_ : GridSource.GRID_TYPE.values()) {
            new SetWarpVisGridTypeAction(String.format(WARPVISGRID, enum_.name()), bw, (GridSource.GRID_TYPE)enum_).put(actionMap);
        }
        new SetBookmarkAction(bw).put(actionMap);
        new GoToBookmarkAction(bw).put(actionMap);
        new GoToBookmarkRotationAction(bw).put(actionMap);
        new SaveSettingsAction(bw).put(actionMap);
        new LoadSettingsAction(bw).put(actionMap);
        new SaveProjectAction(bw).put(actionMap);
        new LoadProjectAction(bw).put(actionMap);
        return actionMap;
    }

    public static InputMap createInputMap(KeyStrokeAdder.Factory keyProperties) {
        InputMap inputMap = new InputMap();
        KeyStrokeAdder map = keyProperties.keyStrokeAdder(inputMap, new String[0]);
        map.put(SHOW_WARPTYPE_DIALOG, new String[]{"U"});
        map.put(TOGGLE_LANDMARK_MODE, new String[]{"SPACE"});
        map.put(BRIGHTNESS_SETTINGS, new String[]{"S"});
        map.put(SHOW_HELP, new String[]{"F1", "H"});
        map.put(TOGGLE_POINTS_VISIBLE, new String[]{"V"});
        map.put(TOGGLE_POINT_NAMES_VISIBLE, new String[]{"N"});
        map.put(ESTIMATE_WARP, new String[]{"C"});
        map.put(MASK_SIZE_EDIT, new String[]{"M"});
        map.put(MASK_VIS_TOGGLE, new String[]{"ctrl M"});
        map.put(UNDO, new String[]{"ctrl Z"});
        map.put(REDO, new String[]{"ctrl Y"});
        map.put(REDO, new String[]{"ctrl shift Z"});
        map.put(SAVE_LANDMARKS, new String[]{"ctrl S"});
        map.put(QUICK_SAVE_LANDMARKS, new String[]{"ctrl Q"});
        map.put(LOAD_LANDMARKS, new String[]{"ctrl O"});
        map.put(CLEAR_SELECTED_MOVING, new String[]{"BACK_SPACE"});
        map.put(CLEAR_SELECTED_FIXED, new String[]{"ctrl BACK_SPACE"});
        map.put(DELETE_SELECTED, new String[]{"DELETE"});
        map.put(String.format(SELECT_TABLE_ROWS, -1), new String[]{"shift ESCAPE"});
        map.put(TOGGLE_BOX_AND_TEXT_OVERLAY_VISIBLE, new String[]{"F8"});
        map.put(GARBAGE_COLLECTION, new String[]{"F9"});
        map.put(PRINT_TRANSFORM, new String[]{"ctrl shift T"});
        map.put(DEBUG, new String[]{"F11"});
        return inputMap;
    }

    public static ActionMap createActionMap(BigWarp<?> bw) {
        ActionMap actionMap = new ActionMap();
        new ToggleLandmarkModeAction(TOGGLE_LANDMARK_MODE, bw).put(actionMap);
        new ToggleDialogAction(SHOW_WARPTYPE_DIALOG, (Dialog)bw.warpVisDialog).put(actionMap);
        new ToggleDialogAction(SHOW_HELP, (Dialog)bw.helpDialog).put(actionMap);
        new ToggleDialogAction(SHOW_SOURCE_INFO, (Dialog)bw.sourceInfoDialog).put(actionMap);
        new SaveWarpedAction(bw).put(actionMap);
        new SaveWarpedXmlAction(bw).put(actionMap);
        new ExportAffineAction(bw).put(actionMap);
        new LoadLandmarksAction(bw).put(actionMap);
        new SaveLandmarksAction(bw).put(actionMap);
        new QuickSaveLandmarksAction(bw).put(actionMap);
        new LandmarkGridDialogAction(bw).put(actionMap);
        new TogglePointsVisibleAction(TOGGLE_POINTS_VISIBLE, bw).put(actionMap);
        new TogglePointNameVisibleAction(TOGGLE_POINT_NAMES_VISIBLE, bw).put(actionMap);
        new ToggleBoxAndTexOverlayVisibility(TOGGLE_BOX_AND_TEXT_OVERLAY_VISIBLE, bw).put(actionMap);
        new ToggleMovingImageDisplayAction(TOGGLE_MOVING_IMAGE_DISPLAY, bw).put(actionMap);
        new EstimateWarpAction(ESTIMATE_WARP, bw).put(actionMap);
        new MaskSizeEdit(bw).put(actionMap);
        new MaskVisToggle(bw).put(actionMap);
        new MaskImport(bw).put(actionMap);
        new MaskRemove(bw).put(actionMap);
        for (int i = 0; i < bw.baseXfmList.length; ++i) {
            AbstractModel<?> xfm = bw.baseXfmList[i];
            new SetWarpMagBaseAction(String.format(WARPMAG_BASE, xfm.getClass().getName()), bw, i).put(actionMap);
        }
        new UndoRedoAction(UNDO, bw).put(actionMap);
        new UndoRedoAction(REDO, bw).put(actionMap);
        new TableSelectionAction(String.format(SELECT_TABLE_ROWS, -1), bw.getLandmarkPanel().getJTable(), -1).put(actionMap);
        new GarbageCollectionAction(GARBAGE_COLLECTION).put(actionMap);
        new DebugAction(DEBUG, bw).put(actionMap);
        new PrintTransformAction(PRINT_TRANSFORM, bw).put(actionMap);
        return actionMap;
    }

    public static class MaskRemove
    extends AbstractNamedAction {
        private static final long serialVersionUID = 4103338122650843631L;
        private final BigWarp<?> bw;

        public MaskRemove(BigWarp<?> bw) {
            super(BigWarpActions.MASK_REMOVE);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.removeMaskSource();
        }
    }

    public static class MaskImport
    extends AbstractNamedAction {
        private static final long serialVersionUID = 493457851797644046L;
        private final BigWarp<?> bw;

        public MaskImport(BigWarp<?> bw) {
            super(BigWarpActions.MASK_IMPORT);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.importTransformMaskSourceDialog();
        }
    }

    public static class MaskVisToggle
    extends AbstractNamedAction {
        private static final long serialVersionUID = 493457851797644046L;
        private final BigWarp<?> bw;

        public MaskVisToggle(BigWarp<?> bw) {
            super(BigWarpActions.MASK_VIS_TOGGLE);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.getViewerFrameQ().getViewerPanel().getMaskOverlay().toggleVisible();
        }
    }

    public static class MaskSizeEdit
    extends AbstractNamedAction {
        private static final long serialVersionUID = -7918625162439713732L;
        private final BigWarp<?> bw;

        public MaskSizeEdit(BigWarp<?> bw) {
            super(BigWarpActions.MASK_SIZE_EDIT);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.bw.maskSourceMouseListenerQ != null) {
                this.bw.maskSourceMouseListenerQ.toggleActive();
            }
        }
    }

    public static class LandmarkGridDialogAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 1L;
        BigWarp<?> bw;

        public LandmarkGridDialogAction(BigWarp<?> bw) {
            super(BigWarpActions.LANDMARK_GRID_DIALOG);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            LandmarkGridGenerator.fillFromDialog(this.bw);
        }
    }

    public static class SaveWarpedXmlAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = -5437508072904256758L;
        BigWarp<?> bw;

        public SaveWarpedXmlAction(BigWarp<?> bw) {
            super(BigWarpActions.SAVE_WARPED_XML);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.saveMovingImageXml();
        }
    }

    @Deprecated
    public static class SaveWarpedAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 4965249994677649713L;
        BigWarp<?> bw;

        public SaveWarpedAction(BigWarp<?> bw) {
            super(BigWarpActions.SAVE_WARPED);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.saveMovingImageToFile();
        }
    }

    public static class ExportAffineAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 9190515918045510236L;
        BigWarp<?> bw;

        public ExportAffineAction(BigWarp<?> bw) {
            super(BigWarpActions.EXPORT_AFFINE);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.getBwTransform().printAffine();
        }
    }

    public static class ExportWarpAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 4626378501415886468L;
        BigWarp<?> bw;

        public ExportWarpAction(BigWarp<?> bw) {
            super(BigWarpActions.EXPORT_WARP);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.exportWarpField();
        }
    }

    public static class ExportImagePlusAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = -8109832912959931917L;
        BigWarp<?> bw;

        public ExportImagePlusAction(BigWarp<?> bw) {
            super(BigWarpActions.EXPORT_IMAGE);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.exportAsImagePlus(false);
        }
    }

    public static class SaveLandmarksAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 7897687176745034315L;
        BigWarp<?> bw;

        public SaveLandmarksAction(BigWarp<?> bw) {
            super(BigWarpActions.SAVE_LANDMARKS);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.saveLandmarks();
        }
    }

    public static class QuickSaveLandmarksAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = -4761309639234262643L;
        BigWarp<?> bw;

        public QuickSaveLandmarksAction(BigWarp<?> bw) {
            super(BigWarpActions.QUICK_SAVE_LANDMARKS);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.quickSaveLandmarks();
        }
    }

    public static class LoadLandmarksAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = -5405137757290988030L;
        BigWarp<?> bw;

        public LoadLandmarksAction(BigWarp<?> bw) {
            super(BigWarpActions.LOAD_LANDMARKS);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.loadLandmarks();
        }
    }

    public static class JumpToNextAction
    extends AbstractNamedAction {
        final BigWarp<?> bw;
        final int inc;
        private static final long serialVersionUID = 8515568118251877405L;

        public JumpToNextAction(BigWarp<?> bw, boolean fwd) {
            super(fwd ? BigWarpActions.JUMP_TO_NEXT_POINT : BigWarpActions.JUMP_TO_PREV_POINT);
            this.bw = bw;
            this.inc = fwd ? 1 : -1;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.jumpToLandmarkRelative(this.inc);
        }
    }

    public static class JumpToNearest
    extends AbstractNamedAction {
        final BigWarp<?> bw;
        private static final long serialVersionUID = 3244181492305479433L;

        public JumpToNearest(BigWarp<?> bw) {
            super(BigWarpActions.JUMP_TO_NEAREST_POINT);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.jumpToNearestLandmark();
        }
    }

    public static class JumpToSelectedAction
    extends AbstractNamedAction {
        final BigWarp<?> bw;
        private static final long serialVersionUID = 5233843444920094805L;

        public JumpToSelectedAction(BigWarp<?> bw) {
            super(BigWarpActions.JUMP_TO_SELECTED_POINT);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.jumpToSelectedLandmark();
        }
    }

    public static class LoadProjectAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 1793182816804229398L;
        BigWarp<?> bw;

        public LoadProjectAction(BigWarp<?> bw) {
            super(BigWarpActions.LOAD_PROJECT);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.loadProject();
        }
    }

    public static class LoadSettingsAction
    extends AbstractNamedAction {
        BigWarp<?> bw;
        private static final long serialVersionUID = 1L;

        public LoadSettingsAction(BigWarp<?> bw) {
            super(BigWarpActions.LOAD_SETTINGS);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.loadSettings();
        }
    }

    public static class SaveProjectAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = -965388576691467002L;
        BigWarp<?> bw;

        public SaveProjectAction(BigWarp<?> bw) {
            super(BigWarpActions.SAVE_PROJECT);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.saveProject();
        }
    }

    public static class SaveSettingsAction
    extends AbstractNamedAction {
        BigWarp<?> bw;
        private static final long serialVersionUID = 1L;

        public SaveSettingsAction(BigWarp<?> bw) {
            super(BigWarpActions.SAVE_SETTINGS);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.saveSettings();
        }
    }

    public static class GoToBookmarkRotationAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = -6169895035295179820L;
        BigWarp<?> bw;

        public GoToBookmarkRotationAction(BigWarp<?> bw) {
            super(BigWarpActions.GO_TO_BOOKMARK_ROTATION);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.bw.getViewerFrameP().isActive()) {
                this.bw.bookmarkEditorP.initGoToBookmarkRotation();
            } else if (this.bw.getViewerFrameP().isActive()) {
                this.bw.bookmarkEditorQ.initGoToBookmarkRotation();
            }
        }
    }

    public static class GoToBookmarkAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 8777199828772379323L;
        BigWarp<?> bw;

        public GoToBookmarkAction(BigWarp<?> bw) {
            super(BigWarpActions.GO_TO_BOOKMARK);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.goToBookmark();
        }
    }

    public static class SetBookmarkAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = -4060308986781809606L;
        BigWarp<?> bw;

        public SetBookmarkAction(BigWarp<?> bw) {
            super(BigWarpActions.SET_BOOKMARK);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.bw.getViewerFrameP().isActive()) {
                this.bw.bookmarkEditorP.initSetBookmark();
            } else if (this.bw.getViewerFrameQ().isActive()) {
                this.bw.bookmarkEditorQ.initSetBookmark();
            }
        }
    }

    public static class TableSelectionAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = -4647679094757721276L;
        private final JTable table;
        private final int selection;

        public TableSelectionAction(String name, JTable table, int selection) {
            super(name);
            this.table = table;
            this.selection = selection;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.selection < 0 || this.selection >= this.table.getRowCount()) {
                this.table.removeRowSelectionInterval(0, this.table.getRowCount() - 1);
            } else {
                this.table.setRowSelectionInterval(this.selection, this.selection);
            }
        }
    }

    public static class SetWarpVisTypeAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 7370813069619338918L;
        private BigWarp<?> bw;
        private BigWarp.WarpVisType type;

        public SetWarpVisTypeAction(BigWarp.WarpVisType type, BigWarp<?> bw) {
            super(SetWarpVisTypeAction.getName(type));
            this.bw = bw;
            this.type = type;
        }

        @Deprecated
        public SetWarpVisTypeAction(BigWarp.WarpVisType type, BigWarp<?> bw, BigWarpViewerFrame p) {
            this(type, bw);
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.setWarpVisMode(this.type);
        }

        @Deprecated
        public static String getName(BigWarp.WarpVisType type, BigWarpViewerFrame p) {
            return SetWarpVisTypeAction.getName(type);
        }

        protected static String getName(BigWarp.WarpVisType type) {
            return String.format(BigWarpActions.SET_WARPTYPE_VIS, type.name());
        }
    }

    public static class SetWarpVisGridTypeAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 7370813069619338918L;
        private final BigWarp<?> bw;
        private final GridSource.GRID_TYPE type;

        public SetWarpVisGridTypeAction(String name, BigWarp<?> bw, GridSource.GRID_TYPE type) {
            super(name);
            this.bw = bw;
            this.type = type;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.setWarpVisGridType(this.type);
        }
    }

    public static class SetWarpMagBaseAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 7370813069619338918L;
        private BigWarp<?> bw;
        private int i;

        public SetWarpMagBaseAction(String name, BigWarp<?> bw, int i) {
            super(name);
            this.bw = bw;
            this.i = i;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.setWarpMagBaselineIndex(this.i);
        }
    }

    public static class AlignViewerPanelAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = -7023242695323421450L;
        private BigWarp<?> bw;
        private TYPE type;

        public AlignViewerPanelAction(BigWarp<?> bw, TYPE type) {
            super(String.format(BigWarpActions.ALIGN_VIEW_TRANSFORMS, new Object[]{type}));
            this.bw = bw;
            this.type = type;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.type == TYPE.ACTIVE_TO_OTHER) {
                this.bw.matchActiveViewerPanelToOther();
            } else {
                this.bw.matchOtherViewerPanelToActive();
            }
        }

        public static enum TYPE {
            ACTIVE_TO_OTHER,
            OTHER_TO_ACTIVE;

        }
    }

    public static class ResetActiveViewerAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = -130575800163574517L;
        private BigWarp<?> bw;

        public ResetActiveViewerAction(BigWarp<?> bw) {
            super(String.format(BigWarpActions.RESET_VIEWER, new Object[0]));
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.resetView();
        }
    }

    public static class TogglePointsVisibleAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 8747830204501341125L;
        private BigWarp<?> bw;

        public TogglePointsVisibleAction(String name, BigWarp<?> bw) {
            super(name);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.togglePointVisibility();
        }
    }

    public static class ToggleBoxAndTexOverlayVisibility
    extends AbstractNamedAction {
        private static final long serialVersionUID = -900781969157241037L;
        private BigWarp<?> bw;

        public ToggleBoxAndTexOverlayVisibility(String name, BigWarp<?> bw) {
            super(name);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            Prefs.showTextOverlay((!Prefs.showTextOverlay() ? 1 : 0) != 0);
            Prefs.showMultibox((!Prefs.showMultibox() ? 1 : 0) != 0);
            this.bw.getViewerFrameP().repaint();
            this.bw.getViewerFrameQ().repaint();
        }
    }

    public static class TogglePointNameVisibleAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 2639535533224809586L;
        private BigWarp<?> bw;

        public TogglePointNameVisibleAction(String name, BigWarp<?> bw) {
            super(name);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.toggleNameVisibility();
        }
    }

    public static class ToggleMovingImageDisplayAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 6495981071796613953L;
        private BigWarp<?> bw;

        public ToggleMovingImageDisplayAction(String name, BigWarp<?> bw) {
            super(name);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.toggleMovingImageDisplay();
        }
    }

    public static class EstimateWarpAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = -210012348709096037L;
        private BigWarp<?> bw;

        public EstimateWarpAction(String name, BigWarp<?> bw) {
            super(name);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.restimateTransformation();
        }
    }

    public static class DebugAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 7408679512565343805L;
        private BigWarp<?> bw;

        public DebugAction(String name, BigWarp<?> bw) {
            super(name);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("Debug");
            this.bw.data.sourceInfos.values().stream().forEach(x -> System.out.println(x.getSourceAndConverter().getSpimSource().getName()));
        }
    }

    public static class PrintTransformAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 6065343788485350279L;
        private BigWarp<?> bw;

        public PrintTransformAction(String name, BigWarp<?> bw) {
            super(name);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.getBwTransform().transformToString();
        }
    }

    public static class GarbageCollectionAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = -4487441057212703143L;

        public GarbageCollectionAction(String name) {
            super(name);
        }

        public void actionPerformed(ActionEvent e) {
            System.out.println("GARBAGE COLLECTION");
            System.gc();
        }
    }

    public static class ToggleAlwaysEstimateTransformAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 2909830484701853577L;
        private BigWarpViewerFrame bwvp;

        public ToggleAlwaysEstimateTransformAction(String name, BigWarpViewerFrame bwvp) {
            super(name);
            this.bwvp = bwvp;
        }

        public void actionPerformed(ActionEvent e) {
            this.bwvp.getViewerPanel().toggleUpdateOnDrag();
        }
    }

    public static class ToggleLandmarkModeAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 234323425930019L;
        private BigWarp<?> bw;

        public ToggleLandmarkModeAction(String name, BigWarp<?> bw) {
            super(name);
            this.bw = bw;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.setInLandmarkMode(!this.bw.inLandmarkMode);
        }
    }

    public static class LandmarkModeAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = 4079013525930019558L;
        private BigWarp<?> bw;
        private final boolean isOn;

        public LandmarkModeAction(String name, BigWarp<?> bw, boolean on) {
            super(name);
            this.bw = bw;
            this.isOn = on;
        }

        public void actionPerformed(ActionEvent e) {
            this.bw.setInLandmarkMode(this.isOn);
        }
    }

    public static class UndoRedoAction
    extends AbstractNamedAction {
        private static final long serialVersionUID = -5413579107763110117L;
        private BigWarp<?> bw;
        private boolean isRedo;

        public UndoRedoAction(String name, BigWarp<?> bw) {
            super(name);
            this.bw = bw;
            this.isRedo = false;
            if (name.equals(BigWarpActions.REDO)) {
                this.isRedo = true;
            }
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (this.isRedo) {
                    this.bw.getLandmarkPanel().getTableModel().getUndoManager().redo();
                    this.bw.message.showMessage("Redo");
                } else {
                    this.bw.getLandmarkPanel().getTableModel().getUndoManager().undo();
                    this.bw.message.showMessage("Undo");
                }
                if (this.bw.updateWarpOnPtChange) {
                    this.bw.restimateTransformation();
                }
                this.bw.getLandmarkPanel().repaint();
            }
            catch (Exception ex) {
                if (this.isRedo) {
                    this.bw.message.showMessage("Can't redo");
                }
                this.bw.message.showMessage("Can't undo");
            }
        }
    }

    @Plugin(type=CommandDescriptionProvider.class)
    public static class TableDescriptions
    extends CommandDescriptionProvider {
        public TableDescriptions() {
            super(BIGWARP, new String[]{"bw-table", BigWarpActions.BIGWARP_CTXT, "navigation"});
        }

        public void getCommandDescriptions(CommandDescriptions descriptions) {
            descriptions.add(BigWarpActions.SAVE_PROJECT, SAVE_PROJECT_KEYS, "Save a bigwarp project.");
            descriptions.add(BigWarpActions.LOAD_PROJECT, LOAD_PROJECT_KEYS, "Load a bigwarp project.");
            descriptions.add(BigWarpActions.SAVE_SETTINGS, SAVE_SETTINGS_KEYS, "Save the BigDataViewer settings to a settings.xml file.");
            descriptions.add(BigWarpActions.LOAD_SETTINGS, LOAD_SETTINGS_KEYS, "Load the BigDataViewer settings from a settings.xml file.");
            descriptions.add(BigWarpActions.CLEAR_MOVING, CLEAR_MOVING_KEYS, "Clears moving landmark under the mouse cursor.");
            descriptions.add(BigWarpActions.CLEAR_FIXED, CLEAR_FIXED_KEYS, "Clears fixed landmark under the mouse cursor.");
            descriptions.add(BigWarpActions.CLEAR_SELECTED_MOVING, CLEAR_SELECTED_MOVING_KEYS, "Clears moving landmark for currently selected row.");
            descriptions.add(BigWarpActions.CLEAR_SELECTED_FIXED, CLEAR_SELECTED_FIXED_KEYS, "Clears fixed landmark for currently selected row.");
            descriptions.add(BigWarpActions.DELETE, DELETE_KEYS, "Delete table row under the mouse cursor");
            descriptions.add(BigWarpActions.DELETE_SELECTED, DELETE_SELECTED_KEYS, "Delete all selected rows in the table");
            descriptions.add(BigWarpActions.ACTIVATE_SELECTED, ACTIVATE_SELECTED_KEYS, "Activate all selected rows in the table");
            descriptions.add(BigWarpActions.DEACTIVATE_SELECTED, DEACTIVATE_SELECTED_KEYS, "Deactivate all selected rows in the table");
            descriptions.add(BigWarpActions.LOAD_LANDMARKS, LOAD_LANDMARKS_KEYS, "Load landmark from a file.");
            descriptions.add(BigWarpActions.SAVE_LANDMARKS, SAVE_LANDMARKS_KEYS, "Save landmark from a file.");
            descriptions.add(BigWarpActions.QUICK_SAVE_LANDMARKS, QUICK_SAVE_LANDMARKS_KEYS, "Quick save landmarks.");
            descriptions.add(BigWarpActions.LANDMARK_SELECT_ALL, LANDMARK_SELECT_ALL_KEYS, "Select all landmarks.");
            descriptions.add(BigWarpActions.LANDMARK_DESELECT_ALL, LANDMARK_DESELECT_ALL_KEYS, "Deselect all landmarks.");
            descriptions.add(BigWarpActions.LANDMARK_DELETE_SELECTED, LANDMARK_DELETE_SELECTED_KEYS, "Delete selected landmarks.");
            descriptions.add(BigWarpActions.LANDMARK_ACTIVATE_SELECTED, LANDMARK_ACTIVATE_SELECTED_KEYS, "Activate selected landmarks.");
            descriptions.add(BigWarpActions.LANDMARK_DEACTIVATE_SELECTED, LANDMARK_DEACTIVATE_SELECTED_KEYS, "Deactivate selected landmarks.");
            descriptions.add(BigWarpActions.LANDMARK_SELECT_ABOVE, LANDMARK_SELECT_ABOVE_KEYS, "Add the row above the curent selection to the selection");
            descriptions.add(BigWarpActions.LANDMARK_SELECT_ALL_ABOVE, LANDMARK_SELECT_ALL_ABOVE_KEYS, "Add the all rows above the curent selection to the selection");
            descriptions.add(BigWarpActions.LANDMARK_SELECT_BELOW, LANDMARK_SELECT_BELOW_KEYS, "Add the row below the curent selection to the selection");
            descriptions.add(BigWarpActions.LANDMARK_SELECT_ALL_BELOW, LANDMARK_SELECT_ALL_BELOW_KEYS, "Add the all rows below the curent selection to the selection");
            descriptions.add(BigWarpActions.UNDO, UNDO_KEYS, "Undo the last landmark change.");
            descriptions.add(BigWarpActions.REDO, REDO_KEYS, "Redo the last landmark change.");
            descriptions.add(BigWarpActions.TOGGLE_POINTS_VISIBLE, TOGGLE_POINTS_VISIBLE_KEYS, "Toggle visibility of landmark points.");
            descriptions.add(BigWarpActions.TOGGLE_POINT_NAMES_VISIBLE, TOGGLE_POINT_NAMES_VISIBLE_KEYS, "Toggle visibility of landmark point names.");
            descriptions.add(BigWarpActions.EXPORT_IMAGE, EXPORT_IMAGE_KEYS, "Export the image");
            descriptions.add(BigWarpActions.SAVE_WARPED_XML, SAVE_WARPED_XML_KEYS, "Export moving image to BigDataViewer xml/h5.");
            descriptions.add(BigWarpActions.EXPORT_WARP, EXPORT_WARP_KEYS, "Show the dialog to export the displacement field.");
            descriptions.add(BigWarpActions.EXPORT_AFFINE, EXPORT_AFFINE_KEYS, "Print the affine transformation.");
            descriptions.add(BigWarpActions.PRINT_TRANSFORM, PRINT_TRANSFORM_KEYS, "Prints the current transformation.");
            descriptions.add(BigWarpActions.MASK_IMPORT, MASK_IMPORT_KEYS, "Imports a transformation mask from file.");
            descriptions.add(BigWarpActions.MASK_REMOVE, MASK_REMOVE_KEYS, "Remove the transformation mask.");
            descriptions.add(BigWarpActions.MASK_SIZE_EDIT, MASK_SIZE_EDIT_KEYS, "Edit the transformation mask.");
            descriptions.add(BigWarpActions.MASK_VIS_TOGGLE, MASK_VIS_TOGGLE_KEYS, "Toggles visibility of the transform mask.");
            descriptions.add(BigWarpActions.DEBUG, DEBUG_KEYS, "Print debugging information");
            descriptions.add(BigWarpActions.GARBAGE_COLLECTION, GARBAGE_COLLECTION_KEYS, "Manually trigger Java's garbage collection");
        }
    }

    @Plugin(type=CommandDescriptionProvider.class)
    public static class Descriptions
    extends CommandDescriptionProvider {
        public Descriptions() {
            super(BIGWARP, new String[]{BigWarpActions.BIGWARP_CTXT, "bw-table", "navigation"});
        }

        public void getCommandDescriptions(CommandDescriptions descriptions) {
            descriptions.add(BigWarpActions.CLOSE_DIALOG, CLOSE_DIALOG_KEYS, "Close bigwarp.");
            descriptions.add(BigWarpActions.SAVE_PROJECT, SAVE_PROJECT_KEYS, "Save a bigwarp project.");
            descriptions.add(BigWarpActions.LOAD_PROJECT, LOAD_PROJECT_KEYS, "Load a bigwarp project.");
            descriptions.add(BigWarpActions.TOGGLE_LANDMARK_MODE, TOGGLE_LANDMARK_MODE_KEYS, "Toggle landmark mode.");
            descriptions.add(BigWarpActions.TOGGLE_MOVING_IMAGE_DISPLAY, TOGGLE_MOVING_IMAGE_DISPLAY_KEYS, "Toggle landmark mode.");
            descriptions.add(BigWarpActions.SHOW_HELP, SHOW_HELP_KEYS, "Show the Help dialog.");
            descriptions.add(BigWarpActions.SHOW_WARPTYPE_DIALOG, SHOW_WARPTYPE_DIALOG_KEYS, "Show the BigWarp options dialog.");
            descriptions.add(BigWarpActions.PREFERENCES_DIALOG, PREFERENCES_DIALOG_KEYS, "Show the appearance and keymap dialog.");
            descriptions.add(BigWarpActions.BRIGHTNESS_SETTINGS, BRIGHTNESS_SETTINGS_KEYS, "Show the Brightness & Colors dialog.");
            descriptions.add(VISIBILITY_AND_GROUPING_MVG, VISIBILITY_AND_GROUPING_MVG_KEYS, "Show the Visibility&Grouping dialog for the moving frame.");
            descriptions.add(VISIBILITY_AND_GROUPING_TGT, VISIBILITY_AND_GROUPING_TGT_KEYS, "Show the Visibility&Grouping dialog for the fixed frame.");
            descriptions.add(BigWarpActions.SAVE_SETTINGS, SAVE_SETTINGS_KEYS, "Save the BigDataViewer settings to a settings.xml file.");
            descriptions.add(BigWarpActions.LOAD_SETTINGS, LOAD_SETTINGS_KEYS, "Load the BigDataViewer settings from a settings.xml file.");
            descriptions.add(BigWarpActions.SET_BOOKMARK, SET_BOOKMARK_KEYS, "Set a labeled bookmark at the current location.");
            descriptions.add(BigWarpActions.GO_TO_BOOKMARK, GO_TO_BOOKMARK_KEYS, "Retrieve a labeled bookmark location.");
            descriptions.add(BigWarpActions.GO_TO_BOOKMARK_ROTATION, GO_TO_BOOKMARK_ROTATION_KEYS, "Retrieve a labeled bookmark, set only the orientation.");
            descriptions.add(BigWarpActions.RESET_VIEWER, RESET_VIEWER_KEYS, "Resets the view to the view on startup.");
            descriptions.add(ALIGN_OTHER_TO_ACTIVE, ALIGN_OTHER_TO_ACTIVE_KEYS, "Sets the view of the non-active viewer to match the active viewer.");
            descriptions.add(ALIGN_ACTIVE_TO_OTHER, ALIGN_ACTIVE_TO_OTHER_KEYS, "Sets the view of the active viewer to match the non-active viewer.");
            descriptions.add(BigWarpActions.JUMP_TO_SELECTED_POINT, JUMP_TO_SELECTED_POINT_KEYS, "Center the viewer on the selected landmark.");
            descriptions.add(BigWarpActions.JUMP_TO_NEAREST_POINT, JUMP_TO_NEAREST_POINT_KEYS, "Center the viewer on the nearest landmark.");
            descriptions.add(BigWarpActions.JUMP_TO_NEXT_POINT, JUMP_TO_NEXT_POINT_KEYS, "Center the viewer on the next landmark.");
            descriptions.add(BigWarpActions.JUMP_TO_PREV_POINT, JUMP_TO_PREV_POINT_KEYS, "Center the viewer on the previous landmark.");
            descriptions.add(BigWarpActions.EXPAND_CARDS, EXPAND_CARDS_KEYS, "Expand and focus the BigDataViewer card panel");
            descriptions.add(BigWarpActions.COLLAPSE_CARDS, COLLAPSE_CARDS_KEYS, "Collapse the BigDataViewer card panel");
            descriptions.add(BigWarpActions.EXPORT_IMAGE, EXPORT_IMAGE_KEYS, "Export the image");
            descriptions.add(BigWarpActions.SAVE_WARPED_XML, SAVE_WARPED_XML_KEYS, "Export moving image to BigDataViewer xml/h5.");
            descriptions.add(BigWarpActions.EXPORT_WARP, EXPORT_WARP_KEYS, "Show the dialog to export the displacement field.");
            descriptions.add(BigWarpActions.EXPORT_AFFINE, EXPORT_AFFINE_KEYS, "Print the affine transformation.");
            descriptions.add(BigWarpActions.PRINT_TRANSFORM, PRINT_TRANSFORM_KEYS, "Prints the current transformation.");
            descriptions.add(BigWarpActions.LOAD_LANDMARKS, LOAD_LANDMARKS_KEYS, "Load landmark from a file.");
            descriptions.add(BigWarpActions.SAVE_LANDMARKS, SAVE_LANDMARKS_KEYS, "Save landmark from a file.");
            descriptions.add(BigWarpActions.QUICK_SAVE_LANDMARKS, QUICK_SAVE_LANDMARKS_KEYS, "Quick save landmarks.");
            descriptions.add(BigWarpActions.UNDO, UNDO_KEYS, "Undo the last landmark change.");
            descriptions.add(BigWarpActions.REDO, REDO_KEYS, "Redo the last landmark change.");
            descriptions.add(BigWarpActions.TOGGLE_POINTS_VISIBLE, TOGGLE_POINTS_VISIBLE_KEYS, "Toggle visibility of landmarks.");
            descriptions.add(BigWarpActions.TOGGLE_POINT_NAMES_VISIBLE, TOGGLE_POINT_NAMES_VISIBLE_KEYS, "Toggle visibility of landmark names.");
            descriptions.add(BigWarpActions.TOGGLE_BOX_AND_TEXT_OVERLAY_VISIBLE, TOGGLE_BOX_AND_TEXT_OVERLAY_VISIBLE_KEYS, "Toggle visibility of bounding box and source information.");
            descriptions.add(BigWarpActions.TOGGLE_POINTS_VISIBLE, TOGGLE_POINTS_VISIBLE_KEYS, "Toggle visibility of landmark points.");
            descriptions.add(BigWarpActions.TOGGLE_POINT_NAMES_VISIBLE, TOGGLE_POINT_NAMES_VISIBLE_KEYS, "Toggle visibility of landmark point names.");
            descriptions.add(BigWarpActions.LANDMARK_ACTIVATE_SELECTED, LANDMARK_ACTIVATE_SELECTED_KEYS, "Activate selected landmarks.");
            descriptions.add(BigWarpActions.LANDMARK_DEACTIVATE_SELECTED, LANDMARK_DEACTIVATE_SELECTED_KEYS, "Deactivate selected landmarks.");
            descriptions.add(BigWarpActions.LANDMARK_GRID_DIALOG, LANDMARK_GRID_DIALOG_KEYS, "Open a dialog for creating a landmark grid.");
            descriptions.add(BigWarpActions.XYPLANE, XYPLANE_KEYS, "xy plane");
            descriptions.add(BigWarpActions.XZPLANE, XZPLANE_KEYS, "xz plane");
            descriptions.add(BigWarpActions.YZPLANE, YZPLANE_KEYS, "yz plane");
            descriptions.add(BigWarpActions.DEBUG, DEBUG_KEYS, "Print debugging information");
            descriptions.add(BigWarpActions.GARBAGE_COLLECTION, GARBAGE_COLLECTION_KEYS, "Manually trigger Java's garbage collection");
            descriptions.add(BigWarpActions.MASK_IMPORT, MASK_IMPORT_KEYS, "Imports a transformation mask from file.");
            descriptions.add(BigWarpActions.MASK_REMOVE, MASK_REMOVE_KEYS, "Remove the transformation mask.");
            descriptions.add(BigWarpActions.MASK_SIZE_EDIT, MASK_SIZE_EDIT_KEYS, "Edit the transformation mask.");
            descriptions.add(BigWarpActions.MASK_VIS_TOGGLE, MASK_VIS_TOGGLE_KEYS, "Toggles visibility of the transform mask.");
            descriptions.add(BigWarpActions.DEBUG, DEBUG_KEYS, "Print debugging information");
            descriptions.add(BigWarpActions.GARBAGE_COLLECTION, GARBAGE_COLLECTION_KEYS, "Manually trigger Java's garbage collection");
        }
    }
}

