/*
 * Decompiled with CFR 0.152.
 */
package bdv.viewer;

import bdv.gui.BigWarpLandmarkPanel;
import bdv.viewer.BigWarpViewerPanel;
import bdv.viewer.BigWarpViewerSettings;
import bdv.viewer.ViewerState;
import bigwarp.landmarks.LandmarkTableModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.Arrays;
import javax.swing.JTable;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.realtransform.RealTransform;

public class BigWarpOverlay {
    private BigWarpViewerPanel viewer;
    private BigWarpLandmarkPanel landmarkPanel;
    protected RealTransform estimatedXfm;
    protected boolean isTransformed = false;
    private int hoveredIndex;
    protected final boolean isMoving;
    protected final double[] spot;
    protected final double[] viewerCoords;
    private final AffineTransform3D transform = new AffineTransform3D();

    public BigWarpOverlay(BigWarpViewerPanel viewer, BigWarpLandmarkPanel landmarkPanel) {
        this.viewer = viewer;
        this.setLandmarkPanel(landmarkPanel);
        this.isMoving = viewer.getIsMoving();
        this.spot = new double[3];
        this.viewerCoords = new double[3];
    }

    public int getHoveredIndex() {
        return this.hoveredIndex;
    }

    public void setHoveredIndex(int hoveredIndex) {
        this.hoveredIndex = hoveredIndex;
    }

    public void setLandmarkPanel(BigWarpLandmarkPanel landmarkPanel) {
        this.landmarkPanel = landmarkPanel;
    }

    public void paint(Graphics2D g) {
        if (this.viewer.getSettings().areLandmarksVisible().booleanValue()) {
            LandmarkTableModel landmarkModel = this.landmarkPanel.getTableModel();
            JTable table = this.landmarkPanel.getJTable();
            boolean is3d = this.landmarkPanel.numDimensions() == 3;
            Composite originalComposite = g.getComposite();
            Stroke originalStroke = g.getStroke();
            Color originalColor = g.getColor();
            int[] selectedRows = table.getSelectedRows();
            Arrays.sort(selectedRows);
            boolean[] isSelected = new boolean[landmarkModel.getRowCount()];
            for (int i : selectedRows) {
                isSelected[i] = true;
            }
            BasicStroke hlStroke = new BasicStroke((int)this.viewer.getSettings().strokeWeight);
            double radiusRatio = (Double)this.viewer.getSettings().get("SpotRadiusRatio");
            double radius = this.viewer.getSettings().getSpotSize();
            Stroke stroke = BigWarpViewerSettings.NORMAL_STROKE;
            FontMetrics fm = null;
            Font font = null;
            int fonthgt = 0;
            Color textBoxColorHl = null;
            Color textBoxColor = null;
            double strokeW = this.viewer.getSettings().strokeWeight;
            Color color = this.viewer.getSettings().getSpotColor();
            Color inactiveColor = this.viewer.getSettings().getSpotColor();
            if (this.viewer.getSettings().areNamesVisible().booleanValue()) {
                font = g.getFont().deriveFont(this.viewer.getSettings().fontSize);
                g.setFont(font);
                fm = g.getFontMetrics(g.getFont());
                fonthgt = fm.getHeight();
                textBoxColor = Color.BLACK;
                textBoxColorHl = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
                textBoxColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 128);
            }
            int nRows = landmarkModel.getRowCount();
            for (int index = 0; index < nRows; ++index) {
                if (landmarkModel.isActive(index)) {
                    g.setColor(color);
                } else {
                    g.setColor(inactiveColor);
                }
                g.setStroke(stroke);
                landmarkModel.copyPointSafe(this.spot, index, this.isMoving);
                boolean copySuccess = false;
                copySuccess = this.isMoving ? (this.viewer.isInFixedImageSpace() ? (landmarkModel.isWarped(index).booleanValue() ? landmarkModel.copyWarpedPointSafe(this.spot, index) : landmarkModel.copyTargetPointSafe(this.spot, index)) : landmarkModel.copyMovingPointSafe(this.spot, index)) : landmarkModel.copyTargetPointSafe(this.spot, index);
                if (!copySuccess || Double.isInfinite(this.spot[0])) continue;
                this.transform.apply(this.spot, this.viewerCoords);
                double rad = radius * radiusRatio;
                double zv = this.viewerCoords[2];
                double dz2 = zv * zv;
                if (is3d && !(dz2 < rad * rad)) continue;
                double arad = is3d ? Math.sqrt(rad * rad - dz2) : rad;
                double srad = arad + strokeW;
                g.fillOval((int)(this.viewerCoords[0] - arad), (int)(this.viewerCoords[1] - arad), (int)(2.0 * arad + 1.0), (int)(2.0 * arad + 1.0));
                if (isSelected[index]) {
                    g.setStroke(hlStroke);
                    g.setColor(Color.WHITE);
                    g.drawOval((int)(this.viewerCoords[0] - arad - 2.0), (int)(this.viewerCoords[1] - arad - 2.0), (int)(2.0 * arad + 4.0), (int)(2.0 * arad + 4.0));
                }
                if (this.hoveredIndex == index) {
                    g.setStroke(hlStroke);
                    g.setColor(new Color(color.getRed(), color.getGreen(), color.getBlue(), 128));
                    g.drawOval((int)(this.viewerCoords[0] - srad - 2.0), (int)(this.viewerCoords[1] - srad - 2.0), (int)(2.0 * srad + 4.0), (int)(2.0 * srad + 4.0));
                    g.setColor(color);
                    g.setStroke(stroke);
                }
                if (!this.viewer.getSettings().areNamesVisible().booleanValue()) continue;
                int tx = (int)(this.viewerCoords[0] + arad + 5.0);
                int ty = (int)this.viewerCoords[1];
                String name = landmarkModel.getNames().get(index);
                int strwidth = fm.stringWidth(name);
                if (this.hoveredIndex == index) {
                    g.setColor(textBoxColorHl);
                } else {
                    g.setColor(textBoxColor);
                }
                g.fillRect(tx - 1, ty - fonthgt + 2, strwidth + 2, fonthgt);
                g.setColor(Color.BLACK);
                g.setFont(font);
                g.drawString(name, tx, ty);
            }
            g.setComposite(originalComposite);
            g.setStroke(originalStroke);
            g.setColor(originalColor);
        }
    }

    public void setViewerState(ViewerState state) {
        state.getViewerTransform(this.transform);
    }

    public void setEstimatedTransform(RealTransform estimatedXfm) {
        this.estimatedXfm = estimatedXfm;
    }

    public boolean getIsTransformed() {
        return this.isTransformed;
    }

    public void setIsTransformed(boolean isTransformed) {
        this.isTransformed = isTransformed;
    }
}

