/*
 * Decompiled with CFR 0.152.
 */
package bdv.gui;

import bigwarp.BigWarp;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class TransformTypePanel
extends JPanel {
    private static final long serialVersionUID = 3285885870885172257L;
    private static final String TRANSFORM_TYPE_HELP_TEXT = "Select the type of transformation.";
    public static final String[] TRANSFORM_TYPE_STRINGS = new String[]{"Thin Plate Spline", "Affine", "Similarity", "Rotation", "Translation"};
    private final BigWarp<?> bw;
    private final JLabel transformTypeLabel;
    private final JComboBox<String> transformTypeDropdown;
    private boolean active;

    public TransformTypePanel(final BigWarp<?> bw) {
        super(new GridBagLayout());
        this.bw = bw;
        this.active = true;
        this.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(4, 2, 4, 2), BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Transformation options"), BorderFactory.createEmptyBorder(2, 2, 2, 2))));
        this.transformTypeLabel = new JLabel("Transform type");
        this.transformTypeLabel.setToolTipText(TRANSFORM_TYPE_HELP_TEXT);
        this.transformTypeDropdown = new JComboBox<String>(TRANSFORM_TYPE_STRINGS);
        this.getTransformTypeDropdown().setToolTipText(TRANSFORM_TYPE_HELP_TEXT);
        this.getTransformTypeDropdown().addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TransformTypePanel.this.active) {
                    String type = (String)TransformTypePanel.this.transformTypeDropdown.getSelectedItem();
                    bw.setTransformType(type);
                    bw.updateTransformTypeDialog(type);
                }
            }
        });
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.gridwidth = 1;
        gbc.gridheight = 1;
        gbc.weightx = 0.0;
        gbc.weighty = 0.0;
        gbc.anchor = 22;
        gbc.fill = 0;
        gbc.insets = new Insets(5, 5, 5, 5);
        this.add((Component)this.transformTypeLabel, gbc);
        gbc.gridx = 2;
        gbc.weightx = 0.0;
        gbc.anchor = 21;
        this.add(this.getTransformTypeDropdown(), gbc);
    }

    public JComboBox<String> getTransformTypeDropdown() {
        return this.transformTypeDropdown;
    }

    public void setType(String type) {
        this.transformTypeDropdown.setSelectedItem(type);
    }

    public void deactivate() {
        this.active = false;
    }

    public void activate() {
        this.active = true;
    }
}

