/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.gui.controller;

import java.net.URL;
import java.util.ResourceBundle;
import javafx.event.Event;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.web.WebView;
import org.scijava.Context;
import org.scijava.app.StatusService;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.FilamentWorkflow;
import sc.fiji.filamentdetector.gui.controller.AbstractController;

public class WelcomeController
extends AbstractController
implements Initializable {
    private static String FXML_PATH = "/sc/fiji/filamentdetector/gui/view/WelcomeView.fxml";
    @Parameter
    private LogService log;
    @Parameter
    private StatusService status;
    @FXML
    private WebView welcomeTextField;
    @FXML
    private Label activeImageLabel;
    @FXML
    private TextField pixelWidthField;
    @FXML
    private Label pixelWidthUnitLabel;
    @FXML
    private TextField pixelHeightField;
    @FXML
    private Label pixelHeightUnitLabel;
    @FXML
    private TextField voxelDepthField;
    @FXML
    private Label voxelDepthUnitLabel;
    @FXML
    private TextField timeIntervalField;
    @FXML
    private Label timeIntervalUnitLabel;
    @FXML
    private ComboBox<String> channelComboBox;
    private FilamentWorkflow filamentDetector;

    public WelcomeController(Context context, FilamentWorkflow filamentDetector) {
        context.inject((Object)this);
        this.filamentDetector = filamentDetector;
        this.setFXMLPath(FXML_PATH);
    }

    public void initialize(URL url, ResourceBundle resourceBundle) {
        this.welcomeTextField.setContextMenuEnabled(false);
        this.loadWelcomeText();
    }

    private void loadWelcomeText() {
        String text = "<h1><a id=\"Welcome_to_FilamentDetector_0\"></a>Welcome to FilamentDetector</h1>\n<p><strong>FilamentDetector</strong> allows you to <em>detect</em> and <em>track</em> filaments in an image or a stack of images. <strong>Detection</strong> is done independently on all the images while <strong>tracking</strong> is done on the whole stack in the TIME dimension.</p>\n<p>Once those steps are done, you can <strong>export the data</strong> to CSV files, saves detected filaments as <strong>kymographs</strong>, or run a <strong>specific analysis module</strong> (to analyze microtubule dynamics for example).</p>\n";
        this.welcomeTextField.getEngine().loadContent(text);
    }

    public void loadImageCalibrations() {
        this.activeImageLabel.setText(this.filamentDetector.getImageDisplay().getName());
        this.pixelWidthField.setText(Double.toString(this.filamentDetector.getCalibrations().getDx()));
        this.pixelHeightField.setText(Double.toString(this.filamentDetector.getCalibrations().getDy()));
        this.voxelDepthField.setText(Double.toString(this.filamentDetector.getCalibrations().getDz()));
        this.timeIntervalField.setText(Double.toString(this.filamentDetector.getCalibrations().getDt()));
        this.pixelWidthUnitLabel.setText(this.filamentDetector.getCalibrations().getUnitX());
        this.pixelHeightUnitLabel.setText(this.filamentDetector.getCalibrations().getUnitY());
        this.voxelDepthUnitLabel.setText(this.filamentDetector.getCalibrations().getUnitZ());
        this.timeIntervalUnitLabel.setText(this.filamentDetector.getCalibrations().getUnitT());
        this.channelComboBox.getItems().addAll(this.filamentDetector.getCalibrations().getChannelList());
        this.channelComboBox.getSelectionModel().selectFirst();
        if (this.filamentDetector.getCalibrations().getSizeZ() <= 1.0) {
            this.voxelDepthField.setDisable(true);
        } else {
            this.voxelDepthField.setDisable(false);
        }
    }

    @FXML
    void writeCalibration(Event event) {
        this.filamentDetector.getCalibrations().setDx(Double.parseDouble(this.pixelWidthField.getText()));
        this.filamentDetector.getCalibrations().setDy(Double.parseDouble(this.pixelHeightField.getText()));
        this.filamentDetector.getCalibrations().setDz(Double.parseDouble(this.voxelDepthField.getText()));
        this.filamentDetector.getCalibrations().setDt(Double.parseDouble(this.timeIntervalField.getText()));
        this.filamentDetector.getCalibrations().channelToUse((String)this.channelComboBox.getSelectionModel().getSelectedItem());
        this.status.showStatus("Image calibrations and channel to use have been updated.");
    }
}

