/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.filamentdetector.analyzer.tipfitter;

import ij.gui.Plot;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.imagej.display.ImageDisplay;
import org.apache.commons.math3.analysis.polynomials.PolynomialFunction;
import org.apache.commons.math3.analysis.solvers.LaguerreSolver;
import org.apache.commons.math3.complex.Complex;
import org.apache.commons.math3.fitting.PolynomialCurveFitter;
import org.apache.commons.math3.fitting.WeightedObservedPoints;
import org.scijava.Context;
import org.scijava.log.LogService;
import org.scijava.plugin.Parameter;
import sc.fiji.filamentdetector.GeometryUtils;
import sc.fiji.filamentdetector.model.Filament;
import sc.fiji.filamentdetector.model.TrackedFilament;
import sc.fiji.filamentdetector.model.TrackedFilaments;

public class FilamentTipFitter {
    @Parameter
    private Context context;
    @Parameter
    private LogService log;
    private TrackedFilaments seeds;
    private Map<TrackedFilament, TrackedFilament> side1Filaments;
    private Map<TrackedFilament, TrackedFilament> side2Filaments;
    private ImageDisplay imageDisplay;
    private int polynomDegree = 5;
    private double relativePositionFromEnd = 0.5;
    private double lineFitLength = 20.0;
    private int channelIndex = 0;
    private double lineWidth = 4.0;

    public FilamentTipFitter(Context context) {
        context.inject((Object)this);
    }

    public void fit() {
        this.side1Filaments = new HashMap<TrackedFilament, TrackedFilament>();
        this.side2Filaments = new HashMap<TrackedFilament, TrackedFilament>();
        for (TrackedFilament seed : this.seeds) {
            TrackedFilament side1Filament = new TrackedFilament();
            TrackedFilament side2Filament = new TrackedFilament();
            for (Filament singleSeed : seed) {
                Filament filament = this.fitSeed(singleSeed, true);
                if (filament != null) {
                    side1Filament.add(filament);
                }
                if ((filament = this.fitSeed(singleSeed, false)) == null) continue;
                side2Filament.add(filament);
            }
            if (side1Filament.size() > 0) {
                side1Filament.setColor(seed.getColor());
                this.side1Filaments.put(seed, side1Filament);
            }
            if (side2Filament.size() <= 0) continue;
            side2Filament.setColor(seed.getColor());
            this.side2Filaments.put(seed, side2Filament);
        }
    }

    private Filament fitSeed(Filament filament, boolean fitFromStart) {
        double[] otherTip;
        double[] seedTip;
        if (fitFromStart) {
            seedTip = new double[]{filament.getTips()[0], filament.getTips()[1]};
            otherTip = new double[]{filament.getTips()[2], filament.getTips()[3]};
        } else {
            seedTip = new double[]{filament.getTips()[2], filament.getTips()[3]};
            otherTip = new double[]{filament.getTips()[0], filament.getTips()[1]};
        }
        double[] fitEnd = GeometryUtils.getPointOnVectorFromDistance(seedTip, otherTip, -this.lineFitLength);
        double[] x = new double[]{seedTip[0], fitEnd[0]};
        double[] y = new double[]{seedTip[1], fitEnd[1]};
        Filament fitLine = new Filament(x, y, filament.getFrame());
        double[] intensities = fitLine.getIntensitiesAsArray(this.context, this.imageDisplay, this.channelIndex, this.lineWidth);
        double[] positions = IntStream.range(0, intensities.length).mapToDouble(i -> i).toArray();
        WeightedObservedPoints points = new WeightedObservedPoints();
        for (int i2 = 0; i2 < intensities.length; ++i2) {
            points.add((double)i2, intensities[i2]);
        }
        LaguerreSolver laguerreSolver = new LaguerreSolver();
        PolynomialCurveFitter fitter = PolynomialCurveFitter.create((int)this.polynomDegree);
        double[] coeff = fitter.fit((Collection)points.toList());
        PolynomialFunction func = new PolynomialFunction(coeff);
        Complex[] roots = laguerreSolver.solveAllComplex(func.polynomialDerivative().getCoefficients(), 0.0);
        List xRoots = Arrays.stream(roots).map(v -> v.getReal()).filter(v -> v < (double)intensities.length).filter(v -> v > 0.0).collect(Collectors.toList());
        double[] diff = IntStream.range(0, xRoots.size() - 1).mapToDouble(i -> (Double)xRoots.get(i + 1) - (Double)xRoots.get(i)).toArray();
        if (diff.length == 0) {
            return null;
        }
        int maxIndex = IntStream.range(0, diff.length).reduce((i, j) -> diff[i] < diff[j] ? j : i).getAsInt();
        double startPosition = (Double)xRoots.get(maxIndex);
        double endPosition = (Double)xRoots.get(maxIndex + 1);
        double tipPosition1D = endPosition - (endPosition - startPosition) / (1.0 / this.relativePositionFromEnd);
        double[] tipPosition = GeometryUtils.getPointOnVectorFromDistance(fitLine.getStartTipAsArray(), fitLine.getEndTipAsArray(), tipPosition1D);
        boolean debug = false;
        if (debug) {
            Plot plot = new Plot("", "", "", positions, Arrays.stream(positions).map(i -> func.value(i)).toArray());
            plot.addPoints(positions, intensities, 1);
            plot.show();
            Plot plot2 = new Plot("", "", "", positions, Arrays.stream(positions).map(i -> func.polynomialDerivative().value(i)).toArray());
            plot2.show();
        }
        x = new double[]{seedTip[0], tipPosition[0]};
        y = new double[]{seedTip[1], tipPosition[1]};
        Filament trueFilament = new Filament(x, y, filament.getFrame());
        trueFilament.setColor(filament.getColor());
        return trueFilament;
    }

    public TrackedFilaments getSeeds() {
        return this.seeds;
    }

    public Map<TrackedFilament, TrackedFilament> getSide1Filaments() {
        return this.side1Filaments;
    }

    public Map<TrackedFilament, TrackedFilament> getSide2Filaments() {
        return this.side2Filaments;
    }

    public int getPolynomDegree() {
        return this.polynomDegree;
    }

    public void setPolynomDegree(int polynomDegree) {
        this.polynomDegree = polynomDegree;
    }

    public double getRelativePositionFromEnd() {
        return this.relativePositionFromEnd;
    }

    public void setRelativePositionFromEnd(double relativePositionFromEnd) {
        this.relativePositionFromEnd = relativePositionFromEnd;
    }

    public double getLineFitLength() {
        return this.lineFitLength;
    }

    public void setLineFitLength(double lineFitLength) {
        this.lineFitLength = lineFitLength;
    }

    public ImageDisplay getImageDisplay() {
        return this.imageDisplay;
    }

    public int getChannelIndex() {
        return this.channelIndex;
    }

    public void setChannelIndex(int channelIndex) {
        this.channelIndex = channelIndex;
    }

    public double getLineWidth() {
        return this.lineWidth;
    }

    public void setLineWidth(double lineWidth) {
        this.lineWidth = lineWidth;
    }

    public void setSeeds(TrackedFilaments seeds) {
        this.seeds = seeds;
    }

    public void setImageDisplay(ImageDisplay imageDisplay) {
        this.imageDisplay = imageDisplay;
    }
}

