/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.algorithm.util.Grids;
import net.imglib2.util.Intervals;

public class ParallelizeOverBlocks {
    public static <T> List<T> parallelizeAndWait(Function<Interval, T> func, Interval interval, int[] blockSize, ExecutorService es, int numTasks) throws InterruptedException, ExecutionException {
        return ParallelizeOverBlocks.parallelizeAndWait(func, Intervals.minAsLongArray(interval), Intervals.maxAsLongArray(interval), blockSize, es, numTasks);
    }

    public static <T> List<Future<List<T>>> parallelize(Function<Interval, T> func, Interval interval, int[] blockSize, ExecutorService es, int numTasks) {
        return ParallelizeOverBlocks.parallelize(func, Intervals.minAsLongArray(interval), Intervals.maxAsLongArray(interval), blockSize, es, numTasks);
    }

    public static <T> List<T> parallelizeAndWait(Function<Interval, T> func, long[] min, long[] max, int[] blockSize, ExecutorService es, int numTasks) throws InterruptedException, ExecutionException {
        List<Future<List<T>>> futures = ParallelizeOverBlocks.parallelize(func, min, max, blockSize, es, numTasks);
        ArrayList results = new ArrayList();
        for (Future<List<T>> future : futures) {
            results.addAll(future.get());
        }
        return results;
    }

    public static <T> List<Future<List<T>>> parallelize(Function<Interval, T> func, long[] min, long[] max, int[] blockSize, ExecutorService es, int numTasks) {
        List<Interval> blocks = Grids.collectAllOffsets(min, max, blockSize, blockMin -> {
            long[] blockMax = new long[((long[])blockMin).length];
            for (int d = 0; d < blockMax.length; ++d) {
                blockMax[d] = Math.min(blockMin[d] + (long)blockSize[d] - 1L, max[d]);
            }
            return new FinalInterval((long[])blockMin, blockMax);
        });
        return ParallelizeOverBlocks.parallelize(func, blocks, es, numTasks);
    }

    public static <T> List<T> parallelizeAndWait(Function<Interval, T> func, List<Interval> blocks, ExecutorService es, int numTasks) throws InterruptedException, ExecutionException {
        List<Future<List<T>>> futures = ParallelizeOverBlocks.parallelize(func, blocks, es, numTasks);
        ArrayList results = new ArrayList();
        for (Future<List<T>> future : futures) {
            results.addAll(future.get());
        }
        return results;
    }

    public static <T> List<Future<List<T>>> parallelize(Function<Interval, T> func, List<Interval> blocks, ExecutorService es, int numTasks) {
        ArrayList<Future<List<T>>> futures = new ArrayList<Future<List<T>>>();
        int taskSize = Math.max(blocks.size() / numTasks, 1);
        int i = 0;
        while (i < blocks.size()) {
            int finalI = i++;
            futures.add(es.submit(() -> blocks.subList(finalI, finalI + taskSize).stream().map(func).collect(Collectors.toList())));
        }
        return futures;
    }

    public static <T> Function<T, Void> ofConsumer(Consumer<T> consumer) {
        return t -> {
            consumer.accept(t);
            return null;
        };
    }
}

