/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.gauss;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccessible;
import net.imglib2.algorithm.gauss.AbstractGauss;
import net.imglib2.algorithm.gauss.SamplingLineIterator;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.view.Views;

@Deprecated
public final class GaussDouble
extends AbstractGauss<DoubleType> {
    protected boolean isArray;

    public GaussDouble(double[] sigma, RandomAccessible<DoubleType> input, Interval interval, ImgFactory<DoubleType> factory) {
        super(sigma, input, interval, factory.create(interval, new DoubleType()), new Point(sigma.length), factory, new DoubleType());
    }

    public GaussDouble(double[] sigma, RandomAccessible<DoubleType> input, Interval interval, RandomAccessible<DoubleType> output, Localizable outputOffset, ImgFactory<DoubleType> factory) {
        super(sigma, input, interval, output, outputOffset, factory, new DoubleType());
    }

    public GaussDouble(double[] sigma, Img<DoubleType> input) {
        this(sigma, Views.extend(input, new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE)), input, input.factory());
    }

    public GaussDouble(double[] sigma, Img<DoubleType> input, OutOfBoundsFactory<DoubleType, Img<DoubleType>> outOfBounds) {
        this(sigma, Views.extend(input, outOfBounds), input, input.factory());
    }

    public static Img<DoubleType> gauss(double[] sigma, Img<DoubleType> input) {
        GaussDouble gauss = new GaussDouble(sigma, input);
        gauss.call();
        return (Img)gauss.getResult();
    }

    public static Img<DoubleType> gauss(double[] sigma, Img<DoubleType> input, OutOfBoundsFactory<DoubleType, Img<DoubleType>> outOfBounds) {
        GaussDouble gauss = new GaussDouble(sigma, input, outOfBounds);
        gauss.call();
        return (Img)gauss.getResult();
    }

    public static Img<DoubleType> gauss(double[] sigma, RandomAccessible<DoubleType> input, Interval interval, ImgFactory<DoubleType> factory) {
        GaussDouble gauss = new GaussDouble(sigma, input, interval, factory);
        gauss.call();
        return (Img)gauss.getResult();
    }

    public static void gauss(double[] sigma, RandomAccessible<DoubleType> input, Interval interval, RandomAccessible<DoubleType> output, Localizable outputOffset, ImgFactory<DoubleType> factory) {
        GaussDouble gauss = new GaussDouble(sigma, input, interval, output, outputOffset, factory);
        gauss.call();
    }

    @Override
    protected Img<DoubleType> getProcessingLine(long sizeProcessLine) {
        NativeImg processLine;
        if (sizeProcessLine <= Integer.MAX_VALUE) {
            this.isArray = true;
            processLine = new ArrayImgFactory().create(new long[]{sizeProcessLine}, new DoubleType());
        } else {
            this.isArray = false;
            processLine = new CellImgFactory(0x7FFFFFF).create(new long[]{sizeProcessLine}, new DoubleType());
        }
        return processLine;
    }

    @Override
    protected void processLine(SamplingLineIterator<DoubleType> input, double[] kernel) {
        if (!this.isArray()) {
            super.processLine(input, kernel);
            return;
        }
        int kernelSize = kernel.length;
        int kernelSizeMinus1 = kernelSize - 1;
        int kernelSizeHalf = kernelSize / 2;
        int kernelSizeHalfMinus1 = kernelSizeHalf - 1;
        double[] v = ((DoubleArray)((NativeImg)input.getProcessLine()).update(null)).getCurrentStorageArray();
        int imgSize = v.length;
        int indexLeft = 0;
        int indexRight = 0;
        if (imgSize >= kernelSize) {
            v[0] = v[0] + input.get().get() * kernel[0];
            for (int i = 1; i < kernelSizeMinus1; ++i) {
                input.fwd();
                double copy = input.get().get();
                indexLeft = -1;
                for (int o = 0; o <= i; ++o) {
                    int n = ++indexLeft;
                    v[n] = v[n] + copy * kernel[i - o];
                }
            }
            int length = imgSize - kernelSizeMinus1;
            for (int n = 0; n < length; ++n) {
                input.fwd();
                double copy = input.get().get();
                indexLeft = n;
                indexRight = n + kernelSizeMinus1;
                for (int k = 0; k < kernelSizeHalfMinus1; ++k) {
                    double tmp = copy * kernel[k];
                    int n2 = indexLeft++;
                    v[n2] = v[n2] + tmp;
                    int n3 = indexRight--;
                    v[n3] = v[n3] + tmp;
                }
                double tmp = copy * kernel[kernelSizeHalfMinus1];
                int n4 = indexLeft++;
                v[n4] = v[n4] + tmp;
                int n5 = indexRight;
                v[n5] = v[n5] + tmp;
                int n6 = indexLeft;
                v[n6] = v[n6] + copy * kernel[kernelSizeHalf];
            }
            int endLength = imgSize + kernelSizeMinus1;
            for (int i = imgSize; i < endLength; ++i) {
                input.fwd();
                double copy = input.get().get();
                indexLeft = i - kernelSize;
                int k = 0;
                for (long o = (long)(i - kernelSize + 1); o < (long)imgSize; ++o) {
                    int n = ++indexLeft;
                    v[n] = v[n] + copy * kernel[k++];
                }
            }
        } else {
            int o;
            double copy;
            int i;
            v[0] = v[0] + input.get().get() * kernel[0];
            for (i = 1; i < imgSize; ++i) {
                input.fwd();
                copy = input.get().get();
                indexLeft = -1;
                for (o = 0; o <= i; ++o) {
                    int n = ++indexLeft;
                    v[n] = v[n] + copy * kernel[i - o];
                }
            }
            for (i = imgSize; i < imgSize + kernelSizeMinus1; ++i) {
                input.fwd();
                copy = input.get().get();
                o = i - kernelSize + 1;
                int k = 0;
                if (o < 0) {
                    k = -o;
                    o = 0;
                }
                while (o < imgSize) {
                    int n = o++;
                    v[n] = v[n] + copy * kernel[k++];
                }
            }
        }
    }

    protected boolean isArray() {
        return this.isArray;
    }
}

