/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.bspline;

import net.imglib2.RandomAccess;
import net.imglib2.RealCursor;
import net.imglib2.RealLocalizable;
import net.imglib2.algorithm.bspline.AbstractBsplineKernel;
import net.imglib2.algorithm.bspline.BsplineKernel0;
import net.imglib2.algorithm.bspline.BsplineKernel1;
import net.imglib2.algorithm.bspline.BsplineKernel2;
import net.imglib2.algorithm.bspline.BsplineKernel3;
import net.imglib2.algorithm.bspline.BsplineKernel4;
import net.imglib2.algorithm.bspline.BsplineKernel5;
import net.imglib2.algorithm.neighborhood.Neighborhood;
import net.imglib2.type.numeric.RealType;

public class BSplineCoefficientsInterpolatorFunction<T extends RealType<T>> {
    private final T value;
    private final double[][] weights;
    private final int bsplineOrder;
    private final int kernelWidth;
    private final int offset;
    private final AbstractBsplineKernel kernel;
    private final RealLocalizable position;
    private final RandomAccess<Neighborhood<T>> target;

    private BSplineCoefficientsInterpolatorFunction(BSplineCoefficientsInterpolatorFunction<T> interpolator, int order, T type, boolean optimized) {
        this.bsplineOrder = interpolator.bsplineOrder;
        this.target = interpolator.target;
        this.position = interpolator.position;
        this.value = type;
        this.kernel = BSplineCoefficientsInterpolatorFunction.makeKernel(order);
        this.kernelWidth = order + 1;
        this.offset = order % 2 == 0 ? order / 2 : (order + 1) / 2;
        this.weights = new double[this.target.numDimensions()][this.kernelWidth];
    }

    public BSplineCoefficientsInterpolatorFunction(int order, RandomAccess<Neighborhood<T>> target, RealLocalizable position, T type) {
        this(order, target, position, type, true);
    }

    public BSplineCoefficientsInterpolatorFunction(int order, RandomAccess<Neighborhood<T>> target, RealLocalizable position, T type, boolean optimized) {
        this.bsplineOrder = order;
        this.target = target;
        this.position = position;
        this.value = type;
        this.kernel = BSplineCoefficientsInterpolatorFunction.makeKernel(order);
        this.kernelWidth = order + 1;
        this.offset = order % 2 == 0 ? order / 2 : (order - 1) / 2;
        this.weights = new double[target.numDimensions()][this.kernelWidth];
    }

    public T type() {
        return this.value;
    }

    public T get() {
        this.fillWeights(this.position);
        double accumulator = 0.0;
        RealCursor c = ((Neighborhood)this.target.get()).cursor();
        while (c.hasNext()) {
            double tmp = ((RealType)c.next()).getRealDouble();
            for (int d = 0; d < this.target.numDimensions(); ++d) {
                int index = (int)(c.getLongPosition(d) - this.target.getLongPosition(d) + (long)this.offset);
                if (index < this.weights[d].length) {
                    tmp *= this.weights[d][index];
                    continue;
                }
                tmp = 0.0;
            }
            accumulator += tmp;
        }
        this.value.setReal(accumulator);
        return this.value;
    }

    protected void fillWeights(RealLocalizable position) {
        Neighborhood rect = (Neighborhood)this.target.get();
        for (int d = 0; d < this.target.numDimensions(); ++d) {
            double pos = position.getDoublePosition(d);
            long min = rect.min(d);
            long max = rect.max(d);
            for (long i = min; i <= max; ++i) {
                this.weights[d][(int)(i - min)] = this.kernel.evaluateNorm(pos - (double)i);
            }
        }
    }

    public static AbstractBsplineKernel makeKernel(int order) {
        assert (order <= 5 && order >= 0);
        switch (order) {
            case 0: {
                return new BsplineKernel0();
            }
            case 1: {
                return new BsplineKernel1();
            }
            case 2: {
                return new BsplineKernel2();
            }
            case 3: {
                return new BsplineKernel3();
            }
            case 4: {
                return new BsplineKernel4();
            }
            case 5: {
                return new BsplineKernel5();
            }
        }
        return null;
    }
}

