/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.algorithm.blocks;

import net.imglib2.Interval;
import net.imglib2.algorithm.blocks.BlockSupplier;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.CellLoader;
import net.imglib2.cache.img.ReadOnlyCachedCellImgFactory;
import net.imglib2.cache.img.ReadOnlyCachedCellImgOptions;
import net.imglib2.type.NativeType;

public class BlockAlgoUtils {
    public static <T extends NativeType<T>> CellLoader<T> cellLoader(BlockSupplier<T> blocks) {
        BlockSupplier ts = blocks.threadSafe();
        return cell -> ts.copy((Interval)cell, cell.getStorageArray());
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> cellImg(BlockSupplier<T> blocks, long[] dimensions, int[] cellDimensions) {
        return new ReadOnlyCachedCellImgFactory().create(dimensions, (NativeType)blocks.getType(), BlockAlgoUtils.cellLoader(blocks), (ReadOnlyCachedCellImgOptions)ReadOnlyCachedCellImgOptions.options().cellDimensions(cellDimensions));
    }
}

