/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.plugins.scripteditor.jython;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.antlr.runtime.tree.CommonTree;
import org.python.antlr.PythonTree;
import org.python.antlr.ast.Assign;
import org.python.antlr.ast.Attribute;
import org.python.antlr.ast.BinOp;
import org.python.antlr.ast.Call;
import org.python.antlr.ast.ClassDef;
import org.python.antlr.ast.Expr;
import org.python.antlr.ast.For;
import org.python.antlr.ast.FunctionDef;
import org.python.antlr.ast.If;
import org.python.antlr.ast.Import;
import org.python.antlr.ast.ImportFrom;
import org.python.antlr.ast.Name;
import org.python.antlr.ast.Num;
import org.python.antlr.ast.Return;
import org.python.antlr.ast.Str;
import org.python.antlr.ast.TryExcept;
import org.python.antlr.ast.TryFinally;
import org.python.antlr.ast.Tuple;
import org.python.antlr.ast.While;
import org.python.antlr.ast.With;
import org.python.antlr.ast.Yield;
import org.python.antlr.ast.alias;
import org.python.antlr.ast.arguments;
import org.python.antlr.base.expr;
import org.python.antlr.base.mod;
import org.python.core.CompileMode;
import org.python.core.CompilerFlags;
import org.python.core.ParserFacade;
import org.python.core.PyFloat;
import org.python.core.PyInteger;
import org.python.core.PyObject;
import org.python.indexer.types.NModuleType;
import org.scijava.plugins.scripteditor.jython.ClassDotAutocompletions;
import org.scijava.plugins.scripteditor.jython.DefVarDotAutocompletions;
import org.scijava.plugins.scripteditor.jython.DotAutocompletions;
import org.scijava.plugins.scripteditor.jython.JythonDev;
import org.scijava.plugins.scripteditor.jython.Scope;
import org.scijava.plugins.scripteditor.jython.StaticDotAutocompletions;
import org.scijava.plugins.scripteditor.jython.VarDotAutocompletions;
import org.scijava.ui.swing.script.autocompletion.CompletionText;

public class JythonScriptParser {
    public static Scope parseAST(String code) {
        try {
            mod m = ParserFacade.parse((String)code, (CompileMode)CompileMode.exec, (String)"<none>", (CompilerFlags)new CompilerFlags());
            Scope scope = JythonScriptParser.parseNode(m.getChildren(), null, null);
            return null == scope ? new Scope(null) : scope;
        }
        catch (Throwable t) {
            JythonDev.printError(t);
            return new Scope(null);
        }
    }

    public static Scope parseNode(List<PythonTree> children, Scope parent, String className) {
        if (null == children) {
            return parent;
        }
        Scope scope = new Scope(parent, className);
        JythonScriptParser.parseNode(scope, children, className);
        return scope;
    }

    public static void parseNode(Scope scope, List<PythonTree> children, String className) {
        for (PythonTree child : children) {
            JythonDev.printTrace(child.getClass());
            if (child instanceof ImportFrom) {
                scope.imports.putAll(JythonScriptParser.parseImportFromStatement((ImportFrom)child));
                continue;
            }
            if (child instanceof Import) {
                scope.imports.putAll(JythonScriptParser.parseImportStatement((Import)child));
                continue;
            }
            if (child instanceof Assign) {
                scope.vars.putAll(JythonScriptParser.parseAssignStatement((Assign)child, scope));
                continue;
            }
            if (child instanceof FunctionDef) {
                JythonScriptParser.parseFunctionDef((FunctionDef)child, scope);
                continue;
            }
            if (child instanceof ClassDef) {
                JythonScriptParser.parseClassDef((ClassDef)child, scope);
                continue;
            }
            if (child instanceof Expr) {
                JythonScriptParser.parseExpr((Expr)child, scope);
                continue;
            }
            if (child instanceof If || child instanceof For || child instanceof While || child instanceof TryExcept || child instanceof TryFinally || child instanceof With) {
                JythonScriptParser.parseNode(scope, child.getChildren(), null);
                continue;
            }
            JythonDev.printTrace("IGNORING child: " + child + " -- " + (null != child.getChildren() ? String.join((CharSequence)"::", child.getChildren().stream().map(c -> c.toString()).collect(Collectors.toList())) : ""));
        }
    }

    public static void parseExpr(Expr child, Scope scope) {
        JythonDev.printTrace("Expr: " + child.getText() + ", " + child.getInternalValue() + ", " + child.getValue() + ", children: " + String.join((CharSequence)", ", child.getChildren().stream().map(PythonTree::toString).collect(Collectors.toList())));
    }

    public static Map<String, DotAutocompletions> parseImportFromStatement(ImportFrom im) {
        HashMap<String, DotAutocompletions> classes = new HashMap<String, DotAutocompletions>();
        String module = im.getModule().toString();
        for (int i = 0; i < im.getNames().__len__(); ++i) {
            String alias2 = ((alias)im.getInternalNames().get(i)).getAsname().toString();
            String simpleClassName = ((alias)im.getInternalNames().get(i)).getInternalName();
            classes.put("None" == alias2 ? simpleClassName : alias2, new StaticDotAutocompletions(module + "." + simpleClassName));
        }
        return classes;
    }

    public static Map<String, DotAutocompletions> parseImportStatement(Import im) {
        HashMap<String, DotAutocompletions> classes = new HashMap<String, DotAutocompletions>();
        List aliases = im.getInternalNames();
        for (alias a : aliases) {
            String as = a.getInternalAsname();
            String name = a.getInternalName();
            classes.put(null == as || "None" == as ? name : as, new StaticDotAutocompletions(name));
        }
        return classes;
    }

    private static DotAutocompletions maybeStaticToDot(PythonTree node, DotAutocompletions da) {
        JythonDev.printTrace("children count:" + node.getChildCount() + ", children: " + (null != node.getChildren() ? node.getChildren().stream().map(c -> c.toString()).collect(Collectors.toList()) : ""));
        if (node.getChildCount() > 0 && da instanceof StaticDotAutocompletions) {
            return new VarDotAutocompletions(da.getClassname());
        }
        return da;
    }

    public static Map<String, DotAutocompletions> parseAssignStatement(Assign assign, Scope scope) {
        HashMap<String, DotAutocompletions> assigns = new HashMap<String, DotAutocompletions>();
        PythonTree right = (PythonTree)assign.getChildren().get(1);
        PythonTree left = (PythonTree)assign.getChildren().get(0);
        if (null != left.getChildren() && left.getChildren().size() > 1 && (right instanceof Tuple || right instanceof org.python.antlr.ast.List)) {
            for (int i = 0; i < right.getChildren().size(); ++i) {
                CommonTree ct = ((PythonTree)left.getChildren().get(i)).getNode();
                if (null == ct) {
                    JythonDev.printTrace("null for left: '" + left + "' at child node " + i);
                    continue;
                }
                String name = ct.toString();
                DotAutocompletions val = JythonScriptParser.maybeStaticToDot(right, JythonScriptParser.parseRight((PyObject)right.getChildren().get(i), scope));
                if (null == val) continue;
                assigns.put(name, val);
            }
        } else {
            if (left instanceof Name) {
                assigns.put(((Name)left).getInternalId(), JythonScriptParser.maybeStaticToDot(right, JythonScriptParser.parseRight((PyObject)right, scope)));
                return assigns;
            }
            PythonTree leftn = left;
            ArrayList<Attribute> attrs = new ArrayList<Attribute>();
            while (leftn instanceof Attribute) {
                Attribute attr = (Attribute)leftn;
                attrs.add(attr);
                leftn = attr.getValue();
            }
            if (leftn instanceof Name) {
                String varName = ((Name)leftn).getInternalId();
                Collections.reverse(attrs);
                Scope scopeC = scope;
                for (Attribute attr : attrs) {
                    DotAutocompletions ac = scopeC.find(varName, DotAutocompletions.EMPTY);
                    if (!(ac instanceof ClassDotAutocompletions)) break;
                    ClassDotAutocompletions cda = (ClassDotAutocompletions)ac;
                    varName = attr.getInternalAttrName().getInternalId();
                    scopeC = cda.scope;
                    cda.put(new CompletionText(varName));
                }
                return assigns;
            }
        }
        return assigns;
    }

    public static void parseFunctionDef(FunctionDef fn, Scope parent) {
        String name = fn.getInternalName();
        arguments args = fn.getInternalArgs();
        List<String> argumentNames = args != null && args.getChildren() != null ? args.getChildren().stream().map(arg -> arg.getNode().toString()).collect(Collectors.toList()) : Collections.emptyList();
        List children = fn.getChildren();
        if (null == children) {
            return;
        }
        Scope fn_scope = new Scope(parent, null);
        for (String arg2 : argumentNames) {
            fn_scope.vars.put(arg2, new ClassDotAutocompletions("<unknown>", Collections.emptyList(), Collections.emptyList(), new ArrayList<CompletionText>(), fn_scope));
        }
        JythonScriptParser.parseNode(fn_scope, fn.getChildren(), null);
        PythonTree last = (PythonTree)fn.getChildren().get(fn.getChildCount() - 1);
        String returnClassName = last instanceof Return ? JythonScriptParser.parseRight((PyObject)last.getChildren().get(0), fn_scope).toString() : null;
        parent.vars.put(name, new DefVarDotAutocompletions(name, returnClassName, argumentNames, fn_scope));
    }

    public static void parseClassDef(ClassDef c, Scope parent) {
        String pyClassname = c.getInternalName();
        Scope class_scope = JythonScriptParser.parseNode(c.getChildren(), parent, pyClassname);
        ArrayList<CompletionText> classDotAutocompletions = new ArrayList<CompletionText>();
        for (DotAutocompletions dotAutocompletions : class_scope.vars.values()) {
            if (!(dotAutocompletions instanceof DefVarDotAutocompletions)) continue;
            DefVarDotAutocompletions dda = (DefVarDotAutocompletions)dotAutocompletions;
            classDotAutocompletions.add(new CompletionText(dda.fnName));
        }
        ArrayList<String> superclassNames = new ArrayList<String>();
        for (expr e : c.getInternalBases()) {
            DotAutocompletions da = parent.find(e.getText(), null);
            if (null == da || null == da.getClassname()) {
                JythonDev.print("Could not find completions and className for " + e.getText());
                continue;
            }
            superclassNames.add(da.getClassname());
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ClassDotAutocompletions cda = new ClassDotAutocompletions(pyClassname, superclassNames, arrayList, classDotAutocompletions, class_scope);
        for (PythonTree child : c.getChildren()) {
            FunctionDef fn;
            List args;
            if (!(child instanceof FunctionDef) || (args = (fn = (FunctionDef)child).getInternalArgs().getChildren()).size() <= 0) continue;
            if ("__init__".equals(fn.getInternalName())) {
                arrayList.addAll(args.subList(1, args.size()).stream().map(arg -> arg.getNode().toString()).collect(Collectors.toList()));
            }
            DefVarDotAutocompletions fnda = (DefVarDotAutocompletions)class_scope.vars.get(fn.getInternalName());
            DotAutocompletions argda = fnda.scope.vars.get(((PythonTree)args.get(0)).getNode().toString());
            if (!(argda instanceof ClassDotAutocompletions)) continue;
            ((ClassDotAutocompletions)argda).mutateIntoPlus(cda);
        }
        parent.vars.put(pyClassname, cda);
    }

    public static DotAutocompletions parseRight(PyObject right, Scope scope) {
        if (right instanceof Name) {
            return scope.find(((Name)right).getInternalId(), DotAutocompletions.EMPTY);
        }
        if (right instanceof Num) {
            Class<Number> c = ((Num)right).getInternalN().getClass() == PyInteger.class ? Long.TYPE : Double.TYPE;
            return new VarDotAutocompletions(c.toString());
        }
        if (right instanceof Str) {
            return new VarDotAutocompletions(String.class.getCanonicalName());
        }
        if (right instanceof Attribute) {
            Attribute attr = (Attribute)right;
            DotAutocompletions da = JythonScriptParser.parseRight(attr.getValue(), scope);
            if (DotAutocompletions.EMPTY == da) {
                return da;
            }
            String name = attr.getInternalAttr();
            String className = da.getClassname();
            try {
                Class<?> c = Class.forName(className);
                for (Method m : c.getMethods()) {
                    if (!m.getName().equals(name)) continue;
                    return new VarDotAutocompletions(m.getReturnType().getName());
                }
                return new VarDotAutocompletions(c.getField(name).getType().getName());
            }
            catch (Exception e) {
                JythonDev.print("Could not find method or field " + name + " in class " + className, e);
                try {
                    NModuleType module = Scope.indexer.loadModule(className + "." + name);
                    if (null != module) {
                        return new StaticDotAutocompletions(className + "." + name);
                    }
                }
                catch (Exception e2) {
                    JythonDev.printTrace("Not a python module: " + className + "." + name);
                }
            }
        }
        if (right instanceof Call) {
            Call call = (Call)right;
            return JythonScriptParser.parseRight(call.getFunc(), scope);
        }
        if (right instanceof Yield) {
            Yield yield = (Yield)right;
            return JythonScriptParser.parseRight(yield.getValue(), scope);
        }
        if (right instanceof BinOp) {
            DotAutocompletions da;
            Class<?> typeR;
            BinOp binop = (BinOp)right;
            JythonDev.printTrace("BinOp: weak attempt at finding out what kind of number it returns.");
            Class<?> typeL = binop.getLeft().isNumberType() ? ((Num)binop.getLeft()).getInternalN().getClass() : null;
            Class<?> clazz = typeR = binop.getRight().isNumberType() ? ((Num)binop.getRight()).getInternalN().getClass() : null;
            if (null != typeL || null != typeR) {
                if (typeL == PyInteger.class && typeR == PyInteger.class) {
                    return new VarDotAutocompletions(Long.class.toString());
                }
                if (typeL == PyFloat.class || typeR == PyFloat.class) {
                    return new VarDotAutocompletions(Double.class.toString());
                }
            }
            if ((da = JythonScriptParser.parseRight(binop.getLeft(), scope)) != DotAutocompletions.EMPTY) {
                return da;
            }
            return JythonScriptParser.parseRight(binop.getRight(), scope);
        }
        JythonDev.printTrace("Unsupported 'right' is: " + right + " " + (right != null ? right.getClass() : ""));
        return DotAutocompletions.EMPTY;
    }
}

