/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.metadata;

import bdv.util.RandomAccessibleIntervalMipmapSource;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Interval;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Util;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;
import org.janelia.saalfeldlab.n5.universe.metadata.MultiscaleMetadata;

public class MetadataMipmapSource<T extends NumericType<T> & NativeType<T>>
extends RandomAccessibleIntervalMipmapSource<T> {
    private N5Reader n5;
    private MultiscaleMetadata<?> metadata;
    private int channelDim;
    private int channelPos;

    private static VoxelDimensions voxelDimensions(MultiscaleMetadata<?> metadata) {
        double[] unit = new double[]{1.0, 1.0, 1.0};
        metadata.spatialTransform3d().apply(unit, unit);
        return new FinalVoxelDimensions(metadata.unit(), unit);
    }

    public MetadataMipmapSource(N5Reader n5, MultiscaleMetadata<?> metadata, int channelDim, int channelPos) {
        super(MetadataMipmapSource.getImgs(n5, metadata), MetadataMipmapSource.getType(n5, metadata), metadata.spatialTransforms3d(), MetadataMipmapSource.voxelDimensions(metadata), metadata.getName(), true);
        this.n5 = n5;
        this.metadata = metadata;
        this.channelDim = channelDim;
        this.channelPos = channelPos;
    }

    public static RandomAccessibleInterval[] getImgs(N5Reader n5, MultiscaleMetadata<?> metadata) {
        int N = metadata.getChildrenMetadata().length;
        RandomAccessibleInterval[] imgs = new RandomAccessibleInterval[N];
        for (int i = 0; i < N; ++i) {
            try {
                imgs[i] = N5Utils.open((N5Reader)n5, (String)metadata.getChildrenMetadata()[i].getPath());
                continue;
            }
            catch (N5Exception n5Exception) {
                // empty catch block
            }
        }
        return imgs;
    }

    public static <T extends NumericType<T> & NativeType<T>> T getType(N5Reader n5, MultiscaleMetadata<?> metadata) {
        try {
            CachedCellImg img = N5Utils.open((N5Reader)n5, (String)metadata.getChildrenMetadata()[0].getPath());
            return (T)((NumericType)Util.getTypeFromInterval((Interval)img));
        }
        catch (N5Exception n5Exception) {
            return null;
        }
    }

    public MetadataMipmapSource(N5Reader n5, MultiscaleMetadata<?> metadata) {
        this(n5, metadata, -1, 0);
    }

    public MetadataMipmapSource(N5Reader n5, MultiscaleMetadata<?> metadata, int channelPos) {
        this(n5, metadata, -1, channelPos);
    }
}

