/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.CapabilityNotSetException;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.Leaf;
import org.scijava.java3d.Node;
import org.scijava.java3d.ViewPlatformRetained;

public class ViewPlatform
extends Leaf {
    public static final int ALLOW_POLICY_READ = 12;
    public static final int ALLOW_POLICY_WRITE = 13;
    private static final int[] readCapabilities = new int[]{12};

    public ViewPlatform() {
        this.setDefaultReadCapabilities(readCapabilities);
    }

    @Override
    void createRetained() {
        this.retained = new ViewPlatformRetained();
        this.retained.setSource(this);
    }

    public void setViewAttachPolicy(int policy) {
        if (this.isLiveOrCompiled() && !this.getCapability(13)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ViewPlatform0"));
        }
        switch (policy) {
            case 0: 
            case 1: 
            case 2: {
                break;
            }
            default: {
                throw new IllegalArgumentException(J3dI18N.getString("ViewPlatform1"));
            }
        }
        ((ViewPlatformRetained)this.retained).setViewAttachPolicy(policy);
    }

    public int getViewAttachPolicy() {
        if (this.isLiveOrCompiled() && !this.getCapability(12)) {
            throw new CapabilityNotSetException(J3dI18N.getString("ViewPlatform2"));
        }
        return ((ViewPlatformRetained)this.retained).getViewAttachPolicy();
    }

    public void setActivationRadius(float activationRadius) {
        ((ViewPlatformRetained)this.retained).setActivationRadius(activationRadius);
    }

    public float getActivationRadius() {
        return ((ViewPlatformRetained)this.retained).getActivationRadius();
    }

    @Override
    public Node cloneNode(boolean forceDuplicate) {
        ViewPlatform v = new ViewPlatform();
        v.duplicateNode(this, forceDuplicate);
        return v;
    }

    @Override
    void duplicateAttributes(Node originalNode, boolean forceDuplicate) {
        super.duplicateAttributes(originalNode, forceDuplicate);
        ViewPlatformRetained attr = (ViewPlatformRetained)originalNode.retained;
        ViewPlatformRetained rt = (ViewPlatformRetained)this.retained;
        rt.setActivationRadius(attr.getActivationRadius());
        rt.setViewAttachPolicy(attr.getViewAttachPolicy());
    }
}

