/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.Hashtable;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.NodeComponent;
import org.scijava.java3d.NodeReferenceTable;
import org.scijava.java3d.RestrictedAccessException;
import org.scijava.java3d.SceneGraphObjectRetained;

public abstract class SceneGraphObject {
    SceneGraphObjectRetained retained;
    private long capabilityBits = 0L;
    private long capabilityIsFrequentBits = -1L;
    private boolean compiled = false;
    private boolean live = false;
    private boolean liveOrCompiled = false;
    private Object userData = null;
    private String objectName = null;
    Hashtable nodeHashtable = null;

    public SceneGraphObject() {
        this.createRetained();
    }

    void createRetained() {
        this.retained = null;
    }

    void setDefaultReadCapabilities(int[] bits) {
        for (int i = 0; i < bits.length; ++i) {
            this.setCapability(bits[i]);
        }
    }

    public final boolean getCapability(int bit) {
        return (this.capabilityBits & 1L << bit) != 0L;
    }

    public final void setCapability(int bit) {
        if (this.isLiveOrCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("SceneGraphObject0"));
        }
        this.capabilityBits |= 1L << bit;
        this.retained.handleFrequencyChange(bit);
    }

    public final void clearCapability(int bit) {
        if (this.isLiveOrCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("SceneGraphObject0"));
        }
        this.capabilityBits &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL;
        this.retained.handleFrequencyChange(bit);
    }

    final boolean capabilityBitsEmpty() {
        return this.capabilityBits == 0L;
    }

    public final boolean getCapabilityIsFrequent(int bit) {
        return (this.capabilityIsFrequentBits & 1L << bit) != 0L;
    }

    public final void setCapabilityIsFrequent(int bit) {
        if (this.isCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("SceneGraphObject1"));
        }
        this.capabilityIsFrequentBits |= 1L << bit;
        this.retained.handleFrequencyChange(bit);
    }

    public final void clearCapabilityIsFrequent(int bit) {
        if (this.isCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("SceneGraphObject1"));
        }
        this.capabilityIsFrequentBits &= 1L << bit ^ 0xFFFFFFFFFFFFFFFFL;
        this.retained.handleFrequencyChange(bit);
    }

    final void setCompiled() {
        this.compiled = true;
        this.liveOrCompiled = this.live || this.compiled;
    }

    public final boolean isCompiled() {
        return this.compiled;
    }

    final void setLive() {
        this.live = true;
        this.liveOrCompiled = this.live || this.compiled;
    }

    final void clearLive() {
        this.live = false;
        this.liveOrCompiled = this.live || this.compiled;
    }

    public final boolean isLive() {
        return this.live;
    }

    final boolean isLiveOrCompiled() {
        return this.liveOrCompiled;
    }

    final void checkForLiveOrCompiled() {
        if (this.isLiveOrCompiled()) {
            throw new RestrictedAccessException(J3dI18N.getString("SceneGraphObject2"));
        }
    }

    public void setUserData(Object userData) {
        this.userData = userData;
    }

    public Object getUserData() {
        return this.userData;
    }

    public void updateNodeReferences(NodeReferenceTable referenceTable) {
    }

    public void setName(String name) {
        this.objectName = name;
    }

    public String getName() {
        return this.objectName;
    }

    protected void duplicateSceneGraphObject(SceneGraphObject originalNode) {
        this.capabilityBits = originalNode.capabilityBits;
        this.userData = originalNode.userData;
        this.objectName = originalNode.objectName;
    }

    NodeComponent getNodeComponent(NodeComponent originalNodeComponent, boolean forceDuplicate, Hashtable hashtable) {
        if (originalNodeComponent != null && (forceDuplicate || originalNodeComponent.duplicateChild())) {
            NodeComponent nc = (NodeComponent)hashtable.get(originalNodeComponent);
            if (nc == null) {
                originalNodeComponent.nodeHashtable = hashtable;
                try {
                    nc = originalNodeComponent.cloneNodeComponent(forceDuplicate);
                }
                catch (RuntimeException e) {
                    originalNodeComponent.nodeHashtable = null;
                    throw e;
                }
                originalNodeComponent.nodeHashtable = null;
                hashtable.put(originalNodeComponent, nc);
            }
            return nc;
        }
        return originalNodeComponent;
    }

    String getNamePrefix() {
        String name = this.getName();
        if (name != null) {
            return "[" + name + "] ";
        }
        return "";
    }

    public String toString() {
        return this.getNamePrefix() + super.toString();
    }
}

