/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.Bounds;
import org.scijava.java3d.PickShape;
import org.scijava.java3d.Transform3D;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Point4d;

public final class PickPoint
extends PickShape {
    Point3d location;

    public PickPoint() {
        this.location = new Point3d();
    }

    public PickPoint(Point3d location) {
        this.location = new Point3d(location);
    }

    public void set(Point3d location) {
        this.location.x = location.x;
        this.location.y = location.y;
        this.location.z = location.z;
    }

    public void get(Point3d location) {
        location.x = this.location.x;
        location.y = this.location.y;
        location.z = this.location.z;
    }

    @Override
    final boolean intersect(Bounds bounds, Point4d pickPos) {
        return bounds.intersect(this.location, pickPos);
    }

    @Override
    PickShape transform(Transform3D t3d) {
        PickPoint newPPt = new PickPoint();
        newPPt.location.x = this.location.x;
        newPPt.location.y = this.location.y;
        newPPt.location.z = this.location.z;
        t3d.transform(newPPt.location);
        return newPPt;
    }

    @Override
    Point3d getStartPoint() {
        return this.location;
    }

    @Override
    int getPickType() {
        return 3;
    }
}

