/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import java.util.ArrayList;
import org.scijava.java3d.AlternateAppearanceRetained;
import org.scijava.java3d.Appearance;
import org.scijava.java3d.AppearanceRetained;
import org.scijava.java3d.BoundingBox;
import org.scijava.java3d.Bounds;
import org.scijava.java3d.BranchGroupRetained;
import org.scijava.java3d.CompileState;
import org.scijava.java3d.FogRetained;
import org.scijava.java3d.Geometry;
import org.scijava.java3d.GeometryArray;
import org.scijava.java3d.GeometryArrayRetained;
import org.scijava.java3d.GeometryAtom;
import org.scijava.java3d.GeometryRetained;
import org.scijava.java3d.GeometryStripArrayRetained;
import org.scijava.java3d.GeometryUpdater;
import org.scijava.java3d.HashKey;
import org.scijava.java3d.IndexedGeometryArray;
import org.scijava.java3d.IndexedGeometryArrayRetained;
import org.scijava.java3d.IndexedGeometryStripArrayRetained;
import org.scijava.java3d.IndexedLineArray;
import org.scijava.java3d.IndexedLineStripArray;
import org.scijava.java3d.IndexedLineStripArrayRetained;
import org.scijava.java3d.IndexedPointArray;
import org.scijava.java3d.IndexedQuadArray;
import org.scijava.java3d.IndexedTriangleArray;
import org.scijava.java3d.IndexedTriangleFanArray;
import org.scijava.java3d.IndexedTriangleFanArrayRetained;
import org.scijava.java3d.IndexedTriangleStripArray;
import org.scijava.java3d.IndexedTriangleStripArrayRetained;
import org.scijava.java3d.J3dDebug;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.J3dMessage;
import org.scijava.java3d.LeafRetained;
import org.scijava.java3d.LightRetained;
import org.scijava.java3d.LineArray;
import org.scijava.java3d.LineStripArray;
import org.scijava.java3d.LineStripArrayRetained;
import org.scijava.java3d.ModelClipRetained;
import org.scijava.java3d.Morph;
import org.scijava.java3d.PickInfo;
import org.scijava.java3d.PickShape;
import org.scijava.java3d.PointArray;
import org.scijava.java3d.QuadArray;
import org.scijava.java3d.SceneGraphPath;
import org.scijava.java3d.SetLiveState;
import org.scijava.java3d.Shape3DRetained;
import org.scijava.java3d.SwitchRetained;
import org.scijava.java3d.Transform3D;
import org.scijava.java3d.TriangleArray;
import org.scijava.java3d.TriangleFanArray;
import org.scijava.java3d.TriangleFanArrayRetained;
import org.scijava.java3d.TriangleStripArray;
import org.scijava.java3d.TriangleStripArrayRetained;
import org.scijava.java3d.UnorderList;
import org.scijava.java3d.VirtualUniverse;
import org.scijava.vecmath.Color3b;
import org.scijava.vecmath.Color3f;
import org.scijava.vecmath.Color4b;
import org.scijava.vecmath.Color4f;
import org.scijava.vecmath.Point3d;
import org.scijava.vecmath.Point3f;
import org.scijava.vecmath.TexCoord2f;
import org.scijava.vecmath.TexCoord3f;
import org.scijava.vecmath.Tuple3d;
import org.scijava.vecmath.Vector3f;

class MorphRetained
extends LeafRetained
implements GeometryUpdater {
    static final int GEOMETRY_CHANGED = 1;
    static final int APPEARANCE_CHANGED = 2;
    static final int COLLISION_CHANGED = 4;
    static final int BOUNDS_CHANGED = 8;
    static final int APPEARANCEOVERRIDE_CHANGED = 16;
    static final int UPDATE_MORPH = 32;
    private static final double TOLERANCE = 1.0E-4;
    ArrayList mirrorShape3D = new ArrayList();
    static final int targetThreads = 192;
    AppearanceRetained appearance = null;
    GeometryArrayRetained[] geometryArrays;
    private int numGeometryArrays = 0;
    double[] weights;
    BranchGroupRetained[] branchGroupPath;
    boolean isPickable = true;
    boolean isCollidable = true;
    SwitchRetained closestSwitchParent = null;
    int closestSwitchIndex = -1;
    boolean visible = true;
    Bounds bounds = null;
    BoundingBox vwcBounds = new BoundingBox();
    Bounds collisionBound = null;
    Bounds collisionVwcBound = null;
    GeometryArray morphedGeometryArray = null;
    float[] Mcoord = null;
    float[] Mcolor = null;
    float[] Mnormal = null;
    float[][] MtexCoord = null;
    boolean appearanceOverrideEnable = false;
    int changedFrequent = 0;

    MorphRetained() {
        this.nodeType = 10;
        this.localBounds = new BoundingBox((Bounds)null);
    }

    void setCollisionBounds(Bounds bounds) {
        this.collisionBound = bounds != null ? (Bounds)bounds.clone() : null;
        if (this.source.isLive()) {
            J3dMessage message = new J3dMessage();
            message.type = 34;
            message.threads = 8192;
            message.universe = this.universe;
            message.args[1] = this.collisionBound;
            VirtualUniverse.mc.processMessage(message);
        }
    }

    @Override
    void setBounds(Bounds bounds) {
        super.setBounds(bounds);
        if (this.source.isLive() && !this.boundsAutoCompute) {
            J3dMessage message = new J3dMessage();
            message.type = 35;
            message.threads = 8384;
            message.universe = this.universe;
            message.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            message.args[1] = this.localBounds;
            VirtualUniverse.mc.processMessage(message);
        }
    }

    Bounds getCollisionBounds() {
        return this.collisionBound == null ? null : (Bounds)this.collisionBound.clone();
    }

    void setGeometryArrays(GeometryArray[] geometryArrays) {
        GeometryArrayRetained geo;
        int i;
        if ((geometryArrays == null || geometryArrays.length == 0) && this.numGeometryArrays == 0) {
            return;
        }
        if (this.numGeometryArrays != 0 && (geometryArrays == null || this.numGeometryArrays != geometryArrays.length)) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained0"));
        }
        for (i = 1; i < geometryArrays.length; ++i) {
            if (geometryArrays[i] == null || geometryArrays[i - 1] == null) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            geo = (GeometryArrayRetained)geometryArrays[i].retained;
            GeometryArrayRetained prevGeo = (GeometryArrayRetained)geometryArrays[i - 1].retained;
            if (prevGeo == null || geo == null) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            this.doErrorCheck(prevGeo, geo);
        }
        geo = (GeometryArrayRetained)geometryArrays[0].retained;
        if ((geo.vertexFormat & 0x1000) != 0) {
            throw new UnsupportedOperationException(J3dI18N.getString("MorphRetained9"));
        }
        if (geometryArrays[0] != null) {
            geo = (GeometryArrayRetained)geometryArrays[0].retained;
        }
        if (this.numGeometryArrays == 0) {
            this.geometryArrays = new GeometryArrayRetained[geometryArrays.length];
            this.numGeometryArrays = geometryArrays.length;
        }
        for (i = 0; i < this.numGeometryArrays; ++i) {
            geo = (GeometryArrayRetained)geometryArrays[i].retained;
            if (((Morph)this.source).isLive()) {
                if (this.geometryArrays[i] != null) {
                    this.geometryArrays[i].clearLive(this.refCount);
                    this.geometryArrays[i].removeMorphUser(this);
                }
                if (geo != null) {
                    geo.setLive(this.inBackgroundGroup, this.refCount);
                    geo.addMorphUser(this);
                }
            }
            this.geometryArrays[i] = geo;
        }
        if (this.geometryArrays[0] == null) {
            return;
        }
        if (this.weights == null) {
            int k;
            this.weights = new double[this.numGeometryArrays];
            this.weights[0] = 1.0;
            int vFormat = this.geometryArrays[0].vertexFormat;
            int texCoordSetCount = this.geometryArrays[0].getTexCoordSetCount();
            if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
                this.Mcoord = new float[this.geometryArrays[0].getNumCoordCount() * 3];
                if ((vFormat & 0xC) == 4) {
                    this.Mcolor = new float[this.geometryArrays[0].getNumColorCount() * 3];
                } else if ((vFormat & 0xC) == 12) {
                    this.Mcolor = new float[this.geometryArrays[0].getNumColorCount() * 4];
                }
                this.MtexCoord = new float[texCoordSetCount][];
                if ((vFormat & 2) != 0) {
                    this.Mnormal = new float[this.geometryArrays[0].getNumNormalCount() * 3];
                }
                for (k = 0; k < texCoordSetCount; ++k) {
                    if ((vFormat & 0x20) != 0) {
                        this.MtexCoord[k] = new float[this.geometryArrays[0].getNumTexCoordCount(k) * 2];
                        continue;
                    }
                    if ((vFormat & 0x40) != 0) {
                        this.MtexCoord[k] = new float[this.geometryArrays[0].getNumTexCoordCount(k) * 3];
                        continue;
                    }
                    if ((vFormat & 0x400) == 0) continue;
                    this.MtexCoord[k] = new float[this.geometryArrays[0].getNumTexCoordCount(k) * 4];
                }
            } else {
                this.Mcoord = new float[this.geometryArrays[0].validVertexCount * 3];
                if ((vFormat & 0xC) == 4) {
                    this.Mcolor = new float[this.geometryArrays[0].validVertexCount * 3];
                } else if ((vFormat & 0xC) == 12) {
                    this.Mcolor = new float[this.geometryArrays[0].validVertexCount * 4];
                }
                this.MtexCoord = new float[texCoordSetCount][];
                if ((vFormat & 2) != 0) {
                    this.Mnormal = new float[this.geometryArrays[0].validVertexCount * 3];
                }
                for (k = 0; k < texCoordSetCount; ++k) {
                    if ((vFormat & 0x20) != 0) {
                        this.MtexCoord[k] = new float[this.geometryArrays[0].validVertexCount * 2];
                        continue;
                    }
                    if ((vFormat & 0x40) != 0) {
                        this.MtexCoord[k] = new float[this.geometryArrays[0].validVertexCount * 3];
                        continue;
                    }
                    if ((vFormat & 0x400) == 0) continue;
                    this.MtexCoord[k] = new float[this.geometryArrays[0].validVertexCount * 4];
                }
            }
        }
        this.initMorphedGeometry();
        if (this.source.isLive()) {
            Shape3DRetained shape = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape.setMorphGeometry(this.morphedGeometryArray, this.mirrorShape3D);
            J3dMessage mChangeMessage = null;
            mChangeMessage = new J3dMessage();
            mChangeMessage.type = 16;
            mChangeMessage.threads = 8256;
            if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
                mChangeMessage.threads |= 0x400;
            }
            mChangeMessage.args[0] = this;
            mChangeMessage.args[1] = new Integer(1);
            mChangeMessage.args[3] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            mChangeMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(mChangeMessage);
            if (this.boundsAutoCompute) {
                GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
                mga.incrComputeGeoBounds();
                mga.decrComputeGeoBounds();
            }
        }
    }

    GeometryArray getGeometryArray(int index) {
        return (GeometryArray)this.geometryArrays[index].source;
    }

    void setAppearance(Appearance newAppearance) {
        boolean visibleIsDirty = false;
        if (((Morph)this.source).isLive()) {
            int size;
            if (this.appearance != null) {
                this.appearance.clearLive(this.refCount);
                for (int i = this.mirrorShape3D.size() - 1; i >= 0; --i) {
                    this.appearance.removeAMirrorUser((Shape3DRetained)this.mirrorShape3D.get(i));
                }
            }
            if (newAppearance != null) {
                ((AppearanceRetained)newAppearance.retained).setLive(this.inBackgroundGroup, this.refCount);
                this.appearance = (AppearanceRetained)newAppearance.retained;
                size = this.mirrorShape3D.size();
                for (int i = 0; i < size; ++i) {
                    this.appearance.addAMirrorUser((Shape3DRetained)this.mirrorShape3D.get(i));
                }
                if (this.appearance.renderingAttributes != null && this.visible != this.appearance.renderingAttributes.visible) {
                    this.visible = this.appearance.renderingAttributes.visible;
                    visibleIsDirty = true;
                }
            } else if (!this.visible) {
                this.visible = true;
                visibleIsDirty = true;
            }
            size = 0;
            size = visibleIsDirty ? 2 : 1;
            J3dMessage[] createMessage = new J3dMessage[size];
            createMessage[0] = new J3dMessage();
            createMessage[0].threads = 4224;
            createMessage[0].type = 16;
            createMessage[0].universe = this.universe;
            createMessage[0].args[0] = this;
            createMessage[0].args[1] = new Integer(2);
            Shape3DRetained[] s3dArr = new Shape3DRetained[this.mirrorShape3D.size()];
            this.mirrorShape3D.toArray(s3dArr);
            createMessage[0].args[2] = s3dArr;
            Object[] obj = new Object[]{newAppearance == null ? null : this.appearance.mirror, new Integer(this.changedFrequent)};
            createMessage[0].args[3] = obj;
            createMessage[0].args[4] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            if (visibleIsDirty) {
                createMessage[1] = new J3dMessage();
                createMessage[1].threads = 64;
                createMessage[1].type = 24;
                createMessage[1].universe = this.universe;
                createMessage[1].args[0] = this;
                createMessage[1].args[1] = new Integer(2);
                createMessage[1].args[2] = this.visible ? Boolean.TRUE : Boolean.FALSE;
                createMessage[1].args[3] = createMessage[0].args[4];
            }
            VirtualUniverse.mc.processMessage(createMessage);
        } else {
            this.appearance = newAppearance == null ? null : (AppearanceRetained)newAppearance.retained;
        }
    }

    Appearance getAppearance() {
        return this.appearance == null ? null : (Appearance)this.appearance.source;
    }

    void setAppearanceOverrideEnable(boolean flag) {
        if (((Morph)this.source).isLive()) {
            J3dMessage createMessage = new J3dMessage();
            createMessage.threads = 4224;
            createMessage.type = 16;
            createMessage.universe = this.universe;
            createMessage.args[0] = this;
            createMessage.args[1] = new Integer(16);
            Shape3DRetained[] s3dArr = new Shape3DRetained[this.mirrorShape3D.size()];
            this.mirrorShape3D.toArray(s3dArr);
            createMessage.args[2] = s3dArr;
            Object[] obj = new Object[]{flag ? Boolean.TRUE : Boolean.FALSE, new Integer(this.changedFrequent)};
            createMessage.args[3] = obj;
            createMessage.args[4] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            VirtualUniverse.mc.processMessage(createMessage);
        }
        this.appearanceOverrideEnable = flag;
    }

    boolean getAppearanceOverrideEnable() {
        return this.appearanceOverrideEnable;
    }

    boolean intersect(PickInfo pickInfo, PickShape pickShape, int flags) {
        Transform3D localToVworld = pickInfo.getLocalToVWorldRef();
        Transform3D vworldToLocal = new Transform3D();
        vworldToLocal.invert(localToVworld);
        PickShape newPS = pickShape.transform(vworldToLocal);
        GeometryRetained geo = (GeometryRetained)this.morphedGeometryArray.retained;
        if (geo.mirrorGeometry != null) {
            geo = geo.mirrorGeometry;
        }
        if ((flags & 8) == 0 && (flags & 0x10) == 0 && (flags & 0x20) == 0 && (flags & 0x40) == 0) {
            return geo.intersect(newPS, null, 0, null, null, 0);
        }
        Point3d closestIPnt = new Point3d();
        Point3d iPnt = new Point3d();
        Point3d iPntVW = new Point3d();
        if (geo.intersect(newPS, pickInfo, flags, iPnt, geo, 0)) {
            iPntVW.set((Tuple3d)iPnt);
            localToVworld.transform(iPntVW);
            double distance = pickShape.distance(iPntVW);
            if ((flags & 0x10) != 0) {
                pickInfo.setClosestDistance(distance);
            }
            if ((flags & 8) != 0) {
                pickInfo.setClosestIntersectionPoint(iPnt);
            }
            return true;
        }
        return false;
    }

    boolean intersect(SceneGraphPath path, PickShape pickShape, double[] dist) {
        PickInfo pickInfo = new PickInfo();
        Transform3D localToVworld = path.getTransform();
        if (localToVworld == null) {
            throw new RuntimeException(J3dI18N.getString("MorphRetained5"));
        }
        pickInfo.setLocalToVWorldRef(localToVworld);
        if (dist == null) {
            return this.intersect(pickInfo, pickShape, 0);
        }
        int flags = 16;
        if (this.intersect(pickInfo, pickShape, flags)) {
            dist[0] = pickInfo.getClosestDistance();
            return true;
        }
        return false;
    }

    void setWeights(double[] weights) {
        int i;
        double sum = 0.0;
        if (weights.length != this.numGeometryArrays) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained7"));
        }
        for (i = weights.length - 1; i >= 0; --i) {
            sum += weights[i];
        }
        if (Math.abs(sum - 1.0) > 1.0E-4) {
            throw new IllegalArgumentException(J3dI18N.getString("MorphRetained8"));
        }
        for (i = this.numGeometryArrays - 1; i >= 0; --i) {
            this.weights[i] = weights[i];
        }
        if (this.source.isLive()) {
            ((GeometryArrayRetained)this.morphedGeometryArray.retained).updateData(this);
            J3dMessage mChangeMessage = null;
            mChangeMessage = new J3dMessage();
            mChangeMessage.type = 16;
            mChangeMessage.threads = 8256;
            if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
                mChangeMessage.threads |= 0x400;
            }
            mChangeMessage.args[0] = this;
            mChangeMessage.args[1] = new Integer(1);
            mChangeMessage.args[3] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            mChangeMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(mChangeMessage);
        }
    }

    double[] getWeights() {
        return (double[])this.weights.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    Bounds getBounds() {
        if (this.boundsAutoCompute) {
            GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            if (mga != null) {
                BoundingBox boundingBox = mga.geoBounds;
                synchronized (boundingBox) {
                    return (Bounds)mga.geoBounds.clone();
                }
            }
            return null;
        }
        return super.getBounds();
    }

    @Override
    Bounds getEffectiveBounds() {
        if (this.boundsAutoCompute) {
            return this.getBounds();
        }
        return super.getEffectiveBounds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void computeCombineBounds(Bounds bounds) {
        if (this.boundsAutoCompute) {
            GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            if (mga != null) {
                BoundingBox boundingBox = mga.geoBounds;
                synchronized (boundingBox) {
                    bounds.combine(mga.geoBounds);
                }
            }
        } else {
            Bounds bounds2 = this.localBounds;
            synchronized (bounds2) {
                bounds.combine(this.localBounds);
            }
        }
    }

    int getNumGeometryArrays() {
        return this.numGeometryArrays;
    }

    void updateMorphedGeometryArray(GeometryArrayRetained geo, boolean coordinatesChanged) {
        if (this.numGeometryArrays > 0) {
            if (this.geometryArrays[0] != geo) {
                this.doErrorCheck(geo, this.geometryArrays[0]);
            } else if (this.numGeometryArrays > 1) {
                this.doErrorCheck(geo, this.geometryArrays[1]);
            }
        }
        ((GeometryArrayRetained)this.morphedGeometryArray.retained).updateData(this);
        if (this.boundsAutoCompute && coordinatesChanged) {
            GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            mga.incrComputeGeoBounds();
            mga.decrComputeGeoBounds();
        }
    }

    @Override
    public void updateData(Geometry mga) {
        int j;
        int k;
        int i;
        boolean iCount = false;
        boolean numStrips = false;
        int texCoordSetCount = 0;
        float[] coord = new float[3];
        float[] color = new float[4];
        float[] normal = new float[3];
        float[] texCoord = new float[3];
        int vFormat = this.geometryArrays[0].vertexFormat;
        int geoType = this.geometryArrays[0].geoType;
        texCoordSetCount = this.geometryArrays[0].getTexCoordSetCount();
        int vc = 0;
        int nc = 0;
        int cc = 0;
        boolean n = false;
        int count = 0;
        count = this.geometryArrays[0] instanceof IndexedGeometryArrayRetained ? this.geometryArrays[0].getNumCoordCount() : this.geometryArrays[0].validVertexCount;
        for (i = 0; i < count; ++i) {
            int n2 = vc++;
            int n3 = vc++;
            this.Mcoord[vc++] = 0.0f;
            this.Mcoord[n3] = 0.0f;
            this.Mcoord[n2] = 0.0f;
        }
        if ((vFormat & 4) != 0) {
            count = this.geometryArrays[0] instanceof IndexedGeometryArrayRetained ? this.geometryArrays[0].getNumColorCount() : this.geometryArrays[0].validVertexCount;
            for (i = 0; i < count; ++i) {
                if ((vFormat & 0xC) == 4) {
                    int n4 = cc++;
                    int n5 = cc++;
                    this.Mcolor[cc++] = 0.0f;
                    this.Mcolor[n5] = 0.0f;
                    this.Mcolor[n4] = 0.0f;
                    continue;
                }
                if ((vFormat & 0xC) != 12) continue;
                int n6 = cc++;
                int n7 = cc++;
                int n8 = cc++;
                this.Mcolor[cc++] = 0.0f;
                this.Mcolor[n8] = 0.0f;
                this.Mcolor[n7] = 0.0f;
                this.Mcolor[n6] = 0.0f;
            }
        }
        if ((vFormat & 2) != 0) {
            count = this.geometryArrays[0] instanceof IndexedGeometryArrayRetained ? this.geometryArrays[0].getNumNormalCount() : this.geometryArrays[0].validVertexCount;
            for (i = 0; i < count; ++i) {
                int n9 = nc++;
                int n10 = nc++;
                this.Mnormal[nc++] = 0.0f;
                this.Mnormal[n10] = 0.0f;
                this.Mnormal[n9] = 0.0f;
            }
        }
        if ((vFormat & 0x460) != 0) {
            for (k = 0; k < texCoordSetCount; ++k) {
                count = this.geometryArrays[0] instanceof IndexedGeometryArrayRetained ? this.geometryArrays[0].getNumTexCoordCount(k) : this.geometryArrays[0].validVertexCount;
                int tcount = 0;
                for (i = 0; i < count; ++i) {
                    int n11 = tcount++;
                    this.MtexCoord[k][tcount++] = 0.0f;
                    this.MtexCoord[k][n11] = 0.0f;
                    if ((vFormat & 0x40) != 0) {
                        this.MtexCoord[k][tcount++] = 0.0f;
                        continue;
                    }
                    if ((vFormat & 0x400) == 0) continue;
                    this.MtexCoord[k][tcount++] = 0.0f;
                    this.MtexCoord[k][tcount++] = 0.0f;
                }
            }
        }
        if ((vFormat & 0x80) == 0) {
            count = 0;
            for (j = 0; j < this.numGeometryArrays; ++j) {
                double w = this.weights[j];
                if (w == 0.0) continue;
                vc = 0;
                nc = 0;
                cc = 0;
                int initialVertex = 0;
                if (this.geometryArrays[j] instanceof IndexedGeometryArrayRetained) {
                    initialVertex = 0;
                    count = this.geometryArrays[j].getNumCoordCount();
                } else {
                    initialVertex = this.geometryArrays[j].getInitialVertexIndex();
                    count = this.geometryArrays[j].validVertexCount;
                }
                int endVertex = initialVertex + count;
                for (i = initialVertex; i < endVertex; ++i) {
                    this.geometryArrays[j].getCoordinate(i, coord);
                    int n12 = vc++;
                    this.Mcoord[n12] = (float)((double)this.Mcoord[n12] + (double)coord[0] * w);
                    int n13 = vc++;
                    this.Mcoord[n13] = (float)((double)this.Mcoord[n13] + (double)coord[1] * w);
                    int n14 = vc++;
                    this.Mcoord[n14] = (float)((double)this.Mcoord[n14] + (double)coord[2] * w);
                }
                if ((vFormat & 4) != 0) {
                    if (this.geometryArrays[j] instanceof IndexedGeometryArrayRetained) {
                        count = this.geometryArrays[j].getNumColorCount();
                    }
                    endVertex = initialVertex + count;
                    for (i = initialVertex; i < endVertex; ++i) {
                        this.geometryArrays[j].getColor(i, color);
                        int n15 = cc++;
                        this.Mcolor[n15] = (float)((double)this.Mcolor[n15] + (double)color[0] * w);
                        int n16 = cc++;
                        this.Mcolor[n16] = (float)((double)this.Mcolor[n16] + (double)color[1] * w);
                        int n17 = cc++;
                        this.Mcolor[n17] = (float)((double)this.Mcolor[n17] + (double)color[2] * w);
                        if ((vFormat & 8) == 0) continue;
                        int n18 = cc++;
                        this.Mcolor[n18] = (float)((double)this.Mcolor[n18] + (double)color[3] * w);
                    }
                }
                if ((vFormat & 2) != 0) {
                    if (this.geometryArrays[j] instanceof IndexedGeometryArrayRetained) {
                        count = this.geometryArrays[j].getNumNormalCount();
                    }
                    endVertex = initialVertex + count;
                    for (i = initialVertex; i < endVertex; ++i) {
                        this.geometryArrays[j].getNormal(i, normal);
                        int n19 = nc++;
                        this.Mnormal[n19] = (float)((double)this.Mnormal[n19] + (double)normal[0] * w);
                        int n20 = nc++;
                        this.Mnormal[n20] = (float)((double)this.Mnormal[n20] + (double)normal[1] * w);
                        int n21 = nc++;
                        this.Mnormal[n21] = (float)((double)this.Mnormal[n21] + (double)normal[2] * w);
                    }
                }
                if ((vFormat & 0x460) == 0) continue;
                for (k = 0; k < texCoordSetCount; ++k) {
                    int tcount = 0;
                    if (this.geometryArrays[j] instanceof IndexedGeometryArrayRetained) {
                        count = this.geometryArrays[j].getNumTexCoordCount(i);
                    }
                    endVertex = initialVertex + count;
                    for (i = initialVertex; i < endVertex; ++i) {
                        this.geometryArrays[j].getTextureCoordinate(k, i, texCoord);
                        float[] fArray = this.MtexCoord[k];
                        int n22 = tcount++;
                        fArray[n22] = (float)((double)fArray[n22] + (double)texCoord[0] * w);
                        float[] fArray2 = this.MtexCoord[k];
                        int n23 = tcount++;
                        fArray2[n23] = (float)((double)fArray2[n23] + (double)texCoord[1] * w);
                        if ((vFormat & 0x40) != 0) {
                            float[] fArray3 = this.MtexCoord[k];
                            int n24 = tcount++;
                            fArray3[n24] = (float)((double)fArray3[n24] + (double)texCoord[2] * w);
                            continue;
                        }
                        if ((vFormat & 0x400) == 0) continue;
                        float[] fArray4 = this.MtexCoord[k];
                        int n25 = tcount++;
                        fArray4[n25] = (float)((double)fArray4[n25] + (double)texCoord[2] * w);
                        float[] fArray5 = this.MtexCoord[k];
                        int n26 = tcount++;
                        fArray5[n26] = (float)((double)fArray5[n26] + (double)texCoord[3] * w);
                    }
                }
            }
        } else {
            int vIndex;
            int nIndex;
            int cIndex;
            int tIndex;
            int tstride = 0;
            int cstride = 0;
            if ((vFormat & 0x460) != 0) {
                tstride = (vFormat & 0x20) != 0 ? 2 : ((vFormat & 0x40) != 0 ? 3 : 4);
            }
            if ((vFormat & 4) != 0) {
                cstride = 3;
                if ((vFormat & 8) != 0) {
                    cstride = 4;
                }
            }
            if ((vFormat & 0x100) != 0) {
                int stride = this.geometryArrays[0].stride();
                int coffset = this.geometryArrays[0].colorOffset();
                int noffset = this.geometryArrays[0].normalOffset();
                int voffset = this.geometryArrays[0].coordinateOffset();
                int offset = 0;
                boolean initialVertex = false;
                for (j = 0; j < this.numGeometryArrays; ++j) {
                    double w = this.weights[j];
                    if (w == 0.0) continue;
                    vc = 0;
                    nc = 0;
                    cc = 0;
                    n = false;
                    float[] vdata = this.geometryArrays[j].getInterleavedVertices();
                    if ((vFormat & 0x460) != 0) {
                        for (k = 0; k < texCoordSetCount; ++k) {
                            if (this.geometryArrays[j] instanceof IndexedGeometryArrayRetained) {
                                tIndex = 0;
                                count = this.geometryArrays[j].getNumCoordCount();
                            } else {
                                tIndex = this.geometryArrays[j].getInitialVertexIndex();
                                count = this.geometryArrays[j].validVertexCount;
                            }
                            offset = tIndex * stride + k * tstride;
                            int tcount = 0;
                            i = 0;
                            while (i < count) {
                                float[] fArray = this.MtexCoord[k];
                                int n27 = tcount++;
                                fArray[n27] = (float)((double)fArray[n27] + (double)vdata[offset] * w);
                                float[] fArray6 = this.MtexCoord[k];
                                int n28 = tcount++;
                                fArray6[n28] = (float)((double)fArray6[n28] + (double)vdata[offset + 1] * w);
                                if ((vFormat & 0x40) != 0) {
                                    float[] fArray7 = this.MtexCoord[k];
                                    int n29 = tcount++;
                                    fArray7[n29] = (float)((double)fArray7[n29] + (double)vdata[offset + 2] * w);
                                } else if ((vFormat & 0x400) != 0) {
                                    float[] fArray8 = this.MtexCoord[k];
                                    int n30 = tcount++;
                                    fArray8[n30] = (float)((double)fArray8[n30] + (double)vdata[offset + 2] * w);
                                    float[] fArray9 = this.MtexCoord[k];
                                    int n31 = tcount++;
                                    fArray9[n31] = (float)((double)fArray9[n31] + (double)vdata[offset + 3] * w);
                                }
                                ++i;
                                offset += stride;
                            }
                        }
                    }
                    if ((vFormat & 4) != 0) {
                        if (this.geometryArrays[j] instanceof IndexedGeometryArrayRetained) {
                            cIndex = 0;
                            count = this.geometryArrays[j].getNumCoordCount();
                        } else {
                            cIndex = this.geometryArrays[j].getInitialVertexIndex();
                            count = this.geometryArrays[j].validVertexCount;
                        }
                        offset = cIndex * stride + coffset;
                        i = 0;
                        while (i < count) {
                            int n32 = cc++;
                            this.Mcolor[n32] = (float)((double)this.Mcolor[n32] + (double)vdata[offset] * w);
                            int n33 = cc++;
                            this.Mcolor[n33] = (float)((double)this.Mcolor[n33] + (double)vdata[offset + 1] * w);
                            int n34 = cc++;
                            this.Mcolor[n34] = (float)((double)this.Mcolor[n34] + (double)vdata[offset + 2] * w);
                            if ((vFormat & 8) != 0) {
                                int n35 = cc++;
                                this.Mcolor[n35] = (float)((double)this.Mcolor[n35] + (double)vdata[offset + 3] * w);
                            }
                            ++i;
                            offset += stride;
                        }
                    }
                    if ((vFormat & 2) != 0) {
                        if (this.geometryArrays[j] instanceof IndexedGeometryArrayRetained) {
                            nIndex = 0;
                            count = this.geometryArrays[j].getNumCoordCount();
                        } else {
                            nIndex = this.geometryArrays[j].getInitialVertexIndex();
                            count = this.geometryArrays[j].validVertexCount;
                        }
                        offset = nIndex * stride + noffset;
                        i = 0;
                        while (i < count) {
                            int n36 = nc++;
                            this.Mnormal[n36] = (float)((double)this.Mnormal[n36] + (double)vdata[offset] * w);
                            int n37 = nc++;
                            this.Mnormal[n37] = (float)((double)this.Mnormal[n37] + (double)vdata[offset + 1] * w);
                            int n38 = nc++;
                            this.Mnormal[n38] = (float)((double)this.Mnormal[n38] + (double)vdata[offset + 2] * w);
                            ++i;
                            offset += stride;
                        }
                    }
                    if (this.geometryArrays[j] instanceof IndexedGeometryArrayRetained) {
                        vIndex = 0;
                        count = this.geometryArrays[j].getNumCoordCount();
                    } else {
                        vIndex = this.geometryArrays[j].getInitialVertexIndex();
                        count = this.geometryArrays[j].validVertexCount;
                    }
                    offset = vIndex * stride + voffset;
                    i = 0;
                    while (i < count) {
                        int n39 = vc++;
                        this.Mcoord[n39] = (float)((double)this.Mcoord[n39] + (double)vdata[offset] * w);
                        int n40 = vc++;
                        this.Mcoord[n40] = (float)((double)this.Mcoord[n40] + (double)vdata[offset + 1] * w);
                        int n41 = vc++;
                        this.Mcoord[n41] = (float)((double)this.Mcoord[n41] + (double)vdata[offset + 2] * w);
                        ++i;
                        offset += stride;
                    }
                }
            } else {
                float byteToFloatScale = 0.003921569f;
                block40: for (j = 0; j < this.numGeometryArrays; ++j) {
                    double w = this.weights[j];
                    if (w == 0.0) continue;
                    if ((vFormat & 0x460) != 0) {
                        switch (this.geometryArrays[j].vertexType & 0x7000) {
                            case 4096: {
                                for (k = 0; k < texCoordSetCount; ++k) {
                                    float[] tf = this.geometryArrays[j].getTexCoordRefFloat(k);
                                    if (this.geometryArrays[j] instanceof IndexedGeometryArrayRetained) {
                                        tIndex = 0;
                                        count = this.geometryArrays[j].getNumTexCoordCount(k);
                                    } else {
                                        tIndex = this.geometryArrays[j].getInitialTexCoordIndex(k);
                                        count = this.geometryArrays[j].validVertexCount;
                                    }
                                    tIndex *= tstride;
                                    int tcount = 0;
                                    for (i = 0; i < count; ++i) {
                                        float[] fArray = this.MtexCoord[k];
                                        int n42 = tcount++;
                                        fArray[n42] = (float)((double)fArray[n42] + (double)tf[tIndex++] * w);
                                        float[] fArray10 = this.MtexCoord[k];
                                        int n43 = tcount++;
                                        fArray10[n43] = (float)((double)fArray10[n43] + (double)tf[tIndex++] * w);
                                        if ((vFormat & 0x40) == 0) continue;
                                        float[] fArray11 = this.MtexCoord[k];
                                        int n44 = tcount++;
                                        fArray11[n44] = (float)((double)fArray11[n44] + (double)tf[tIndex++] * w);
                                    }
                                }
                                break;
                            }
                            case 8192: {
                                for (k = 0; k < texCoordSetCount; ++k) {
                                    int tcount = 0;
                                    float[] tf = this.geometryArrays[j].getTexCoordRefFloat(k);
                                    if (this.geometryArrays[j] instanceof IndexedGeometryArrayRetained) {
                                        tIndex = 0;
                                        count = this.geometryArrays[j].getNumTexCoordCount(k);
                                    } else {
                                        tIndex = this.geometryArrays[j].getInitialTexCoordIndex(k);
                                        count = this.geometryArrays[j].validVertexCount;
                                    }
                                    TexCoord2f[] t2f = this.geometryArrays[j].getTexCoordRef2f(k);
                                    i = 0;
                                    while (i < count) {
                                        float[] fArray = this.MtexCoord[k];
                                        int n45 = tcount++;
                                        fArray[n45] = (float)((double)fArray[n45] + (double)t2f[tIndex].x * w);
                                        float[] fArray12 = this.MtexCoord[k];
                                        int n46 = tcount++;
                                        fArray12[n46] = (float)((double)fArray12[n46] + (double)t2f[tIndex].y * w);
                                        ++i;
                                        ++tIndex;
                                    }
                                }
                                break;
                            }
                            case 16384: {
                                for (k = 0; k < texCoordSetCount; ++k) {
                                    int tcount = 0;
                                    TexCoord3f[] t3f = this.geometryArrays[j].getTexCoordRef3f(k);
                                    if (this.geometryArrays[j] instanceof IndexedGeometryArrayRetained) {
                                        tIndex = 0;
                                        count = this.geometryArrays[j].getNumTexCoordCount(k);
                                    } else {
                                        tIndex = this.geometryArrays[j].getInitialTexCoordIndex(k);
                                        count = this.geometryArrays[j].validVertexCount;
                                    }
                                    i = 0;
                                    while (i < count) {
                                        float[] fArray = this.MtexCoord[k];
                                        int n47 = tcount++;
                                        fArray[n47] = (float)((double)fArray[n47] + (double)t3f[tIndex].x * w);
                                        float[] fArray13 = this.MtexCoord[k];
                                        int n48 = tcount++;
                                        fArray13[n48] = (float)((double)fArray13[n48] + (double)t3f[tIndex].y * w);
                                        float[] fArray14 = this.MtexCoord[k];
                                        int n49 = tcount++;
                                        fArray14[n49] = (float)((double)fArray14[n49] + (double)t3f[tIndex].z * w);
                                        ++i;
                                        ++tIndex;
                                    }
                                }
                                break;
                            }
                        }
                    }
                    if ((vFormat & 4) != 0) {
                        double val = (double)byteToFloatScale * w;
                        if (this.geometryArrays[j] instanceof IndexedGeometryArrayRetained) {
                            cIndex = 0;
                            count = this.geometryArrays[j].getNumColorCount();
                        } else {
                            cIndex = this.geometryArrays[j].getInitialColorIndex();
                            count = this.geometryArrays[j].validVertexCount;
                        }
                        switch (this.geometryArrays[j].vertexType & 0x3F0) {
                            case 16: {
                                float[] cf = this.geometryArrays[j].getColorRefFloat();
                                cc = 0;
                                cIndex *= cstride;
                                for (i = 0; i < count; ++i) {
                                    int n50 = cc++;
                                    this.Mcolor[n50] = (float)((double)this.Mcolor[n50] + (double)cf[cIndex++] * w);
                                    int n51 = cc++;
                                    this.Mcolor[n51] = (float)((double)this.Mcolor[n51] + (double)cf[cIndex++] * w);
                                    int n52 = cc++;
                                    this.Mcolor[n52] = (float)((double)this.Mcolor[n52] + (double)cf[cIndex++] * w);
                                    if ((vFormat & 8) == 0) continue;
                                    int n53 = cc++;
                                    this.Mcolor[n53] = (float)((double)this.Mcolor[n53] + (double)cf[cIndex++] * w);
                                }
                                break;
                            }
                            case 32: {
                                byte[] cub = this.geometryArrays[j].getColorRefByte();
                                cc = 0;
                                cIndex *= cstride;
                                for (i = 0; i < count; ++i) {
                                    int n54 = cc++;
                                    this.Mcolor[n54] = (float)((double)this.Mcolor[n54] + (double)(cub[cIndex++] & 0xFF) * val);
                                    int n55 = cc++;
                                    this.Mcolor[n55] = (float)((double)this.Mcolor[n55] + (double)(cub[cIndex++] & 0xFF) * val);
                                    int n56 = cc++;
                                    this.Mcolor[n56] = (float)((double)this.Mcolor[n56] + (double)(cub[cIndex++] & 0xFF) * val);
                                    if ((vFormat & 8) == 0) continue;
                                    int n57 = cc++;
                                    this.Mcolor[n57] = (float)((double)this.Mcolor[n57] + (double)(cub[cIndex++] & 0xFF) * val);
                                }
                                break;
                            }
                            case 64: {
                                Color3f[] c3f = this.geometryArrays[j].getColorRef3f();
                                cc = 0;
                                i = 0;
                                while (i < count) {
                                    int n58 = cc++;
                                    this.Mcolor[n58] = (float)((double)this.Mcolor[n58] + (double)c3f[cIndex].x * w);
                                    int n59 = cc++;
                                    this.Mcolor[n59] = (float)((double)this.Mcolor[n59] + (double)c3f[cIndex].y * w);
                                    int n60 = cc++;
                                    this.Mcolor[n60] = (float)((double)this.Mcolor[n60] + (double)c3f[cIndex].z * w);
                                    ++i;
                                    ++cIndex;
                                }
                                break;
                            }
                            case 128: {
                                Color4f[] c4f = this.geometryArrays[j].getColorRef4f();
                                cc = 0;
                                i = 0;
                                while (i < count) {
                                    int n61 = cc++;
                                    this.Mcolor[n61] = (float)((double)this.Mcolor[n61] + (double)c4f[cIndex].x * w);
                                    int n62 = cc++;
                                    this.Mcolor[n62] = (float)((double)this.Mcolor[n62] + (double)c4f[cIndex].y * w);
                                    int n63 = cc++;
                                    this.Mcolor[n63] = (float)((double)this.Mcolor[n63] + (double)c4f[cIndex].z * w);
                                    int n64 = cc++;
                                    this.Mcolor[n64] = (float)((double)this.Mcolor[n64] + (double)c4f[cIndex].w * w);
                                    ++i;
                                    ++cIndex;
                                }
                                break;
                            }
                            case 256: {
                                Color3b[] c3b = this.geometryArrays[j].getColorRef3b();
                                cc = 0;
                                i = 0;
                                while (i < count) {
                                    int n65 = cc++;
                                    this.Mcolor[n65] = (float)((double)this.Mcolor[n65] + (double)(c3b[cIndex].x & 0xFF) * val);
                                    int n66 = cc++;
                                    this.Mcolor[n66] = (float)((double)this.Mcolor[n66] + (double)(c3b[cIndex].y & 0xFF) * val);
                                    int n67 = cc++;
                                    this.Mcolor[n67] = (float)((double)this.Mcolor[n67] + (double)(c3b[cIndex].z & 0xFF) * val);
                                    ++i;
                                    ++cIndex;
                                }
                                break;
                            }
                            case 512: {
                                Color4b[] c4b = this.geometryArrays[j].getColorRef4b();
                                cc = 0;
                                i = 0;
                                while (i < count) {
                                    int n68 = cc++;
                                    this.Mcolor[n68] = (float)((double)this.Mcolor[n68] + (double)(c4b[cIndex].x & 0xFF) * val);
                                    int n69 = cc++;
                                    this.Mcolor[n69] = (float)((double)this.Mcolor[n69] + (double)(c4b[cIndex].y & 0xFF) * val);
                                    int n70 = cc++;
                                    this.Mcolor[n70] = (float)((double)this.Mcolor[n70] + (double)(c4b[cIndex].z & 0xFF) * val);
                                    int n71 = cc++;
                                    this.Mcolor[n71] = (float)((double)this.Mcolor[n71] + (double)(c4b[cIndex].w & 0xFF) * val);
                                    ++i;
                                    ++cIndex;
                                }
                                break;
                            }
                        }
                    }
                    if ((vFormat & 2) != 0) {
                        nc = 0;
                        if (this.geometryArrays[j] instanceof IndexedGeometryArrayRetained) {
                            nIndex = 0;
                            count = this.geometryArrays[j].getNumNormalCount();
                        } else {
                            nIndex = this.geometryArrays[j].getInitialNormalIndex();
                            count = this.geometryArrays[j].validVertexCount;
                        }
                        switch (this.geometryArrays[j].vertexType & 0xC00) {
                            case 1024: {
                                float[] nf = this.geometryArrays[j].getNormalRefFloat();
                                nIndex *= 3;
                                for (i = 0; i < count; ++i) {
                                    int n72 = nc++;
                                    this.Mnormal[n72] = (float)((double)this.Mnormal[n72] + (double)nf[nIndex++] * w);
                                    int n73 = nc++;
                                    this.Mnormal[n73] = (float)((double)this.Mnormal[n73] + (double)nf[nIndex++] * w);
                                    int n74 = nc++;
                                    this.Mnormal[n74] = (float)((double)this.Mnormal[n74] + (double)nf[nIndex++] * w);
                                }
                                break;
                            }
                            case 2048: {
                                Vector3f[] n3f = this.geometryArrays[j].getNormalRef3f();
                                i = 0;
                                while (i < count) {
                                    int n75 = nc++;
                                    this.Mnormal[n75] = (float)((double)this.Mnormal[n75] + (double)n3f[nIndex].x * w);
                                    int n76 = nc++;
                                    this.Mnormal[n76] = (float)((double)this.Mnormal[n76] + (double)n3f[nIndex].y * w);
                                    int n77 = nc++;
                                    this.Mnormal[n77] = (float)((double)this.Mnormal[n77] + (double)n3f[nIndex].z * w);
                                    ++i;
                                    ++nIndex;
                                }
                                break;
                            }
                        }
                    }
                    vc = 0;
                    if (this.geometryArrays[j] instanceof IndexedGeometryArrayRetained) {
                        vIndex = 0;
                        count = this.geometryArrays[j].getNumCoordCount();
                    } else {
                        vIndex = this.geometryArrays[j].getInitialCoordIndex();
                        count = this.geometryArrays[j].validVertexCount;
                    }
                    switch (this.geometryArrays[j].vertexType & 0xF) {
                        case 1: {
                            float[] pf = this.geometryArrays[j].getCoordRefFloat();
                            vIndex *= 3;
                            for (i = 0; i < count; ++i) {
                                int n78 = vc++;
                                this.Mcoord[n78] = (float)((double)this.Mcoord[n78] + (double)pf[vIndex++] * w);
                                int n79 = vc++;
                                this.Mcoord[n79] = (float)((double)this.Mcoord[n79] + (double)pf[vIndex++] * w);
                                int n80 = vc++;
                                this.Mcoord[n80] = (float)((double)this.Mcoord[n80] + (double)pf[vIndex++] * w);
                            }
                            continue block40;
                        }
                        case 2: {
                            double[] pd = this.geometryArrays[j].getCoordRefDouble();
                            vIndex *= 3;
                            for (i = 0; i < count; ++i) {
                                int n81 = vc++;
                                this.Mcoord[n81] = (float)((double)this.Mcoord[n81] + (double)((float)pd[vIndex++]) * w);
                                int n82 = vc++;
                                this.Mcoord[n82] = (float)((double)this.Mcoord[n82] + (double)((float)pd[vIndex++]) * w);
                                int n83 = vc++;
                                this.Mcoord[n83] = (float)((double)this.Mcoord[n83] + (double)((float)pd[vIndex++]) * w);
                            }
                            continue block40;
                        }
                        case 4: {
                            Point3f[] p3f = this.geometryArrays[j].getCoordRef3f();
                            i = 0;
                            while (i < count) {
                                int n84 = vc++;
                                this.Mcoord[n84] = (float)((double)this.Mcoord[n84] + (double)p3f[vIndex].x * w);
                                int n85 = vc++;
                                this.Mcoord[n85] = (float)((double)this.Mcoord[n85] + (double)p3f[vIndex].y * w);
                                int n86 = vc++;
                                this.Mcoord[n86] = (float)((double)this.Mcoord[n86] + (double)p3f[vIndex].z * w);
                                ++i;
                                ++vIndex;
                            }
                            continue block40;
                        }
                        case 8: {
                            Point3d[] p3d = this.geometryArrays[j].getCoordRef3d();
                            i = 0;
                            while (i < count) {
                                int n87 = vc++;
                                this.Mcoord[n87] = (float)((double)this.Mcoord[n87] + (double)((float)p3d[vIndex].x) * w);
                                int n88 = vc++;
                                this.Mcoord[n88] = (float)((double)this.Mcoord[n88] + (double)((float)p3d[vIndex].y) * w);
                                int n89 = vc++;
                                this.Mcoord[n89] = (float)((double)this.Mcoord[n89] + (double)((float)p3d[vIndex].z) * w);
                                ++i;
                                ++vIndex;
                            }
                            continue block40;
                        }
                    }
                }
            }
        }
        GeometryArrayRetained mgaR = (GeometryArrayRetained)mga.retained;
        mgaR.setCoordRefFloat(this.Mcoord);
        if ((vFormat & 4) != 0) {
            mgaR.setColorRefFloat(this.Mcolor);
        }
        if ((vFormat & 2) != 0) {
            mgaR.setNormalRefFloat(this.Mnormal);
        }
        if ((vFormat & 0x460) != 0) {
            for (k = 0; k < texCoordSetCount; ++k) {
                mgaR.setTexCoordRefFloat(k, this.MtexCoord[k]);
            }
        }
    }

    void updateImmediateMirrorObject(Object[] objs) {
        int i;
        int val;
        Object[] arg;
        int component = (Integer)objs[1];
        Shape3DRetained[] msArr = (Shape3DRetained[])objs[2];
        if ((component & 2) != 0) {
            arg = (Object[])objs[3];
            val = (Integer)arg[1];
            for (i = msArr.length - 1; i >= 0; --i) {
                msArr[i].appearance = (AppearanceRetained)arg[0];
                msArr[i].changedFrequent = val;
            }
        }
        if ((component & 0x10) != 0) {
            arg = (Object[])objs[3];
            val = (Integer)arg[1];
            System.err.println("ChangedFrequent = " + this.changedFrequent);
            for (i = msArr.length - 1; i >= 0; --i) {
                msArr[i].appearanceOverrideEnable = (Boolean)arg[0];
                msArr[i].changedFrequent = val;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setLive(SetLiveState s) {
        GeometryAtom ga;
        int m;
        ArrayList<LeafRetained> l;
        Shape3DRetained shape;
        int i;
        ArrayList<Shape3DRetained> msList = new ArrayList<Shape3DRetained>();
        int oldrefCount = this.refCount;
        super.doSetLive(s);
        this.nodeId = this.universe.getNodeId();
        for (i = 0; i < this.numGeometryArrays; ++i) {
            Object object = this.geometryArrays[i].liveStateLock;
            synchronized (object) {
                this.geometryArrays[i].setLive(this.inBackgroundGroup, s.refCount);
                if (oldrefCount <= 0) {
                    this.geometryArrays[i].addMorphUser(this);
                }
                continue;
            }
        }
        if (this.morphedGeometryArray == null) {
            this.initMorphedGeometry();
        }
        ((GeometryArrayRetained)this.morphedGeometryArray.retained).setLive(this.inBackgroundGroup, s.refCount);
        if (this.boundsAutoCompute) {
            GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
            mga.incrComputeGeoBounds();
            mga.decrComputeGeoBounds();
            this.localBounds.setWithLock(mga.geoBounds);
        }
        if (this.inSharedGroup) {
            for (i = 0; i < s.keys.length; ++i) {
                shape = new Shape3DRetained();
                shape.key = s.keys[i];
                shape.localToVworld = new Transform3D[1][];
                shape.localToVworldIndex = new int[1][];
                int j = s.keys[i].equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
                if (j < 0) {
                    System.err.println("MorphRetained : Can't find hashKey");
                }
                shape.localToVworld[0] = this.localToVworld[j];
                shape.localToVworldIndex[0] = this.localToVworldIndex[j];
                shape.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(j);
                shape.isPickable = s.pickable[i];
                shape.isCollidable = s.collidable[i];
                shape.initMirrorShape3D(s, this, j);
                this.mirrorShape3D.add(j, shape);
                msList.add(shape);
                if (s.lights != null && (l = s.lights.get(j)) != null) {
                    for (m = 0; m < l.size(); ++m) {
                        shape.addLight((LightRetained)l.get(m));
                    }
                }
                if (s.fogs != null && (l = s.fogs.get(j)) != null) {
                    for (m = 0; m < l.size(); ++m) {
                        shape.addFog((FogRetained)l.get(m));
                    }
                }
                if (s.modelClips != null && (l = s.modelClips.get(j)) != null) {
                    for (m = 0; m < l.size(); ++m) {
                        shape.addModelClip((ModelClipRetained)l.get(m));
                    }
                }
                if (s.altAppearances != null && (l = s.altAppearances.get(j)) != null) {
                    for (m = 0; m < l.size(); ++m) {
                        shape.addAltApp((AlternateAppearanceRetained)l.get(m));
                    }
                }
                shape.viewList = s.viewLists != null ? s.viewLists.get(i) : null;
                ga = Shape3DRetained.getGeomAtom(shape);
                s.nodeList.add(ga);
                if (s.transformTargets != null && s.transformTargets[i] != null) {
                    s.transformTargets[i].addNode(ga, 0);
                }
                if (s.switchTargets != null && s.switchTargets[i] != null) {
                    s.switchTargets[i].addNode(shape, 0);
                    shape.closestSwitchParent = s.closestSwitchParents[i];
                    shape.closestSwitchIndex = s.closestSwitchIndices[i];
                }
                shape.switchState = s.switchStates.get(j);
            }
        } else {
            shape = new Shape3DRetained();
            shape.localToVworld = new Transform3D[1][];
            shape.localToVworldIndex = new int[1][];
            shape.localToVworld[0] = this.localToVworld[0];
            shape.localToVworldIndex[0] = this.localToVworldIndex[0];
            shape.branchGroupPath = (BranchGroupRetained[])this.branchGroupPaths.get(0);
            shape.isPickable = s.pickable[0];
            shape.isCollidable = s.collidable[0];
            shape.initMirrorShape3D(s, this, 0);
            this.mirrorShape3D.add(shape);
            msList.add(shape);
            if (s.lights != null && (l = s.lights.get(0)) != null) {
                for (m = 0; m < l.size(); ++m) {
                    shape.addLight((LightRetained)l.get(m));
                }
            }
            if (s.fogs != null && (l = s.fogs.get(0)) != null) {
                for (m = 0; m < l.size(); ++m) {
                    shape.addFog((FogRetained)l.get(m));
                }
            }
            if (s.modelClips != null && (l = s.modelClips.get(0)) != null) {
                for (m = 0; m < l.size(); ++m) {
                    shape.addModelClip((ModelClipRetained)l.get(m));
                }
            }
            if (s.altAppearances != null && (l = s.altAppearances.get(0)) != null) {
                for (m = 0; m < l.size(); ++m) {
                    shape.addAltApp((AlternateAppearanceRetained)l.get(m));
                }
            }
            shape.viewList = s.viewLists != null ? s.viewLists.get(0) : null;
            ga = Shape3DRetained.getGeomAtom(shape);
            s.nodeList.add(ga);
            if (s.transformTargets != null && s.transformTargets[0] != null) {
                s.transformTargets[0].addNode(ga, 0);
            }
            if (s.switchTargets != null && s.switchTargets[0] != null) {
                s.switchTargets[0].addNode(shape, 0);
                shape.closestSwitchParent = s.closestSwitchParents[0];
                shape.closestSwitchIndex = s.closestSwitchIndices[0];
            }
            shape.switchState = s.switchStates.get(0);
        }
        if (this.appearance != null) {
            l = this.appearance.liveStateLock;
            synchronized (l) {
                this.appearance.setLive(this.inBackgroundGroup, s.refCount);
                this.appearance.initMirrorObject();
                if (this.appearance.renderingAttributes != null) {
                    this.visible = this.appearance.renderingAttributes.visible;
                }
                for (int k = 0; k < msList.size(); ++k) {
                    Shape3DRetained sh = (Shape3DRetained)msList.get(k);
                    sh.appearance = (AppearanceRetained)this.appearance.mirror;
                    this.appearance.addAMirrorUser(sh);
                }
            }
        } else {
            for (int k = 0; k < msList.size(); ++k) {
                Shape3DRetained sh = (Shape3DRetained)msList.get(k);
                sh.appearance = null;
            }
        }
        s.notifyThreads |= 0x24C0;
        if (this.refCount == 1 && this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
            J3dMessage mChangeMessage = new J3dMessage();
            mChangeMessage.type = 16;
            mChangeMessage.threads = 1024;
            mChangeMessage.args[0] = this;
            mChangeMessage.args[1] = new Integer(1);
            mChangeMessage.universe = this.universe;
            VirtualUniverse.mc.processMessage(mChangeMessage);
        }
        super.markAsLive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void clearLive(SetLiveState s) {
        GeometryAtom ga;
        Shape3DRetained shape;
        int i;
        ArrayList<Shape3DRetained> appList = new ArrayList<Shape3DRetained>();
        super.clearLive(s);
        for (i = 0; i < this.numGeometryArrays; ++i) {
            Object object = this.geometryArrays[i].liveStateLock;
            synchronized (object) {
                this.geometryArrays[i].clearLive(s.refCount);
                if (this.refCount <= 0) {
                    this.geometryArrays[i].removeMorphUser(this);
                }
                continue;
            }
        }
        GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
        mga.clearLive(s.refCount);
        if (this.inSharedGroup) {
            Object[] shapes = this.mirrorShape3D.toArray();
            for (i = 0; i < s.keys.length; ++i) {
                for (int j = 0; j < shapes.length; ++j) {
                    shape = (Shape3DRetained)shapes[j];
                    if (!shape.key.equals((Object)s.keys[i])) continue;
                    this.mirrorShape3D.remove(j);
                    if (s.switchTargets != null && s.switchTargets[i] != null) {
                        s.switchTargets[i].addNode(shape, 0);
                    }
                    if (this.appearance != null) {
                        appList.add(shape);
                    }
                    ga = Shape3DRetained.getGeomAtom(shape);
                    s.nodeList.add(ga);
                    if (s.transformTargets == null || s.transformTargets[i] == null) continue;
                    s.transformTargets[i].addNode(ga, 0);
                }
            }
        } else {
            shape = (Shape3DRetained)this.mirrorShape3D.get(0);
            this.mirrorShape3D.remove(0);
            if (s.switchTargets != null && s.switchTargets[0] != null) {
                s.switchTargets[0].addNode(shape, 0);
            }
            if (this.appearance != null) {
                appList.add(shape);
            }
            ga = Shape3DRetained.getGeomAtom(shape);
            s.nodeList.add(ga);
            if (s.transformTargets != null && s.transformTargets[0] != null) {
                s.transformTargets[0].addNode(ga, 0);
            }
        }
        if (this.appearance != null) {
            Object object = this.appearance.liveStateLock;
            synchronized (object) {
                this.appearance.clearLive(s.refCount);
                for (int k = 0; k < appList.size(); ++k) {
                    this.appearance.removeAMirrorUser((Shape3DRetained)appList.get(k));
                }
            }
        }
        s.notifyThreads |= 0x30C0;
    }

    @Override
    void updatePickable(HashKey[] keys, boolean[] pick) {
        super.updatePickable(keys, pick);
        if (!this.inSharedGroup) {
            Shape3DRetained shape = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape.isPickable = pick[0];
        } else {
            int size = this.mirrorShape3D.size();
            block0: for (int j = 0; j < keys.length; ++j) {
                for (int i = 0; i < size; ++i) {
                    Shape3DRetained shape = (Shape3DRetained)this.mirrorShape3D.get(i);
                    if (!keys[j].equals((Object)shape.key)) continue;
                    shape.isPickable = pick[j];
                    continue block0;
                }
            }
        }
    }

    @Override
    void updateCollidable(HashKey[] keys, boolean[] collide) {
        super.updateCollidable(keys, collide);
        if (!this.inSharedGroup) {
            Shape3DRetained shape = (Shape3DRetained)this.mirrorShape3D.get(0);
            shape.isCollidable = collide[0];
        } else {
            int size = this.mirrorShape3D.size();
            block0: for (int j = 0; j < keys.length; ++j) {
                for (int i = 0; i < size; ++i) {
                    Shape3DRetained shape = (Shape3DRetained)this.mirrorShape3D.get(i);
                    if (!keys[j].equals((Object)shape.key)) continue;
                    shape.isCollidable = collide[j];
                    continue block0;
                }
            }
        }
    }

    Shape3DRetained getMirrorShape(SceneGraphPath path) {
        if (!this.inSharedGroup) {
            return (Shape3DRetained)this.mirrorShape3D.get(0);
        }
        HashKey key = new HashKey("");
        path.getHashKey(key);
        return this.getMirrorShape(key);
    }

    Shape3DRetained getMirrorShape(HashKey key) {
        int i = key.equals(this.localToVworldKeys, 0, this.localToVworldKeys.length);
        if (i >= 0) {
            return (Shape3DRetained)this.mirrorShape3D.get(i);
        }
        throw new RuntimeException("Shape3DRetained: MirrorShape Not found!");
    }

    @Override
    void getMirrorObjects(ArrayList leafList, HashKey key) {
        Shape3DRetained ms = this.inSharedGroup ? this.getMirrorShape(key) : (Shape3DRetained)this.mirrorShape3D.get(0);
        GeometryAtom ga = Shape3DRetained.getGeomAtom(ms);
        leafList.add(ga);
    }

    @Override
    void setBoundsAutoCompute(boolean autoCompute) {
        if (autoCompute != this.boundsAutoCompute) {
            if (autoCompute) {
                this.localBounds = new BoundingBox();
                if (this.source.isLive() && this.morphedGeometryArray != null) {
                    GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
                    mga.incrComputeGeoBounds();
                    mga.decrComputeGeoBounds();
                }
            }
            this.localBounds = this.getBounds();
            super.setBoundsAutoCompute(autoCompute);
            if (this.source.isLive()) {
                J3dMessage message = new J3dMessage();
                message.type = 37;
                message.threads = 8384;
                message.universe = this.universe;
                message.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
                message.args[1] = this.localBounds;
                VirtualUniverse.mc.processMessage(message);
            }
        }
    }

    @Override
    void updateBounds() {
        this.localBounds = this.getEffectiveBounds();
        if (this.source.isLive()) {
            J3dMessage message = new J3dMessage();
            message.type = 37;
            message.threads = 8384;
            message.universe = this.universe;
            message.args[0] = Shape3DRetained.getGeomAtomsArray(this.mirrorShape3D);
            message.args[1] = this.localBounds;
            VirtualUniverse.mc.processMessage(message);
        }
    }

    void initMorphedGeometry() {
        int iCount = 0;
        int numStrips = 0;
        int texCoordSetCount = 0;
        int texCoordSetMapLen = 0;
        int[] texCoordSetMap = null;
        GeometryArrayRetained geo = this.geometryArrays[0];
        int vFormat = (geo.getVertexFormat() | 0x80) & 0xFFFFFEFF;
        texCoordSetCount = geo.getTexCoordSetCount();
        texCoordSetMapLen = geo.getTexCoordSetMapLength();
        if (texCoordSetMapLen > 0) {
            texCoordSetMap = new int[texCoordSetMapLen];
            geo.getTexCoordSetMap(texCoordSetMap);
        }
        int geoType = geo.geoType;
        switch (geoType) {
            case 1: {
                this.morphedGeometryArray = new QuadArray(this.geometryArrays[0].validVertexCount, vFormat, texCoordSetCount, texCoordSetMap);
                break;
            }
            case 2: {
                this.morphedGeometryArray = new TriangleArray(this.geometryArrays[0].validVertexCount, vFormat, texCoordSetCount, texCoordSetMap);
                break;
            }
            case 3: {
                this.morphedGeometryArray = new PointArray(this.geometryArrays[0].validVertexCount, vFormat, texCoordSetCount, texCoordSetMap);
                break;
            }
            case 4: {
                this.morphedGeometryArray = new LineArray(this.geometryArrays[0].validVertexCount, vFormat, texCoordSetCount, texCoordSetMap);
                break;
            }
            case 5: {
                numStrips = ((TriangleStripArrayRetained)geo).getNumStrips();
                int[] stripVCount = new int[numStrips];
                ((TriangleStripArrayRetained)geo).getStripVertexCounts(stripVCount);
                this.morphedGeometryArray = new TriangleStripArray(this.geometryArrays[0].validVertexCount, vFormat, texCoordSetCount, texCoordSetMap, stripVCount);
                break;
            }
            case 6: {
                numStrips = ((TriangleFanArrayRetained)geo).getNumStrips();
                int[] stripVCount = new int[numStrips];
                ((TriangleFanArrayRetained)geo).getStripVertexCounts(stripVCount);
                this.morphedGeometryArray = new TriangleFanArray(this.geometryArrays[0].validVertexCount, vFormat, texCoordSetCount, texCoordSetMap, stripVCount);
                break;
            }
            case 7: {
                numStrips = ((LineStripArrayRetained)geo).getNumStrips();
                int[] stripVCount = new int[numStrips];
                ((LineStripArrayRetained)geo).getStripVertexCounts(stripVCount);
                this.morphedGeometryArray = new LineStripArray(this.geometryArrays[0].validVertexCount, vFormat, texCoordSetCount, texCoordSetMap, stripVCount);
                break;
            }
            case 8: {
                iCount = ((IndexedGeometryArrayRetained)geo).getIndexCount();
                this.morphedGeometryArray = new IndexedQuadArray(this.geometryArrays[0].getNumCoordCount(), vFormat, texCoordSetCount, texCoordSetMap, iCount);
                break;
            }
            case 9: {
                iCount = ((IndexedGeometryArrayRetained)geo).getIndexCount();
                this.morphedGeometryArray = new IndexedTriangleArray(this.geometryArrays[0].getNumCoordCount(), vFormat, texCoordSetCount, texCoordSetMap, iCount);
                break;
            }
            case 10: {
                iCount = ((IndexedGeometryArrayRetained)geo).getIndexCount();
                this.morphedGeometryArray = new IndexedPointArray(this.geometryArrays[0].getNumCoordCount(), vFormat, texCoordSetCount, texCoordSetMap, iCount);
                break;
            }
            case 11: {
                iCount = ((IndexedGeometryArrayRetained)geo).getIndexCount();
                this.morphedGeometryArray = new IndexedLineArray(this.geometryArrays[0].getNumCoordCount(), vFormat, texCoordSetCount, texCoordSetMap, iCount);
                break;
            }
            case 12: {
                iCount = ((IndexedGeometryArrayRetained)geo).getIndexCount();
                numStrips = ((IndexedTriangleStripArrayRetained)geo).getNumStrips();
                int[] stripVCount = new int[numStrips];
                ((IndexedTriangleStripArrayRetained)geo).getStripIndexCounts(stripVCount);
                this.morphedGeometryArray = new IndexedTriangleStripArray(this.geometryArrays[0].getNumCoordCount(), vFormat, texCoordSetCount, texCoordSetMap, iCount, stripVCount);
                break;
            }
            case 13: {
                iCount = ((IndexedGeometryArrayRetained)geo).getIndexCount();
                numStrips = ((IndexedTriangleFanArrayRetained)geo).getNumStrips();
                int[] stripVCount = new int[numStrips];
                ((IndexedTriangleFanArrayRetained)geo).getStripIndexCounts(stripVCount);
                this.morphedGeometryArray = new IndexedTriangleFanArray(this.geometryArrays[0].getNumCoordCount(), vFormat, texCoordSetCount, texCoordSetMap, iCount, stripVCount);
                break;
            }
            case 14: {
                iCount = ((IndexedGeometryArrayRetained)geo).getIndexCount();
                numStrips = ((IndexedLineStripArrayRetained)geo).getNumStrips();
                int[] stripVCount = new int[numStrips];
                ((IndexedLineStripArrayRetained)geo).getStripIndexCounts(stripVCount);
                this.morphedGeometryArray = new IndexedLineStripArray(this.geometryArrays[0].getNumCoordCount(), vFormat, texCoordSetCount, texCoordSetMap, iCount, stripVCount);
            }
        }
        if (this.geometryArrays[0] instanceof IndexedGeometryArrayRetained) {
            IndexedGeometryArrayRetained igeo = (IndexedGeometryArrayRetained)this.geometryArrays[0];
            IndexedGeometryArray morphedGeo = (IndexedGeometryArray)this.morphedGeometryArray;
            if ((vFormat & 1) != 0) {
                morphedGeo.setCoordinateIndices(0, igeo.indexCoord);
            }
            if ((vFormat & 0x200) == 0) {
                if ((vFormat & 2) != 0) {
                    morphedGeo.setNormalIndices(0, igeo.indexNormal);
                }
                if ((vFormat & 4) != 0) {
                    morphedGeo.setColorIndices(0, igeo.indexColor);
                }
                if ((vFormat & 0x460) != 0) {
                    for (int k = 0; k < texCoordSetCount; ++k) {
                        morphedGeo.setTextureCoordinateIndices(k, 0, igeo.indexTexCoord[k]);
                    }
                }
            }
        }
        this.morphedGeometryArray.setCapability(19);
        GeometryArrayRetained mga = (GeometryArrayRetained)this.morphedGeometryArray.retained;
        mga.updateData(this);
    }

    void getMirrorShape3D(ArrayList list, HashKey k) {
        Shape3DRetained ms = this.inSharedGroup ? this.getMirrorShape(k) : (Shape3DRetained)this.mirrorShape3D.get(0);
        list.add(ms);
    }

    @Override
    void compile(CompileState compState) {
        super.compile(compState);
        compState.keepTG = true;
        if (J3dDebug.debug) {
            ++compState.numMorphs;
        }
    }

    void doErrorCheck(GeometryArrayRetained prevGeo, GeometryArrayRetained geo) {
        block12: {
            int k;
            int[] svc;
            int[] prevSvc;
            block11: {
                int k2;
                if (prevGeo.vertexFormat != geo.vertexFormat || prevGeo.validVertexCount != geo.validVertexCount || prevGeo.geoType != geo.geoType || prevGeo.texCoordSetCount != geo.texCoordSetCount) {
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                if (geo.getTexCoordSetMapLength() != prevGeo.getTexCoordSetMapLength()) {
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                int texCoordSetMapLen = geo.getTexCoordSetMapLength();
                prevSvc = prevGeo.texCoordSetMap;
                svc = geo.texCoordSetMap;
                for (k2 = 0; k2 < texCoordSetMapLen; ++k2) {
                    if (prevSvc[k2] == svc[k2]) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                if (!(geo instanceof GeometryStripArrayRetained)) break block11;
                prevSvc = ((GeometryStripArrayRetained)prevGeo).stripVertexCounts;
                svc = ((GeometryStripArrayRetained)geo).stripVertexCounts;
                if (prevSvc.length != svc.length) {
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                for (k2 = 0; k2 < prevSvc.length; ++k2) {
                    if (prevSvc[k2] == svc[k2]) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                break block12;
            }
            if (!(geo instanceof IndexedGeometryArrayRetained)) break block12;
            if (((IndexedGeometryArrayRetained)prevGeo).validIndexCount != ((IndexedGeometryArrayRetained)geo).validIndexCount) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            if (geo.getNumCoordCount() != prevGeo.getNumCoordCount() || geo.getNumColorCount() != prevGeo.getNumColorCount() || geo.getNumNormalCount() != prevGeo.getNumNormalCount()) {
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            int texCoordSetCount = geo.getTexCoordSetCount();
            for (k = 0; k < texCoordSetCount; ++k) {
                if (geo.getNumTexCoordCount(k) == prevGeo.getNumTexCoordCount(k)) continue;
                throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
            }
            if (geo instanceof IndexedGeometryStripArrayRetained) {
                prevSvc = ((IndexedGeometryStripArrayRetained)prevGeo).stripIndexCounts;
                svc = ((IndexedGeometryStripArrayRetained)geo).stripIndexCounts;
                if (prevSvc.length != svc.length) {
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
                for (k = 0; k < prevSvc.length; ++k) {
                    if (prevSvc[k] == svc[k]) continue;
                    throw new IllegalArgumentException(J3dI18N.getString("MorphRetained1"));
                }
            }
        }
    }

    @Override
    void handleFrequencyChange(int bit) {
        int mask = 0;
        if (bit == 13) {
            mask = 1;
        } else if (bit == 15) {
            mask = 2;
        } else if (bit == 21) {
            mask = 16;
        }
        if (mask != 0) {
            if (this.source.getCapabilityIsFrequent(bit)) {
                this.changedFrequent |= mask;
            } else if (!this.source.isLive()) {
                this.changedFrequent &= ~mask;
            }
        }
    }

    @Override
    void searchGeometryAtoms(UnorderList list) {
        list.add(Shape3DRetained.getGeomAtom((Shape3DRetained)this.mirrorShape3D.get(0)));
    }
}

