/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.java3d;

import org.scijava.java3d.IndexedGeometryArray;
import org.scijava.java3d.IndexedTriangleArrayRetained;
import org.scijava.java3d.J3dI18N;
import org.scijava.java3d.NodeComponent;

public class IndexedTriangleArray
extends IndexedGeometryArray {
    IndexedTriangleArray() {
    }

    public IndexedTriangleArray(int vertexCount, int vertexFormat, int indexCount) {
        super(vertexCount, vertexFormat, indexCount);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleArray0"));
        }
        if (indexCount < 3 || indexCount % 3 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleArray1"));
        }
    }

    public IndexedTriangleArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int indexCount) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, indexCount);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleArray0"));
        }
        if (indexCount < 3 || indexCount % 3 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleArray1"));
        }
    }

    public IndexedTriangleArray(int vertexCount, int vertexFormat, int texCoordSetCount, int[] texCoordSetMap, int vertexAttrCount, int[] vertexAttrSizes, int indexCount) {
        super(vertexCount, vertexFormat, texCoordSetCount, texCoordSetMap, vertexAttrCount, vertexAttrSizes, indexCount);
        if (vertexCount < 1) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleArray0"));
        }
        if (indexCount < 3 || indexCount % 3 != 0) {
            throw new IllegalArgumentException(J3dI18N.getString("IndexedTriangleArray1"));
        }
    }

    @Override
    void createRetained() {
        this.retained = new IndexedTriangleArrayRetained();
        this.retained.setSource(this);
    }

    @Override
    public NodeComponent cloneNodeComponent() {
        IndexedTriangleArrayRetained rt = (IndexedTriangleArrayRetained)this.retained;
        int texSetCount = rt.getTexCoordSetCount();
        int[] texMap = null;
        int vertexAttrCount = rt.getVertexAttrCount();
        int[] vertexAttrSizes = null;
        if (texSetCount > 0) {
            texMap = new int[rt.getTexCoordSetMapLength()];
            rt.getTexCoordSetMap(texMap);
        }
        if (vertexAttrCount > 0) {
            vertexAttrSizes = new int[vertexAttrCount];
            rt.getVertexAttrSizes(vertexAttrSizes);
        }
        IndexedTriangleArray t = new IndexedTriangleArray(rt.getVertexCount(), rt.getVertexFormat(), texSetCount, texMap, vertexAttrCount, vertexAttrSizes, rt.getIndexCount());
        t.duplicateNodeComponent(this);
        return t;
    }
}

