/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.mesh;

import java.util.HashMap;
import net.imagej.mesh.MarchingCubesBooleanType;
import net.imagej.mesh.MarchingCubesRealType;
import net.imagej.mesh.Mesh;
import net.imagej.mesh.RemoveDuplicateVertices;
import net.imagej.mesh.SimplifyMesh;
import net.imagej.mesh.Triangle;
import net.imagej.mesh.Vertex;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.type.BooleanType;
import net.imglib2.type.numeric.RealType;

public class Meshes {
    public static RealPoint center(Mesh m) {
        RealPoint p = new RealPoint(new float[]{0.0f, 0.0f, 0.0f});
        for (Vertex v : m.vertices()) {
            p.move((RealLocalizable)v);
        }
        for (int d = 0; d < 3; ++d) {
            p.setPosition(p.getDoublePosition(d) / (double)m.vertices().size(), d);
        }
        return p;
    }

    public static float[] boundingBox(Mesh mesh) {
        float[] boundingBox = new float[]{Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY, Float.NEGATIVE_INFINITY};
        for (Vertex v : mesh.vertices()) {
            float x = v.xf();
            float y = v.yf();
            float z = v.zf();
            if (x < boundingBox[0]) {
                boundingBox[0] = x;
            }
            if (y < boundingBox[1]) {
                boundingBox[1] = y;
            }
            if (z < boundingBox[2]) {
                boundingBox[2] = z;
            }
            if (x > boundingBox[3]) {
                boundingBox[3] = x;
            }
            if (y > boundingBox[4]) {
                boundingBox[4] = y;
            }
            if (!(z > boundingBox[5])) continue;
            boundingBox[5] = z;
        }
        return boundingBox;
    }

    public static void copy(Mesh src, Mesh dest) {
        HashMap<Long, Long> vIndexMap = new HashMap<Long, Long>();
        for (Vertex v : src.vertices()) {
            long destIndex;
            long srcIndex = v.index();
            if (srcIndex == (destIndex = dest.vertices().add(v.x(), v.y(), v.z(), v.nx(), v.ny(), v.nz(), v.u(), v.v()))) continue;
            vIndexMap.put(srcIndex, destIndex);
        }
        for (Triangle tri : src.triangles()) {
            long v0src = tri.vertex0();
            long v1src = tri.vertex1();
            long v2src = tri.vertex2();
            long v0 = vIndexMap.getOrDefault(v0src, v0src);
            long v1 = vIndexMap.getOrDefault(v1src, v1src);
            long v2 = vIndexMap.getOrDefault(v2src, v2src);
            dest.triangles().add(v0, v1, v2, tri.nx(), tri.ny(), tri.nz());
        }
    }

    public static void calculateNormals(Mesh src, Mesh dest) {
        HashMap<Long, float[]> triNormals = new HashMap<Long, float[]>();
        for (Triangle tri : src.triangles()) {
            int v0 = (int)tri.vertex0();
            int v1 = (int)tri.vertex1();
            int v2 = (int)tri.vertex2();
            float v0x = src.vertices().xf(v0);
            float v0y = src.vertices().yf(v0);
            float v0z = src.vertices().zf(v0);
            float v1x = src.vertices().xf(v1);
            float v1y = src.vertices().yf(v1);
            float v1z = src.vertices().zf(v1);
            float v2x = src.vertices().xf(v2);
            float v2y = src.vertices().yf(v2);
            float v2z = src.vertices().zf(v2);
            float v10x = v1x - v0x;
            float v10y = v1y - v0y;
            float v10z = v1z - v0z;
            float v20x = v2x - v0x;
            float v20y = v2y - v0y;
            float v20z = v2z - v0z;
            float nx = v10y * v20z - v10z * v20y;
            float ny = v10z * v20x - v10x * v20z;
            float nz = v10x * v20y - v10y * v20x;
            float nmag = (float)Math.sqrt(Math.pow(nx, 2.0) + Math.pow(ny, 2.0) + Math.pow(nz, 2.0));
            triNormals.put(tri.index(), new float[]{nx / nmag, ny / nmag, nz / nmag});
        }
        HashMap<Long, float[]> vNormals = new HashMap<Long, float[]>();
        for (Triangle tri : src.triangles()) {
            float[] triNormal = (float[])triNormals.get(tri.index());
            for (long idx : new long[]{tri.vertex0(), tri.vertex1(), tri.vertex2()}) {
                float[] cumNormal = vNormals.getOrDefault(idx, new float[]{0.0f, 0.0f, 0.0f});
                cumNormal[0] = cumNormal[0] + triNormal[0];
                cumNormal[1] = cumNormal[1] + triNormal[1];
                cumNormal[2] = cumNormal[2] + triNormal[2];
                vNormals.put(idx, cumNormal);
            }
        }
        HashMap<Long, Long> vIndexMap = new HashMap<Long, Long>();
        for (Vertex v : src.vertices()) {
            long srcIndex = v.index();
            float[] vNormal = (float[])vNormals.get(v.index());
            double vNormalMag = Math.sqrt(Math.pow(vNormal[0], 2.0) + Math.pow(vNormal[1], 2.0) + Math.pow(vNormal[2], 2.0));
            long destIndex = dest.vertices().add(v.x(), v.y(), v.z(), (double)vNormal[0] / vNormalMag, (double)vNormal[1] / vNormalMag, (double)vNormal[2] / vNormalMag, v.u(), v.v());
            if (srcIndex == destIndex) continue;
            vIndexMap.put(srcIndex, destIndex);
        }
        for (Triangle tri : src.triangles()) {
            long v0src = tri.vertex0();
            long v1src = tri.vertex1();
            long v2src = tri.vertex2();
            long v0 = vIndexMap.getOrDefault(v0src, v0src);
            long v1 = vIndexMap.getOrDefault(v1src, v1src);
            long v2 = vIndexMap.getOrDefault(v2src, v2src);
            float[] triNormal = (float[])triNormals.get(tri.index());
            dest.triangles().add(v0, v1, v2, triNormal[0], triNormal[1], triNormal[2]);
        }
    }

    public static Mesh simplify(Mesh mesh, float target_percent, float agressiveness) {
        return new SimplifyMesh(mesh).simplify(target_percent, (double)agressiveness);
    }

    public static Mesh removeDuplicateVertices(Mesh mesh, int precision) {
        return RemoveDuplicateVertices.calculate(mesh, precision);
    }

    public static <T extends BooleanType<T>> Mesh marchingCubes(RandomAccessibleInterval<T> source) {
        return MarchingCubesBooleanType.calculate(source);
    }

    public static <T extends RealType<T>> Mesh marchingCubes(RandomAccessibleInterval<T> source, double isoLevel) {
        return MarchingCubesRealType.calculate(source, isoLevel);
    }
}

