/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Utils;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.util.logging.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import java.util.stream.Collectors;

public final class ConfigurationUpdatingService
implements ClientService {
    private static final Logger logger = Logger.getLogger(ConfigurationUpdatingService.class);
    private static final boolean disableServerRequests = Boolean.getBoolean("com.azul.crs.client.service.disableServerRequests");
    private static final AtomicBoolean sendJarLoads = new AtomicBoolean(true);
    private static final AtomicBoolean sendClassLoads = new AtomicBoolean(true);
    private static final AtomicBoolean sendFirstMethods = new AtomicBoolean(true);
    private static final List<Consumer<String>> listeners = new ArrayList<Consumer<String>>();

    public static boolean getSendJarLoads() {
        return sendJarLoads.get();
    }

    public static boolean getSendClassLoads() {
        return sendClassLoads.get();
    }

    public static boolean getSendFirstMethods() {
        return sendFirstMethods.get();
    }

    public static void setSendJarLoads(boolean bl) {
        sendJarLoads.set(bl);
    }

    public static void setSendClassLoads(boolean bl) {
        sendClassLoads.set(bl);
    }

    public static void setSendFirstMethods(boolean bl) {
        sendFirstMethods.set(bl);
    }

    @Override
    public synchronized void start() {
    }

    @Override
    public synchronized void stop(Utils.Deadline deadline) {
    }

    public static void addListener(Consumer<String> consumer) {
        listeners.add(consumer);
    }

    public static void updateConfiguration(String string) {
        logger.trace("updateConfiguration with '" + string + "'", new Object[0]);
        if (disableServerRequests) {
            return;
        }
        listeners.stream().forEach(consumer -> consumer.accept(string));
    }

    public static void updateConfiguration(Collection<String> collection) {
        ConfigurationUpdatingService.updateConfiguration(collection.stream().collect(Collectors.joining(",")));
    }
}

