/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.util;

import java.util.concurrent.ExecutionException;
import java.util.function.Predicate;
import net.imglib2.cache.Cache;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.LoaderCache;

public class LoaderCacheAsCacheAdapter<K, V>
implements Cache<K, V> {
    private final LoaderCache<K, V> cache;
    private final CacheLoader<K, V> loader;

    public LoaderCacheAsCacheAdapter(LoaderCache<K, V> cache, CacheLoader<K, V> loader) {
        this.cache = cache;
        this.loader = loader;
    }

    @Override
    public V getIfPresent(K key) {
        return this.cache.getIfPresent(key);
    }

    @Override
    public V get(K key) throws ExecutionException {
        return this.cache.get(key, this.loader);
    }

    @Override
    public void persist(K key) {
        this.cache.persist(key);
    }

    @Override
    public void persistIf(Predicate<K> condition) {
        this.cache.persistIf(condition);
    }

    @Override
    public void persistAll() {
        this.cache.persistAll();
    }

    @Override
    public void invalidate(K key) {
        this.cache.invalidate(key);
    }

    @Override
    public void invalidateIf(long parallelismThreshold, Predicate<K> condition) {
        this.cache.invalidateIf(parallelismThreshold, condition);
    }

    @Override
    public void invalidateAll(long parallelismThreshold) {
        this.cache.invalidateAll(parallelismThreshold);
    }
}

