/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.cache.img;

import java.nio.file.Path;
import java.util.concurrent.CompletableFuture;
import net.imglib2.Dirty;
import net.imglib2.cache.CacheLoader;
import net.imglib2.cache.img.AccessIo;
import net.imglib2.cache.img.DiskCellCache;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.type.NativeType;
import net.imglib2.util.Fraction;

public class DirtyDiskCellCache<A extends Dirty>
extends DiskCellCache<A> {
    public <T extends NativeType<T>> DirtyDiskCellCache(Path blockcache, CellGrid grid, CacheLoader<Long, Cell<A>> backingLoader, AccessIo<A> accessIo, Fraction entitiesPerPixel) {
        super(blockcache, grid, backingLoader, accessIo, entitiesPerPixel);
    }

    @Override
    public void onRemoval(Long key, A valueData) {
        if (valueData.isDirty()) {
            super.onRemoval(key, valueData);
        }
    }

    @Override
    public CompletableFuture<Void> persist(Long key, A valueData) {
        if (valueData.isDirty()) {
            CompletableFuture<Void> result = super.persist(key, valueData);
            valueData.setDirty(false);
            return result;
        }
        return CompletableFuture.completedFuture(null);
    }
}

