/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.project;

import io.scif.services.DatasetIOService;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.Arrays;
import java.util.function.Consumer;
import net.imagej.Dataset;
import net.imglib2.Interval;
import org.apache.commons.io.FilenameUtils;
import org.scijava.Context;
import sc.fiji.labkit.ui.inputimage.DatasetInputImage;
import sc.fiji.labkit.ui.labeling.Labeling;
import sc.fiji.labkit.ui.labeling.LabelingSerializer;
import sc.fiji.labkit.ui.models.DefaultHolder;
import sc.fiji.labkit.ui.models.Holder;
import sc.fiji.labkit.ui.models.ImageLabelingModel;
import sc.fiji.labkit.ui.models.MappedHolder;

public class LabeledImage {
    private final Context context;
    private String name;
    private final String imageFile;
    private final String labelingFile;
    private final String modifiedLabelingFile;
    private ImageLabelingModel imageLabelingModel;
    private final Holder<String> storedIn;
    private final Holder<Boolean> modified;
    private final Runnable onLabelingChanged = this::onLabelingChanged;
    private final Consumer<Interval> onLabelingChangedConsumer = interval -> this.onLabelingChanged();

    public LabeledImage(Context context, String imageFile) {
        this(context, FilenameUtils.getName((String)imageFile), imageFile, imageFile + ".labeling");
    }

    public LabeledImage(Context context, String name, String imageFile, String labelingFile) {
        this.context = context;
        this.name = name;
        this.imageFile = imageFile;
        this.labelingFile = labelingFile;
        this.modifiedLabelingFile = this.initModifiedLabelingFile();
        this.storedIn = new DefaultHolder<String>(labelingFile);
        this.modified = new MappedHolder<String, Boolean>(this.storedIn, value -> !labelingFile.equals(value));
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getImageFile() {
        return this.imageFile;
    }

    public String getLabelingFile() {
        return this.labelingFile;
    }

    private String initModifiedLabelingFile() {
        File file = new File(this.labelingFile);
        String name = file.getName();
        File parent = file.getParentFile();
        return new File(parent, "~" + name).getAbsolutePath();
    }

    public Holder<Boolean> modified() {
        return this.modified;
    }

    public ImageLabelingModel open() {
        this.imageLabelingModel = this.snapshot();
        this.imageLabelingModel.dataChangedNotifier().addListener(this.onLabelingChangedConsumer);
        this.imageLabelingModel.labeling().notifier().addListener(this.onLabelingChanged);
        return this.imageLabelingModel;
    }

    public void close() {
        if (this.imageLabelingModel == null) {
            return;
        }
        this.imageLabelingModel.dataChangedNotifier().removeListener(this.onLabelingChangedConsumer);
        this.imageLabelingModel.labeling().notifier().removeListener(this.onLabelingChanged);
        if (this.storedIn.get() == null) {
            try {
                new LabelingSerializer(this.context).save(this.imageLabelingModel.labeling().get(), this.modifiedLabelingFile);
                this.storedIn.set(this.modifiedLabelingFile);
                this.imageLabelingModel = null;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            this.imageLabelingModel = null;
        }
    }

    public void discardChanges() {
        if (this.modified.get().booleanValue()) {
            return;
        }
        if (this.imageLabelingModel != null) {
            this.imageLabelingModel.labeling().set(this.openOrEmptyLabeling(this.labelingFile, (Interval)this.imageLabelingModel.imageForSegmentation().get()));
        }
        try {
            Files.deleteIfExists(Paths.get(this.modifiedLabelingFile, new String[0]));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.storedIn.set(this.labelingFile);
    }

    public void save() {
        if (!this.modified.get().booleanValue()) {
            return;
        }
        if (this.imageLabelingModel == null) {
            try {
                Files.move(Paths.get(this.modifiedLabelingFile, new String[0]), Paths.get(this.labelingFile, new String[0]), StandardCopyOption.REPLACE_EXISTING);
                this.storedIn.set(this.labelingFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            try {
                new LabelingSerializer(this.context).save(this.imageLabelingModel.labeling().get(), this.labelingFile);
                Files.deleteIfExists(Paths.get(this.modifiedLabelingFile, new String[0]));
                this.storedIn.set(this.labelingFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void onLabelingChanged() {
        this.storedIn.set(null);
    }

    public ImageLabelingModel snapshot() {
        if (this.imageLabelingModel != null) {
            return this.imageLabelingModel;
        }
        DatasetInputImage inputImage = this.openInputImage();
        inputImage.setDefaultLabelingFilename(this.modifiedLabelingFile);
        Labeling labeling = this.openOrEmptyLabeling(this.storedIn.get(), (Interval)inputImage.imageForSegmentation());
        ImageLabelingModel imageLabelingModel = new ImageLabelingModel(inputImage);
        imageLabelingModel.labeling().set(labeling);
        return imageLabelingModel;
    }

    private DatasetInputImage openInputImage() {
        try {
            DatasetIOService datasetIOService = (DatasetIOService)this.context.service(DatasetIOService.class);
            Dataset dataset = datasetIOService.open(this.imageFile);
            return new DatasetInputImage(dataset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Labeling openOrEmptyLabeling(String filename, Interval interval) {
        if (new File(filename).exists()) {
            try {
                return new LabelingSerializer(this.context).open(filename);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return Labeling.createEmpty(Arrays.asList("background", "foreground"), interval);
    }

    public String toString() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LabeledImage that = (LabeledImage)o;
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.imageFile.equals(that.imageFile)) {
            return false;
        }
        return this.labelingFile.equals(that.labelingFile);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + this.imageFile.hashCode();
        result = 31 * result + this.labelingFile.hashCode();
        return result;
    }
}

