/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.inputimage;

import bdv.ViewerSetupImgLoader;
import bdv.spimdata.SpimDataMinimal;
import bdv.spimdata.XmlIoSpimDataMinimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CancellationException;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.swing.JOptionPane;
import mpicbg.spim.data.SpimDataException;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicViewSetup;
import mpicbg.spim.data.generic.sequence.ImgLoaderHint;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.FinalVoxelDimensions;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imagej.ImgPlus;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.axis.IdentityAxis;
import net.imglib2.Dimensions;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.Img;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.ImgView;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Cast;
import net.imglib2.util.Intervals;
import net.imglib2.view.Views;
import org.scijava.util.ArrayUtils;
import sc.fiji.labkit.ui.inputimage.SpimDataInputException;

public class SpimDataToImgPlus {
    public static ImgPlus<?> openWithGuiForLevelSelection(String filename) {
        return SpimDataToImgPlus.open(filename, null);
    }

    public static ImgPlus<?> open(String filename, int resolutionLevel) {
        return SpimDataToImgPlus.open(filename, (Integer)resolutionLevel);
    }

    private static ImgPlus<?> open(String filename, Integer resolutionLevel) {
        try {
            SpimDataMinimal spimData = (SpimDataMinimal)new XmlIoSpimDataMinimal().load(filename);
            return SpimDataToImgPlus.wrap(spimData, resolutionLevel);
        }
        catch (SpimDataException e) {
            throw new RuntimeException(e);
        }
    }

    public static ImgPlus<?> wrap(AbstractSpimData<?> spimData, Integer resolutionLevel) {
        SpimDataToImgPlus.checkSetupsMatch(spimData);
        Img img = ImgView.wrap((RandomAccessibleInterval)((RandomAccessibleInterval)Cast.unchecked(SpimDataToImgPlus.asRai(spimData, resolutionLevel))), (ImgFactory)((ImgFactory)Cast.unchecked((Object)new CellImgFactory())));
        String name = SpimDataToImgPlus.getName(spimData);
        CalibratedAxis[] axes = SpimDataToImgPlus.getAxes(spimData);
        return new ImgPlus(img, name, axes);
    }

    private static String getName(AbstractSpimData<?> spimData) {
        AbstractSequenceDescription sequenceDescription = spimData.getSequenceDescription();
        int setupId = ((BasicViewSetup)sequenceDescription.getViewSetupsOrdered().get(0)).getId();
        return ((BasicViewSetup)sequenceDescription.getViewSetups().get(setupId)).getName();
    }

    private static <T> RandomAccessibleInterval<?> asRai(AbstractSpimData<?> spimData, Integer level) {
        AbstractSequenceDescription sequence = spimData.getSequenceDescription();
        List viewSetupsOrdered = sequence.getViewSetupsOrdered();
        BasicViewSetup setup = (BasicViewSetup)viewSetupsOrdered.get(0);
        List<ViewerSetupImgLoader<T, ?>> imgLoaders = viewSetupsOrdered.stream().map(s -> (ViewerSetupImgLoader)sequence.getImgLoader().getSetupImgLoader(s.getId())).collect(Collectors.toList());
        List timePoints = sequence.getTimePoints().getTimePointsOrdered();
        if (level == null) {
            level = SpimDataToImgPlus.selectResolution(setup.getSize(), ((ViewerSetupImgLoader)imgLoaders.get(0)).getMipmapResolutions());
        }
        return SpimDataToImgPlus.dropThirdDimension(SpimDataToImgPlus.combineFrames(imgLoaders, timePoints, level));
    }

    private static RandomAccessibleInterval<?> dropThirdDimension(RandomAccessibleInterval<?> image) {
        return image.dimension(2) != 1L ? image : Views.hyperSlice(image, (int)2, (long)0L);
    }

    private static int selectResolution(Dimensions dimensions, double[][] resolutions) {
        if (resolutions.length <= 1) {
            return 0;
        }
        Object[] choices = Stream.of(resolutions).map(resolution -> SpimDataToImgPlus.toString(dimensions, resolution)).toArray();
        Object choice = JOptionPane.showInputDialog(null, "Select Resolution for Segmentation", "Labkit: open Image", -1, null, choices, choices[0]);
        if (choice == null) {
            throw new CancellationException();
        }
        return ArrayUtils.indexOf((Object[])choices, (Object)choice);
    }

    private static String toString(Dimensions dimensions, double[] resolution) {
        long[] fullsize = Intervals.dimensionsAsLongArray((Dimensions)dimensions);
        long[] resolutionSize = IntStream.range(0, fullsize.length).mapToLong(i -> (long)((double)fullsize[i] / resolution[i])).toArray();
        return Arrays.toString(resolutionSize);
    }

    private static <T> RandomAccessibleInterval<T> combineFrames(List<ViewerSetupImgLoader<T, ?>> imgLoaders, List<TimePoint> timePoints, int level) {
        List frames = timePoints.stream().map(t -> SpimDataToImgPlus.combineChannels(imgLoaders, t, level)).collect(Collectors.toList());
        return frames.size() > 1 ? Views.stack(frames) : (RandomAccessibleInterval)frames.get(0);
    }

    private static <T> RandomAccessibleInterval<T> combineChannels(List<ViewerSetupImgLoader<T, ?>> imgLoaders, TimePoint timePoint, int level) {
        List channels = imgLoaders.stream().map(imgLoader -> imgLoader.getImage(timePoint.getId(), level, new ImgLoaderHint[0])).collect(Collectors.toList());
        return channels.size() > 1 ? Views.stack(channels) : (RandomAccessibleInterval)channels.get(0);
    }

    private static CalibratedAxis[] getAxes(AbstractSpimData<?> spimData) {
        VoxelDimensions voxelSize = SpimDataToImgPlus.getVoxelDimensions(spimData);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(new DefaultLinearAxis(Axes.X, voxelSize.unit(), voxelSize.dimension(0)));
        list.add(new DefaultLinearAxis(Axes.Y, voxelSize.unit(), voxelSize.dimension(1)));
        if (SpimDataToImgPlus.is3d(spimData)) {
            list.add(new DefaultLinearAxis(Axes.Z, voxelSize.unit(), voxelSize.dimension(2)));
        }
        if (SpimDataToImgPlus.isMultiChannel(spimData)) {
            list.add(new IdentityAxis(Axes.CHANNEL));
        }
        if (SpimDataToImgPlus.isTimeSeries(spimData)) {
            list.add(new DefaultLinearAxis(Axes.TIME));
        }
        return list.toArray(new CalibratedAxis[0]);
    }

    private static boolean is3d(AbstractSpimData<?> spimData) {
        return ((BasicViewSetup)spimData.getSequenceDescription().getViewSetupsOrdered().get(0)).getSize().dimension(2) > 1L;
    }

    private static boolean isTimeSeries(AbstractSpimData<?> spimData) {
        TimePoints timePoints = spimData.getSequenceDescription().getTimePoints();
        return timePoints.size() > 1;
    }

    private static boolean isMultiChannel(AbstractSpimData<?> spimData) {
        Map setups = spimData.getSequenceDescription().getViewSetups();
        return setups.size() > 1;
    }

    private static VoxelDimensions getVoxelDimensions(AbstractSpimData<?> spimData) {
        BasicViewSetup setup = (BasicViewSetup)spimData.getSequenceDescription().getViewSetupsOrdered().get(0);
        if (setup.hasVoxelSize()) {
            return setup.getVoxelSize();
        }
        return new FinalVoxelDimensions("pixel", new double[]{1.0, 1.0, 1.0});
    }

    private static void checkSetupsMatch(AbstractSpimData<?> spimData) {
        List setups = spimData.getSequenceDescription().getViewSetupsOrdered();
        if (setups.size() == 1) {
            return;
        }
        List setupSizes = setups.stream().map(BasicViewSetup::getSize).collect(Collectors.toList());
        boolean sameSizes = SpimDataToImgPlus.allEqual(setupSizes);
        boolean sameRegistrations = SpimDataToImgPlus.viewRegistrationsMatch(spimData);
        if (!sameSizes || !sameRegistrations) {
            throw new SpimDataInputException("The image can not be processed because it contains multiple views / angles.\nLabkit only supports Big Data Viewer XML + HDF5 files with a single view / angle / setup.\nYou may use BigStitcher to merge the multiple views into one image before opening it with Labkit.");
        }
    }

    private static boolean viewRegistrationsMatch(AbstractSpimData<?> spimData) {
        List<AffineTransform3D> transformations = SpimDataToImgPlus.getFirstTimePointViewRegistrations(spimData);
        return SpimDataToImgPlus.allEqual(transformations, SpimDataToImgPlus::transformationEquals);
    }

    private static List<AffineTransform3D> getFirstTimePointViewRegistrations(AbstractSpimData<?> spimData) {
        AbstractSequenceDescription sequenceDescription = spimData.getSequenceDescription();
        int firstTimePoint = ((TimePoint)sequenceDescription.getTimePoints().getTimePointsOrdered().get(0)).getId();
        ViewRegistrations viewRegistrations = spimData.getViewRegistrations();
        ArrayList<AffineTransform3D> transformations = new ArrayList<AffineTransform3D>();
        for (BasicViewSetup setup : sequenceDescription.getViewSetupsOrdered()) {
            AffineTransform3D transform = viewRegistrations.getViewRegistration(firstTimePoint, setup.getId()).getModel();
            transformations.add(transform);
        }
        return transformations;
    }

    private static <T> boolean allEqual(List<T> values) {
        return SpimDataToImgPlus.allEqual(values, Objects::equals);
    }

    private static <T> boolean allEqual(List<T> values, BiPredicate<T, T> equals) {
        if (values.isEmpty()) {
            return true;
        }
        T first = values.get(0);
        for (int i = 1; i < values.size(); ++i) {
            T value = values.get(i);
            if (equals.test(first, value)) continue;
            return false;
        }
        return true;
    }

    static boolean transformationEquals(AffineTransform3D a, AffineTransform3D b) {
        double max_abs_value = 0.0;
        double max_difference = 0.0;
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 4; ++col) {
                double va = a.get(row, col);
                double vb = b.get(row, col);
                max_abs_value = Math.max(max_abs_value, Math.abs(va));
                max_abs_value = Math.max(max_abs_value, Math.abs(vb));
                max_difference = Math.max(max_difference, Math.abs(va - vb));
            }
        }
        return max_difference == 0.0 || max_difference < max_abs_value * 1.0E-6;
    }
}

