/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.brush;

import bdv.util.BdvHandle;
import bdv.viewer.ViewerPanel;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.roi.labeling.LabelingType;
import net.imglib2.view.Views;
import org.scijava.ui.behaviour.ClickBehaviour;
import sc.fiji.labkit.ui.ActionsAndBehaviours;
import sc.fiji.labkit.ui.brush.BdvMouseBehaviourUtils;
import sc.fiji.labkit.ui.labeling.Label;
import sc.fiji.labkit.ui.models.ImageLabelingModel;

public class SelectLabelController {
    private static final double[] PIXEL_CENTER_OFFSET = new double[]{0.5, 0.5, 0.5};
    private final ClickBehaviour behaviour = this::click;
    private final BdvHandle bdv;
    private final ViewerPanel viewer;
    private final ImageLabelingModel model;

    public SelectLabelController(BdvHandle bdv, ImageLabelingModel model, ActionsAndBehaviours actionsAndBehaviours) {
        this.bdv = bdv;
        this.viewer = bdv.getViewerPanel();
        this.model = model;
        actionsAndBehaviours.addBehaviour(this.behaviour, "select_label", "shift button1");
    }

    public void setActive(boolean active) {
        BdvMouseBehaviourUtils.setMouseBehaviourActive(this.bdv, this.behaviour, active);
    }

    private void click(int x, int y) {
        RealPoint globalPosition = new RealPoint(3);
        this.viewer.displayToGlobalCoordinates((double)x, (double)y, (RealPositionable)globalPosition);
        this.model.labelTransformation().applyInverse((RealPositionable)globalPosition, (RealLocalizable)globalPosition);
        globalPosition.move(PIXEL_CENTER_OFFSET);
        RandomAccess ra = this.labeling().randomAccess();
        ra.setPosition((Localizable)this.roundAndReduceDimension((RealLocalizable)globalPosition, ra.numDimensions()));
        Optional<Label> label = this.nextLabel((LabelingType<Label>)((LabelingType)ra.get()), this.model.selectedLabel().get());
        label.ifPresent(this.model.selectedLabel()::set);
    }

    private Optional<Label> nextLabel(LabelingType<Label> labels, Label label) {
        List visibleLabels = labels.stream().filter(Label::isVisible).collect(Collectors.toList());
        visibleLabels.sort(Comparator.comparing(this.model.labeling().get().getLabels()::indexOf));
        if (visibleLabels.contains(label)) {
            int index = visibleLabels.indexOf(label);
            return Optional.of(visibleLabels.get((index + 1) % visibleLabels.size()));
        }
        return visibleLabels.stream().findFirst();
    }

    private RandomAccessibleInterval<LabelingType<Label>> labeling() {
        RandomAccessibleInterval label = this.model.labeling().get();
        if (this.model.isTimeSeries()) {
            return Views.hyperSlice((RandomAccessibleInterval)label, (int)(label.numDimensions() - 1), (long)this.viewer.state().getCurrentTimepoint());
        }
        return label;
    }

    private Point roundAndReduceDimension(RealLocalizable realLocalizable, int numDimesions) {
        Point point = new Point(numDimesions);
        for (int i = 0; i < point.numDimensions(); ++i) {
            point.setPosition((long)realLocalizable.getDoublePosition(i), i);
        }
        return point;
    }
}

