/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui.actions;

import io.scif.FormatException;
import io.scif.img.ImgIOException;
import io.scif.img.ImgSaver;
import java.util.function.Function;
import javax.swing.JOptionPane;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.img.ImgView;
import net.imglib2.img.display.imagej.ImageJFunctions;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;
import sc.fiji.labkit.ui.Extensible;
import sc.fiji.labkit.ui.actions.AbstractFileIoAction;
import sc.fiji.labkit.ui.models.ImageLabelingModel;
import sc.fiji.labkit.ui.models.SegmentationItem;
import sc.fiji.labkit.ui.models.SegmentationResultsModel;
import sc.fiji.labkit.ui.utils.HDF5Saver;
import sc.fiji.labkit.ui.utils.ParallelUtils;
import sc.fiji.labkit.ui.utils.progress.SwingProgressWriter;

public class SegmentationExportAction
extends AbstractFileIoAction {
    private final ImageLabelingModel labelingModel;

    public SegmentationExportAction(Extensible extensible, ImageLabelingModel labelingModel) {
        super(extensible, AbstractFileIoAction.TIFF_FILTER, AbstractFileIoAction.HDF5_FILTER);
        this.labelingModel = labelingModel;
        this.addMenuItems("Segmentation Result", SegmentationResultsModel::segmentation, segmenter -> (double)segmenter.classNames().size() - 1.0);
        this.addMenuItems("Probability Map", SegmentationResultsModel::prediction, ignore -> 1.0);
    }

    private <T extends NumericType<T> & NativeType<T>> void addMenuItems(String title, Function<SegmentationResultsModel, RandomAccessibleInterval<T>> getResultsImage, Function<SegmentationItem, Double> maxResultIntensity) {
        this.initSaveAction(SegmentationItem.SEGMENTER_MENU, "Save " + title + " as TIF / HDF5 ...", 200.0f, (item, filename) -> this.saveImage(filename, (RandomAccessibleInterval)getResultsImage.apply(item.results(this.labelingModel))), "");
        this.extensible.addMenuItem(SegmentationItem.SEGMENTER_MENU, "Show " + title + " in ImageJ", 201.0f, item -> this.onShowResultInImageJClicked((SegmentationItem)item, getResultsImage, maxResultIntensity), null, "");
        this.extensible.addMenuItem(SegmentationItem.SEGMENTER_MENU, "Calculate entire " + title, 300.0f, item -> this.onCalculateEntireResultClicked(getResultsImage, (SegmentationItem)item), null, "");
    }

    private <T extends NumericType<T> & NativeType<T>> void onShowResultInImageJClicked(SegmentationItem item, Function<SegmentationResultsModel, RandomAccessibleInterval<T>> getResultsImage, Function<SegmentationItem, Double> maxResultIntensity) {
        SegmentationResultsModel results = item.results(this.labelingModel);
        RandomAccessibleInterval result = getResultsImage.apply(results);
        double max = maxResultIntensity.apply(item);
        ParallelUtils.runInOtherThread(() -> this.populate(result));
        ParallelUtils.runInOtherThread(() -> ImageJFunctions.show((RandomAccessibleInterval)result).setDisplayRange(0.0, max));
    }

    private <T extends NumericType<T> & NativeType<T>> void onCalculateEntireResultClicked(Function<SegmentationResultsModel, RandomAccessibleInterval<T>> getResultsImage, SegmentationItem item) {
        RandomAccessibleInterval resultsImage = getResultsImage.apply(item.results(this.labelingModel));
        ParallelUtils.runInOtherThread(() -> this.populate(resultsImage));
    }

    private <T extends NumericType<T> & NativeType<T>> void populate(RandomAccessibleInterval<T> result) {
        SwingProgressWriter progress = new SwingProgressWriter(null, "Segment Entire Image Volume");
        ParallelUtils.populateCachedImg(result, progress);
    }

    private <T extends Type<T>> void saveImage(String filename, RandomAccessibleInterval<T> image) {
        if (filename.endsWith(".h5") || filename.endsWith(".xml")) {
            HDF5Saver saver = new HDF5Saver(image, filename);
            saver.setProgressWriter(new SwingProgressWriter(this.extensible.dialogParent(), "Save Image"));
            saver.writeAll();
        } else {
            try {
                ImgSaver saver = new ImgSaver(this.extensible.context());
                saver.saveImg(filename, ImgView.wrap(image, null));
            }
            catch (ImgIOException e) {
                if (e.getCause() instanceof FormatException) {
                    JOptionPane.showMessageDialog(null, "File format not supported:\n" + filename);
                }
                throw e;
            }
        }
    }
}

