/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.labkit.ui;

import bdv.util.BdvHandle;
import javax.swing.KeyStroke;
import org.scijava.ui.behaviour.Behaviour;
import org.scijava.ui.behaviour.io.InputTriggerConfig;
import org.scijava.ui.behaviour.util.AbstractNamedAction;
import org.scijava.ui.behaviour.util.Actions;
import org.scijava.ui.behaviour.util.Behaviours;

public class ActionsAndBehaviours {
    private final InputTriggerConfig config = new InputTriggerConfig();
    private final Actions actions = new Actions(this.config, new String[0]);
    private final Behaviours behaviors = new Behaviours(this.config, new String[0]);
    private final BdvHandle bdvHandle;

    public ActionsAndBehaviours(BdvHandle bdvHandle) {
        this.bdvHandle = bdvHandle;
    }

    public void addAction(AbstractNamedAction action) {
        KeyStroke keyStroke = (KeyStroke)action.getValue("AcceleratorKey");
        this.actions.namedAction(action, keyStroke != null ? keyStroke.toString() : "not mapped");
        this.actions.install(this.bdvHandle.getKeybindings(), "simplified-actions-and-behaviours");
    }

    public void addBehaviour(Behaviour behaviour, String name, String ... defaultTriggers) {
        this.behaviors.behaviour(behaviour, name, defaultTriggers);
        this.behaviors.install(this.bdvHandle.getTriggerbindings(), "simplified-actions-and-behaviours");
    }
}

