/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.coloc.algorithms;

import java.util.EnumSet;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.TwinCursor;
import net.imglib2.type.logic.BitType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.view.Views;
import sc.fiji.coloc.algorithms.Histogram2D;
import sc.fiji.coloc.algorithms.MissingPreconditionException;
import sc.fiji.coloc.gadgets.DataContainer;

public class LiHistogram2D<T extends RealType<T>>
extends Histogram2D<T> {
    double ch1Mean;
    double ch2Mean;
    double ch1Min;
    double ch1Max;
    double ch2Min;
    double ch2Max;
    double liMin;
    double liMax;
    double liDiff;
    double ch1Scaling;
    double ch2Scaling;
    boolean useCh1 = true;

    public LiHistogram2D(boolean useCh1) {
        this("Histogram 2D (Li)", useCh1);
    }

    public LiHistogram2D(String title, boolean useCh1) {
        this(title, false, useCh1);
    }

    public LiHistogram2D(String title, boolean swapChannels, boolean useCh1) {
        this(title, swapChannels, useCh1, EnumSet.of(Histogram2D.DrawingFlags.Plot));
    }

    public LiHistogram2D(String title, boolean swapChannels, boolean useCh1, EnumSet<Histogram2D.DrawingFlags> drawingSettings) {
        super(title, swapChannels, drawingSettings);
        this.useCh1 = useCh1;
    }

    @Override
    public void execute(DataContainer<T> container) throws MissingPreconditionException {
        this.ch1Mean = this.swapChannels ? container.getMeanCh2() : container.getMeanCh1();
        this.ch2Mean = this.swapChannels ? container.getMeanCh1() : container.getMeanCh2();
        this.ch1Min = this.getMinCh1(container);
        this.ch1Max = this.getMaxCh1(container);
        this.ch2Min = this.getMinCh2(container);
        this.ch2Max = this.getMaxCh2(container);
        RandomAccessibleInterval<T> img1 = this.getImageCh1(container);
        RandomAccessibleInterval<T> img2 = this.getImageCh2(container);
        RandomAccessibleInterval<BitType> mask = container.getMask();
        TwinCursor cursor = new TwinCursor(img1.randomAccess(), img2.randomAccess(), (Cursor<BitType>)Views.iterable(mask).localizingCursor());
        this.liMin = Double.MAX_VALUE;
        this.liMax = Double.MIN_VALUE;
        while (cursor.hasNext()) {
            cursor.fwd();
            double ch1 = ((RealType)cursor.getFirst()).getRealDouble();
            double ch2 = ((RealType)cursor.getSecond()).getRealDouble();
            double productOfDifferenceOfMeans = (this.ch1Mean - ch1) * (this.ch2Mean - ch2);
            if (productOfDifferenceOfMeans < this.liMin) {
                this.liMin = productOfDifferenceOfMeans;
            }
            if (!(productOfDifferenceOfMeans > this.liMax)) continue;
            this.liMax = productOfDifferenceOfMeans;
        }
        this.liDiff = Math.abs(this.liMax - this.liMin);
        this.generateHistogramData(container);
    }

    @Override
    protected double getXBinWidth(DataContainer<T> container) {
        return (double)this.xBins / (this.liDiff + 1.0);
    }

    @Override
    protected double getYBinWidth(DataContainer<T> container) {
        double max = this.useCh1 ? this.getMaxCh1(container) : this.getMaxCh2(container);
        return (double)this.yBins / (max + 1.0);
    }

    @Override
    protected int getXValue(double ch1Val, double ch1BinWidth, double ch2Val, double ch2BinWidth) {
        return (int)(((this.ch1Mean - ch1Val) * (this.ch2Mean - ch2Val) - this.liMin) * ch1BinWidth);
    }

    @Override
    protected int getYValue(double ch1Val, double ch1BinWidth, double ch2Val, double ch2BinWidth) {
        if (this.useCh1) {
            return this.yBins - 1 - (int)(ch1Val * ch2BinWidth);
        }
        return this.yBins - 1 - (int)(ch2Val * ch2BinWidth);
    }

    @Override
    protected double getXMin(DataContainer<T> container) {
        return this.swapChannels ? (this.useCh1 ? container.getMinCh1() : container.getMinCh2()) : this.liMin;
    }

    @Override
    protected double getXMax(DataContainer<T> container) {
        return this.swapChannels ? (this.useCh1 ? container.getMaxCh1() : container.getMaxCh2()) : this.liMax;
    }

    @Override
    protected double getYMin(DataContainer<T> container) {
        return this.swapChannels ? this.liMin : (this.useCh1 ? container.getMinCh1() : container.getMinCh2());
    }

    @Override
    protected double getYMax(DataContainer<T> container) {
        return this.swapChannels ? this.liMax : (this.useCh1 ? container.getMaxCh1() : container.getMaxCh2());
    }
}

