/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.multiKymograph;

import ij.IJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.NewImage;
import ij.plugin.PlugIn;
import ij.process.ImageProcessor;

public class StackDifference_
implements PlugIn {
    double[] profile;

    public void run(String arg) {
        ImagePlus imp = WindowManager.getCurrentImage();
        if (imp == null) {
            IJ.noImage();
            return;
        }
        int numStacks = imp.getStackSize();
        if (numStacks == 1) {
            IJ.error((String)"Must call this plugin on image stack.");
            return;
        }
        int bd = imp.getBitDepth();
        if (bd != 8 || numStacks == 1) {
            IJ.error((String)"Sorry! This Plugin only works on 8-Bit Image Stacks");
            return;
        }
        String sPrompt = "Gap between frames ";
        int numDiff = (int)IJ.getNumber((String)sPrompt, (double)1.0);
        if (numDiff == Integer.MIN_VALUE) {
            return;
        }
        if (numDiff >= numStacks) {
            IJ.error((String)"Sorry, this makes no sense");
            return;
        }
        if (!imp.lock()) {
            return;
        }
        ImageProcessor ip = imp.getProcessor();
        int w = ip.getWidth();
        int h = ip.getHeight();
        ImagePlus overlay = NewImage.createByteImage((String)"Difference Image", (int)w, (int)h, (int)(numStacks - numDiff), (int)1);
        ImageProcessor over_ip = overlay.getProcessor();
        for (int i = 1; i <= numStacks - numDiff; ++i) {
            imp.setSlice(i);
            imp.getProcessor();
            overlay.setSlice(i);
            over_ip.copyBits(ip, 0, 0, 0);
            imp.setSlice(i + numDiff);
            over_ip = overlay.getProcessor();
            overlay.setSlice(i);
            over_ip.copyBits(ip, 0, 0, 8);
        }
        overlay.show();
        imp.unlock();
    }
}

