/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.timelapse;

import ij.IJ;
import ij.gui.PolygonRoi;
import ij.gui.Roi;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class PolygonRoiPublic
extends PolygonRoi {
    protected boolean specifiedByUser = false;
    protected Color normalStrokeColor;
    protected Color specifiedStrokeColor;
    protected static Field nPointsField;
    protected static Field xField;
    protected static Field yField;
    protected static Field xpField;
    protected static Field ypField;
    protected static Field xpfField;
    protected static Field ypfField;
    protected static Method resetBoundsMethod;

    public PolygonRoiPublic(int[] x, int[] y, int n, int type) {
        super(x, y, n, type);
        this.fitSpline();
        this.normalStrokeColor = this.strokeColor;
        this.specifiedStrokeColor = new Color(0, 0, 255, 77);
    }

    public PolygonRoiPublic(PolygonRoi roi) {
        this(PolygonRoiPublic.getXCoordinates(roi), PolygonRoiPublic.getYCoordinates(roi), PolygonRoiPublic.getNCoordinates(roi), roi.getType());
    }

    protected static int[] getXCoordinates(PolygonRoi roi) {
        try {
            Rectangle bounds = roi.getBounds();
            int[] xp = (int[])xpField.get(roi);
            int[] result = new int[xp.length];
            for (int i = 0; i < xp.length; ++i) {
                result[i] = xp[i] + bounds.x;
            }
            return result;
        }
        catch (Exception e) {
            IJ.handleException((Throwable)e);
            return null;
        }
    }

    protected static int[] getYCoordinates(PolygonRoi roi) {
        try {
            Rectangle bounds = roi.getBounds();
            int[] yp = (int[])ypField.get(roi);
            int[] result = new int[yp.length];
            for (int i = 0; i < yp.length; ++i) {
                result[i] = yp[i] + bounds.y;
            }
            return result;
        }
        catch (Exception e) {
            IJ.handleException((Throwable)e);
            return null;
        }
    }

    protected static int getNCoordinates(PolygonRoi roi) {
        if (nPointsField == null) {
            return -1;
        }
        try {
            return (Integer)nPointsField.get(roi);
        }
        catch (Exception e) {
            IJ.handleException((Throwable)e);
            return -1;
        }
    }

    public void updatePolygon() {
        this.resetBoundingRect();
        this.fitSpline();
        super.updatePolygon();
    }

    public void fitSpline() {
        if (this.getNCoordinates() > 2) {
            this.copyXpToXpf();
            super.fitSpline();
            this.copyXpfToXp();
        }
    }

    public void draw(Graphics g) {
        this.strokeColor = this.specifiedByUser ? this.specifiedStrokeColor : this.normalStrokeColor;
        super.draw(g);
    }

    public void resetBoundingRect() {
        if (resetBoundsMethod == null) {
            return;
        }
        try {
            resetBoundsMethod.invoke((Object)this, new Object[0]);
        }
        catch (Exception e) {
            IJ.handleException((Throwable)e);
        }
    }

    protected void copyXpToXpf() {
        if (xpfField != null) {
            try {
                xpfField.set((Object)this, PolygonRoiPublic.toFloat(this.xp));
            }
            catch (IllegalAccessException e) {
                IJ.handleException((Throwable)e);
            }
        }
        if (ypfField != null) {
            try {
                ypfField.set((Object)this, PolygonRoiPublic.toFloat(this.yp));
            }
            catch (IllegalAccessException e) {
                IJ.handleException((Throwable)e);
            }
        }
    }

    public static float[] toFloat(int[] array) {
        float[] result = new float[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    protected void copyXpfToXp() {
        if (xpfField != null) {
            try {
                this.xp = PolygonRoiPublic.toIntR((float[])xpfField.get((Object)this));
            }
            catch (IllegalAccessException e) {
                IJ.handleException((Throwable)e);
            }
        }
        if (ypfField != null) {
            try {
                this.yp = PolygonRoiPublic.toIntR((float[])ypfField.get((Object)this));
            }
            catch (IllegalAccessException e) {
                IJ.handleException((Throwable)e);
            }
        }
    }

    public static int[] toIntR(float[] array) {
        int[] result = new int[array.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = (int)Math.floor((double)array[i] + 0.5);
        }
        return result;
    }

    public boolean lineContains(int x, int y) {
        return this.lineContains(x, y, 5);
    }

    public boolean lineContains(int x, int y, int tolerance) {
        Rectangle bounds = this.getBounds();
        int n = this.getNCoordinates();
        int[] xp = this.getXCoordinates();
        int[] yp = this.getYCoordinates();
        for (int i = 1; i < n; ++i) {
            double factor;
            double distance;
            int x2 = bounds.x + xp[i];
            int x1 = bounds.x + xp[i - 1];
            double deltaX = x2 - x1;
            int y2 = bounds.y + yp[i];
            int y1 = bounds.y + yp[i - 1];
            double deltaY = y2 - y1;
            double length = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
            if ((double)tolerance * length <= (distance = Math.abs((double)(x - x1) * deltaY - (double)(y - y1) * deltaX)) || !((factor = (double)(x - x1) * deltaX + (double)(y - y1) * deltaY) > 0.0) || !(factor < length * length)) continue;
            return true;
        }
        return false;
    }

    public void moveHandle(int handle, int x, int y) {
        if (handle < 0 || handle >= this.nPoints) {
            return;
        }
        Rectangle bounds = this.getBounds();
        this.xp[handle] = x - bounds.x;
        this.yp[handle] = y - bounds.y;
        this.copyXpToXpf();
        this.updatePolygon();
    }

    public int addHandle(int x, int y) {
        if (this.nPoints == 2 && this.xp[0] == this.xp[1] && this.yp[0] == this.yp[1]) {
            this.moveHandle(1, x, y);
            return 1;
        }
        return this.insertHandle(this.nPoints, x, y);
    }

    public int insertHandle(int beforeHandle, int x, int y) {
        if (this.xp.length < this.nPoints + 1) {
            int[] newX = new int[this.nPoints + 16];
            System.arraycopy(this.xp, 0, newX, 0, this.nPoints);
            this.xp = newX;
            this.xp2 = new int[this.nPoints + 16];
        }
        if (this.yp.length < this.nPoints + 1) {
            int[] newY = new int[this.nPoints + 16];
            System.arraycopy(this.yp, 0, newY, 0, this.nPoints);
            this.yp = newY;
            this.yp2 = new int[this.nPoints + 16];
        }
        if (beforeHandle < this.nPoints) {
            System.arraycopy(this.xp, beforeHandle, this.xp, beforeHandle + 1, this.nPoints - beforeHandle);
            System.arraycopy(this.yp, beforeHandle, this.yp, beforeHandle + 1, this.nPoints - beforeHandle);
        }
        ++this.nPoints;
        if (this.maxPoints < this.nPoints) {
            this.maxPoints = this.xp.length;
        }
        this.moveHandle(beforeHandle, x, y);
        return beforeHandle;
    }

    public int insertHandle(int x, int y) {
        if (this.nPoints < 2) {
            return this.addHandle(x, y);
        }
        Rectangle bounds = this.getBounds();
        int x2 = x - bounds.x;
        int y2 = y - bounds.y;
        int bestHandle = -1;
        int bestDist2 = Integer.MAX_VALUE;
        for (int i = 0; i < this.nPoints; ++i) {
            int dist2 = (x2 - this.xp[i]) * (x2 - this.xp[i]) + (y2 - this.yp[i]) * (y2 - this.yp[i]);
            if (bestDist2 <= dist2) continue;
            bestHandle = i;
            bestDist2 = dist2;
        }
        int beforeHandle = bestHandle == 0 ? ((x2 - this.xp[0]) * (this.xp[1] - this.xp[0]) + (y2 - this.yp[0]) * (this.yp[1] - this.yp[0]) > 0 ? 1 : 0) : (bestHandle == this.nPoints - 1 ? ((x2 - this.xp[this.nPoints - 1]) * (this.xp[this.nPoints - 2] - this.xp[this.nPoints - 1]) + (y2 - this.yp[this.nPoints - 1]) * (this.yp[this.nPoints - 2] - this.yp[this.nPoints - 1]) > 0 ? this.nPoints - 1 : this.nPoints) : ((x2 - this.xp[bestHandle - 1]) * (x2 - this.xp[bestHandle - 1]) + (y2 - this.yp[bestHandle - 1]) * (y2 - this.yp[bestHandle - 1]) < (x2 - this.xp[bestHandle + 1]) * (x2 - this.xp[bestHandle + 1]) + (y2 - this.yp[bestHandle + 1]) * (y2 - this.yp[bestHandle + 1]) ? bestHandle : bestHandle + 1));
        return this.insertHandle(beforeHandle, x, y);
    }

    public void deleteHandle(int handle) {
        if (handle < 0 || handle >= this.nPoints) {
            return;
        }
        if (handle + 1 < this.nPoints) {
            System.arraycopy(this.xp, handle + 1, this.xp, handle, this.nPoints - handle - 1);
            System.arraycopy(this.yp, handle + 1, this.yp, handle, this.nPoints - handle - 1);
        }
        --this.nPoints;
        this.copyXpToXpf();
        this.updatePolygon();
    }

    public void move(int deltaX, int deltaY) {
        Rectangle bounds = this.getBounds();
        this.setLocation(bounds.x + deltaX, bounds.y + deltaY);
    }

    public double distanceToHandle(int handle, int x, int y) {
        Rectangle bounds = this.getBounds();
        return Math.sqrt((x -= this.xp[handle] + bounds.x) * x + (y -= this.yp[handle] + bounds.y) * y);
    }

    public String toString() {
        Rectangle bounds = this.getBounds();
        StringBuilder builder = new StringBuilder();
        builder.append("PolygonRoi(").append(this.specifiedByUser ? "set by user" : "interpolated").append("; ").append(this.nPoints);
        for (int i = 0; i < this.nPoints; ++i) {
            builder.append(" ").append(this.xp[i] + bounds.x).append(",").append(this.yp[i] + bounds.y);
        }
        builder.append(")");
        return builder.toString();
    }

    public static void main(String[] args) {
        PolygonRoiPublic roi = new PolygonRoiPublic(new int[]{800, 800}, new int[]{500, 500}, 2, 6);
        roi.addHandle(100, 200);
        roi.addHandle(100, 500);
        roi.addHandle(800, 250);
        IJ.getImage().setRoi((Roi)roi);
        PolygonRoi poly = new PolygonRoi(PolygonRoiPublic.getXCoordinates(roi), PolygonRoiPublic.getYCoordinates(roi), PolygonRoiPublic.getNCoordinates(roi), 6);
        poly.fitSpline();
    }

    public static void assertEquals(String name1, Object object1, String name2, Object object2) {
        PolygonRoiPublic.assertEquals(name1, object1, name2, object2, 4);
    }

    public static void assertEquals(String name1, Object object1, String name2, Object object2, int maxDepth) {
        if (maxDepth == 0) {
            return;
        }
        if (object1 == null || object2 == null) {
            if (object1 != object2) {
                System.err.println(name1 + "(" + object1 + ") != " + name2 + "(" + object2 + ")");
            }
            return;
        }
        Class<Object> class1 = object1.getClass();
        Class<?> class2 = object2.getClass();
        if (class1 == PolygonRoiPublic.class) {
            class1 = PolygonRoi.class;
        }
        if (class1 != class2) {
            System.err.println("Different class: " + name1 + "(" + class1.getName() + ") != " + name2 + "(" + class2.getName() + ")");
        } else if (class1 == Boolean.class) {
            PolygonRoiPublic.assertEquals(name1, (Boolean)object1, name2, (Boolean)object2);
        } else if (class1 == Byte.class) {
            PolygonRoiPublic.assertEquals(name1, (Byte)object1, name2, (Byte)object2);
        } else if (class1 == Short.class) {
            PolygonRoiPublic.assertEquals(name1, (Short)object1, name2, (Short)object2);
        } else if (class1 == Integer.class) {
            PolygonRoiPublic.assertEquals(name1, (Integer)object1, name2, (Integer)object2);
        } else if (class1 == Long.class) {
            PolygonRoiPublic.assertEquals(name1, (Long)object1, name2, (Long)object2);
        } else if (class1 == Float.class) {
            PolygonRoiPublic.assertEquals(name1, ((Float)object1).floatValue(), name2, ((Float)object2).floatValue());
        } else if (class1 == Double.class) {
            PolygonRoiPublic.assertEquals(name1, (Double)object1, name2, (Double)object2);
        } else if (class1 == String.class) {
            PolygonRoiPublic.assertEquals(name1, (String)object1, name2, (String)object2);
        } else {
            for (Field field : class1.getDeclaredFields()) {
                try {
                    if (field.getDeclaringClass() != class1) continue;
                    field.setAccessible(true);
                    PolygonRoiPublic.assertEquals(name1 + "." + field.getName(), field.get(object1), name2 + "." + field.getName(), field.get(object2), maxDepth - 1);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    public static void assertEquals(String name1, boolean value1, String name2, boolean value2) {
        if (value1 != value2) {
            System.err.println(name1 + "(" + value1 + ") != " + name2 + "(" + value2 + ")");
        }
    }

    public static void assertEquals(String name1, byte value1, String name2, byte value2) {
        if (value1 != value2) {
            System.err.println(name1 + "(" + value1 + ") != " + name2 + "(" + value2 + ")");
        }
    }

    public static void assertEquals(String name1, short value1, String name2, short value2) {
        if (value1 != value2) {
            System.err.println(name1 + "(" + value1 + ") != " + name2 + "(" + value2 + ")");
        }
    }

    public static void assertEquals(String name1, int value1, String name2, int value2) {
        if (value1 != value2) {
            System.err.println(name1 + "(" + value1 + ") != " + name2 + "(" + value2 + ")");
        }
    }

    public static void assertEquals(String name1, long value1, String name2, long value2) {
        if (value1 != value2) {
            System.err.println(name1 + "(" + value1 + ") != " + name2 + "(" + value2 + ")");
        }
    }

    public static void assertEquals(String name1, float value1, String name2, float value2) {
        if (value1 != value2) {
            System.err.println(name1 + "(" + value1 + ") != " + name2 + "(" + value2 + ")");
        }
    }

    public static void assertEquals(String name1, double value1, String name2, double value2) {
        if (value1 != value2) {
            System.err.println(name1 + "(" + value1 + ") != " + name2 + "(" + value2 + ")");
        }
    }

    public static void assertEquals(String name1, String value1, String name2, String value2) {
        if (value1 == null && value2 != null || value1 != null && !value1.equals(value2)) {
            System.err.println(name1 + "(" + value1 + ") != " + name2 + "(" + value2 + ")");
        }
    }

    static {
        try {
            xpField = PolygonRoi.class.getDeclaredField("xp");
            xpField.setAccessible(true);
        }
        catch (Exception e) {
            IJ.handleException((Throwable)e);
        }
        try {
            ypField = PolygonRoi.class.getDeclaredField("yp");
            ypField.setAccessible(true);
        }
        catch (Exception e) {
            IJ.handleException((Throwable)e);
        }
        try {
            nPointsField = PolygonRoi.class.getDeclaredField("nPoints");
            nPointsField.setAccessible(true);
        }
        catch (Exception e) {
            IJ.handleException((Throwable)e);
        }
        try {
            xpfField = PolygonRoi.class.getDeclaredField("xpf");
            xpfField.setAccessible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ypfField = PolygonRoi.class.getDeclaredField("ypf");
            ypfField.setAccessible(true);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            resetBoundsMethod = PolygonRoi.class.getDeclaredMethod("resetBoundingRect", new Class[0]);
            resetBoundsMethod.setAccessible(true);
        }
        catch (Exception e) {
            IJ.handleException((Throwable)e);
        }
    }
}

