/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.panorama;

import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.util.Matrix3x3;

public abstract class PanoramaCamera<T extends PanoramaCamera<T>>
implements InvertibleCoordinateTransform {
    protected final Matrix3x3 m = new Matrix3x3();
    protected final Matrix3x3 i = new Matrix3x3();
    protected double f = 1.0;
    protected double targetMaxSize = 0.0;
    protected double targetWidth = 0.0;
    protected double targetWidth2 = 0.0;
    protected double targetHeight = 0.0;
    protected double targetHeight2 = 0.0;

    public final double getF() {
        return this.f;
    }

    public final void setF(double f) {
        this.f = f;
    }

    public final void setOrientation(double lambda, double phi, double rho) {
        double sinLambda = Math.sin(lambda);
        double cosLambda = Math.cos(lambda);
        double sinPhi = Math.sin(phi);
        double cosPhi = Math.cos(phi);
        double sinRho = Math.sin(rho);
        double cosRho = Math.cos(rho);
        Matrix3x3 panInverse = new Matrix3x3(cosLambda, 0.0, -sinLambda, 0.0, 1.0, 0.0, sinLambda, 0.0, cosLambda);
        Matrix3x3 tiltInverse = new Matrix3x3(1.0, 0.0, 0.0, 0.0, cosPhi, sinPhi, 0.0, -sinPhi, cosPhi);
        Matrix3x3 rollInverse = new Matrix3x3(cosRho, sinRho, 0.0, -sinRho, cosRho, 0.0, 0.0, 0.0, 1.0);
        this.i.set(rollInverse);
        this.i.preConcatenate(tiltInverse);
        this.i.preConcatenate(panInverse);
    }

    public final void pan(double lambda) {
        double cosLambda = Math.cos(lambda);
        double sinLambda = Math.sin(lambda);
        Matrix3x3 panInverse = new Matrix3x3(cosLambda, 0.0, -sinLambda, 0.0, 1.0, 0.0, sinLambda, 0.0, cosLambda);
        this.i.concatenate(panInverse);
    }

    public final void tilt(double phi) {
        double cosPhi = Math.cos(phi);
        double sinPhi = Math.sin(phi);
        Matrix3x3 tiltInverse = new Matrix3x3(1.0, 0.0, 0.0, 0.0, cosPhi, sinPhi, 0.0, -sinPhi, cosPhi);
        this.i.concatenate(tiltInverse);
    }

    public final void roll(double rho) {
        double cosRho = Math.cos(rho);
        double sinRho = Math.sin(rho);
        Matrix3x3 panInverse = new Matrix3x3(cosRho, sinRho, 0.0, -sinRho, cosRho, 0.0, 0.0, 0.0, 1.0);
        this.i.concatenate(panInverse);
    }

    public final double getTargetWidth() {
        return this.targetWidth;
    }

    public final void setTargetWidth(double targetWidth) {
        this.targetWidth = targetWidth;
        this.targetWidth2 = 0.5 * targetWidth;
        this.targetMaxSize = Math.max(targetWidth, this.targetHeight);
    }

    public final double getTargetHeight() {
        return this.targetHeight;
    }

    public final void setTargetHeight(double targetHeight) {
        this.targetHeight = targetHeight;
        this.targetHeight2 = 0.5 * targetHeight;
        this.targetMaxSize = Math.max(this.targetWidth, targetHeight);
    }

    public final void resetOrientation() {
        this.m.reset();
        this.i.reset();
    }

    public final void concatenateOrientation(T p) {
        this.m.concatenate(((PanoramaCamera)p).m);
        this.i.preConcatenate(((PanoramaCamera)p).i);
    }

    public final void preConcatenateOrientation(T p) {
        this.m.preConcatenate(((PanoramaCamera)p).m);
        this.i.concatenate(((PanoramaCamera)p).i);
    }

    public final void setCamera(PanoramaCamera<?> c) {
        this.f = c.f;
        this.i.set(c.i);
        this.m.set(c.m);
    }

    public abstract T clone();

    public void set(T t) {
        this.f = ((PanoramaCamera)t).f;
        this.i.set(((PanoramaCamera)t).i);
        this.m.set(((PanoramaCamera)t).m);
        this.targetHeight = ((PanoramaCamera)t).targetHeight;
        this.targetHeight2 = ((PanoramaCamera)t).targetHeight2;
        this.targetMaxSize = ((PanoramaCamera)t).targetMaxSize;
        this.targetWidth = ((PanoramaCamera)t).targetWidth;
        this.targetWidth2 = ((PanoramaCamera)t).targetWidth2;
    }
}

