/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.RealTransformSequence;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.AbstractCoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.CoordinateTransform;
import org.janelia.saalfeldlab.n5.universe.metadata.ome.ngff.v05.transformations.RealCoordinateTransform;

public class SequenceCoordinateTransform
extends AbstractCoordinateTransform<RealTransformSequence>
implements RealCoordinateTransform<RealTransformSequence> {
    public static final String TYPE = "sequence";
    private final CoordinateTransform<?>[] transformations;

    public SequenceCoordinateTransform(CoordinateTransform<?>[] transformations) {
        this("", null, null, transformations);
    }

    public SequenceCoordinateTransform(String input, String output, CoordinateTransform<?>[] transformations) {
        this("", input, output, transformations);
    }

    public SequenceCoordinateTransform(String name, String input, String output, CoordinateTransform<?>[] transformations) {
        super(TYPE, name, input, output);
        this.transformations = transformations;
    }

    public SequenceCoordinateTransform(String name, String input, String output, List<CoordinateTransform<?>> transformationList) {
        super(TYPE, name, input, output);
        this.transformations = new CoordinateTransform[transformationList.size()];
        for (int i = 0; i < transformationList.size(); ++i) {
            this.transformations[i] = transformationList.get(i);
        }
    }

    @Override
    public RealTransformSequence getTransform() {
        System.out.println("getTransform");
        ArrayList<String[]> axOrders = SequenceCoordinateTransform.axisOrdersForTransform(this.getTransformations(), this.getOutputSpaceObj().getAxisNames());
        for (CharSequence[] charSequenceArray : axOrders) {
            System.out.println(String.join((CharSequence)" ", charSequenceArray));
        }
        RealTransformSequence totalTransform = new RealTransformSequence();
        CoordinateTransform<?>[] coordinateTransformArray = this.getTransformations();
        for (int i = 0; i < coordinateTransformArray.length; ++i) {
            CoordinateTransform<?> t = coordinateTransformArray[i];
            totalTransform.add(coordinateTransformArray[i].getTransform());
        }
        return totalTransform;
    }

    public boolean isAffine() {
        return Arrays.stream(this.transformations).map(CoordinateTransform::create).allMatch(x -> x.getTransform() instanceof AffineGet);
    }

    public AffineGet asAffine(int nd) {
        AffineTransform affine = new AffineTransform(nd);
        for (CoordinateTransform<?> t : this.transformations) {
            Object tform = t.getTransform();
            if (!(tform instanceof AffineGet)) {
                return null;
            }
            affine.preConcatenate((AffineGet)tform);
        }
        return affine;
    }

    public RealTransformSequence getTransformNoSubsets() {
        RealTransformSequence transform = new RealTransformSequence();
        for (CoordinateTransform<?> t : this.getTransformations()) {
            transform.add(t.getTransform());
        }
        return transform;
    }

    public RealTransformSequence getTransform(String[] axes) {
        return this.getTransform();
    }

    @Override
    public RealTransformSequence getTransform(N5Reader n5) {
        RealTransformSequence transform = new RealTransformSequence();
        for (CoordinateTransform<?> t : this.getTransformations()) {
            transform.add(t.getTransform(n5));
        }
        return transform;
    }

    public CoordinateTransform<?>[] getTransformations() {
        return this.transformations;
    }

    public static boolean isValid(CoordinateTransform<?>[] tforms) {
        HashSet<String> outputAxes = new HashSet<String>();
        for (CoordinateTransform<?> t : tforms) {
            for (String a : t.getOutputAxes()) {
                if (outputAxes.contains(a)) {
                    return false;
                }
                outputAxes.add(a);
            }
        }
        return true;
    }

    public static ArrayList<String[]> axisOrdersForTransform2(CoordinateTransform<?>[] tforms, String[] tgtAxes) {
        System.out.println("\naxisOrdersForTransform");
        ArrayList<String[]> axisOrders = new ArrayList<String[]>();
        axisOrders.add(tgtAxes);
        ArrayList tlist = new ArrayList();
        Collections.addAll(tlist, tforms);
        Collections.reverse(tlist);
        ArrayList<String> axes = new ArrayList<String>();
        Collections.addAll(axes, tgtAxes);
        for (CoordinateTransform t : tlist) {
            List<String> inAx = Arrays.asList(t.getInputAxes());
            List<String> outAx = Arrays.asList(t.getOutputAxes());
            axes.removeAll(outAx);
            axes.addAll(inAx);
            axisOrders.add((String[])axes.stream().toArray(String[]::new));
        }
        System.out.println("");
        Collections.reverse(axisOrders);
        return axisOrders;
    }

    public static ArrayList<String[]> axisOrdersForTransform(CoordinateTransform<?>[] tforms, String[] tgtAxes) {
        System.out.println("axisOrdersForTransform");
        ArrayList<String[]> axisOrders = new ArrayList<String[]>();
        axisOrders.add(tgtAxes);
        ArrayList tlist = new ArrayList();
        Collections.addAll(tlist, tforms);
        Collections.reverse(tlist);
        ArrayList<String> axes = new ArrayList<String>();
        Collections.addAll(axes, tgtAxes);
        for (CoordinateTransform t : tlist) {
            List<String> inAx = Arrays.asList(t.getInputAxes());
            List<String> outAx = Arrays.asList(t.getOutputAxes());
            int i = SequenceCoordinateTransform.firstIndex(axes, outAx);
            axes.removeAll(outAx);
            axes.addAll(i < 0 ? 0 : i, inAx);
            axisOrders.add((String[])axes.stream().toArray(String[]::new));
        }
        System.out.println("");
        Collections.reverse(axisOrders);
        return axisOrders;
    }

    public static ArrayList<String[]> axisOrdersForTransformFirst(CoordinateTransform<?>[] tforms, String[] tgtAxes) {
        System.out.println("axisOrdersForTransformFirst");
        ArrayList<String[]> axisOrders = new ArrayList<String[]>();
        axisOrders.add(tforms[0].getInputAxes());
        ArrayList<String> axes = new ArrayList<String>();
        Collections.addAll(axes, tgtAxes);
        for (CoordinateTransform<?> t : tforms) {
            List<String> inAx = Arrays.asList(t.getInputAxes());
            List<String> outAx = Arrays.asList(t.getOutputAxes());
            int i = SequenceCoordinateTransform.firstIndex(axes, outAx);
            axes.removeAll(outAx);
            axes.addAll(i < 0 ? 0 : i, inAx);
            axisOrders.add((String[])axes.stream().toArray(String[]::new));
        }
        System.out.println("");
        Collections.reverse(axisOrders);
        return axisOrders;
    }

    public static ArrayList<HashSet<String>> cumNeededAxes(CoordinateTransform<?>[] tforms) {
        System.out.println("cumNeededAxes");
        ArrayList tlist = new ArrayList();
        Collections.addAll(tlist, tforms);
        Collections.reverse(tlist);
        ArrayList<HashSet<String>> cAxisList = new ArrayList<HashSet<String>>();
        HashSet prev = null;
        for (CoordinateTransform t : tlist) {
            System.out.println("t: " + t);
            System.out.println("  axes : " + Arrays.toString(t.getInputAxes()));
            HashSet set = new HashSet();
            Collections.addAll(set, t.getInputAxes());
            if (prev != null) {
                set.addAll(prev);
            }
            prev = set;
            cAxisList.add(set);
        }
        Collections.reverse(cAxisList);
        return cAxisList;
    }

    private static <T> int firstIndex(List<T> list, List<T> search) {
        int idx = -1;
        for (T t : search) {
            int i = list.indexOf(t);
            if (i < 0 || idx >= 0 && i >= idx) continue;
            idx = i;
        }
        return idx;
    }

    public static ArrayList<int[]> inputIndexesFromAxisOrders(CoordinateTransform<?>[] tforms, List<String[]> axisOrders) {
        ArrayList<int[]> idxList = new ArrayList<int[]>();
        for (int i = 0; i < tforms.length; ++i) {
            idxList.add(SequenceCoordinateTransform.indexes(tforms[i].getInputAxes(), (Object[])axisOrders.get(i)));
        }
        return idxList;
    }

    public static ArrayList<int[]> outputIndexesFromAxisOrders(CoordinateTransform<?>[] tforms, List<String[]> axisOrders) {
        ArrayList<int[]> idxList = new ArrayList<int[]>();
        for (int i = 0; i < tforms.length; ++i) {
            idxList.add(SequenceCoordinateTransform.indexes(tforms[i].getOutputAxes(), (Object[])axisOrders.get(i + 1)));
        }
        return idxList;
    }

    private static <T> int[] indexes(T[] src, T[] tgt) {
        int[] idxs = new int[src.length];
        for (int i = 0; i < src.length; ++i) {
            idxs[i] = SequenceCoordinateTransform.indexOf(src[i], tgt);
        }
        return idxs;
    }

    private static <T> int indexOf(T t, T[] tgt) {
        for (int i = 0; i < tgt.length; ++i) {
            if (!tgt[i].equals(t)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isReindexed(int[] indexes) {
        for (int i = 0; i < indexes.length; ++i) {
            if (indexes[i] == i) continue;
            return true;
        }
        return false;
    }
}

