/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.universe.metadata;

import java.util.Optional;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.universe.N5TreeNode;
import org.janelia.saalfeldlab.n5.universe.metadata.N5CosemMetadata;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataParser;
import org.janelia.saalfeldlab.n5.universe.metadata.N5MetadataWriter;

public class N5CosemMetadataParser
implements N5MetadataParser<N5CosemMetadata>,
N5MetadataWriter<N5CosemMetadata> {
    @Override
    public Optional<N5CosemMetadata> parseMetadata(N5Reader n5, N5TreeNode node) {
        try {
            DatasetAttributes attributes = n5.getDatasetAttributes(node.getPath());
            if (attributes == null) {
                return Optional.empty();
            }
            String path = node.getPath();
            Optional<Object> cosemTransform = Optional.ofNullable(n5.getAttribute(node.getPath(), "transform", N5CosemMetadata.CosemTransform.class));
            return cosemTransform.map(t -> new N5CosemMetadata(path, (N5CosemMetadata.CosemTransform)t, attributes));
        }
        catch (N5Exception e) {
            return Optional.empty();
        }
    }

    @Override
    public void writeMetadata(N5CosemMetadata t, N5Writer n5, String group) throws Exception {
        if (t.getCosemTransform() != null) {
            n5.setAttribute(group, "transform", (Object)t.getCosemTransform());
        }
    }
}

