/*
 * Decompiled with CFR 0.152.
 */
package sc.fiji.hdf5;

import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.base.mdarray.MDFloatArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5DataSetInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.HDF5FloatStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.HDF5LinkInformation;
import ch.systemsx.cisd.hdf5.HDF5ObjectType;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.IHDF5ReaderConfigurator;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import hdf.hdf5lib.exceptions.HDF5Exception;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ColorProcessor;
import ij.process.ImageProcessor;
import java.awt.HeadlessException;
import java.util.ArrayList;
import java.util.List;
import sc.fiji.hdf5.DataSetInfo;

public class HDF5ImageJ {
    public static ImagePlus hdf5read(String filename, String datasetname) {
        String[] dsetNames = new String[]{datasetname};
        return HDF5ImageJ.loadDataSetsToHyperStack(filename, dsetNames, 1, 1);
    }

    public static ImagePlus hdf5read(String filename, String[] datasets, int nFrames, int nChannels) {
        return HDF5ImageJ.loadDataSetsToHyperStack(filename, datasets, nFrames, nChannels, false);
    }

    public static ImagePlus hdf5read(String filename, String datasetname, String layout) {
        String[] dsetNames = new String[]{datasetname};
        return HDF5ImageJ.loadCustomLayoutDataSetToHyperStack(filename, datasetname, layout, false);
    }

    public static void hdf5write(String filename, String datasetname) {
        HDF5ImageJ.saveHyperStack(IJ.getImage(), filename, datasetname, "", "", 0, "replace");
    }

    public static void hdf5write(ImagePlus imp, String filename, String datasetname) {
        HDF5ImageJ.saveHyperStack(imp, filename, datasetname, "", "", 0, "replace");
    }

    public static void hdf5write(ImagePlus imp, String filename, String datasetname, boolean replace) {
        if (replace) {
            HDF5ImageJ.saveHyperStack(imp, filename, datasetname, "", "", 0, "replace");
        } else {
            HDF5ImageJ.saveHyperStack(imp, filename, datasetname, "", "", 0, "append");
        }
    }

    public static void hdf5write(ImagePlus imp, String filename, String datasetname, String formatTime, String formatChannel, int compressionLevel) {
        HDF5ImageJ.saveHyperStack(imp, filename, datasetname, formatTime, formatChannel, compressionLevel, "replace");
    }

    public static void hdf5write(ImagePlus imp, String filename, String datasetname, String formatTime, String formatChannel, int compressionLevel, boolean replace) {
        if (replace) {
            HDF5ImageJ.saveHyperStack(imp, filename, datasetname, formatTime, formatChannel, compressionLevel, "replace");
        } else {
            HDF5ImageJ.saveHyperStack(imp, filename, datasetname, formatTime, formatChannel, compressionLevel, "append");
        }
    }

    public static ArrayList<DataSetInfo> hdf5list(String filename) {
        IHDF5Reader reader = HDF5Factory.openForReading((String)filename);
        ArrayList<DataSetInfo> dataSets = HDF5ImageJ.recursiveGetInfo(reader, reader.object().getLinkInformation("/"));
        reader.close();
        return dataSets;
    }

    static ArrayList<DataSetInfo> recursiveGetInfo(IHDF5Reader reader, HDF5LinkInformation link) {
        ArrayList<DataSetInfo> dataSets = new ArrayList<DataSetInfo>();
        HDF5ImageJ.recursiveGetInfo(reader, link, dataSets);
        return dataSets;
    }

    static void recursiveGetInfo(IHDF5Reader reader, HDF5LinkInformation link, ArrayList<DataSetInfo> dataSets) {
        List members = reader.object().getGroupMemberInformation(link.getPath(), true);
        for (HDF5LinkInformation info : members) {
            HDF5ObjectType type = info.getType();
            IJ.log((String)(info.getPath() + ":" + type));
            switch (type) {
                case EXTERNAL_LINK: {
                    String[] extl_paths = info.tryGetSymbolicLinkTarget().split("::");
                    IHDF5Reader extl_reader = HDF5Factory.openForReading((String)extl_paths[1]);
                    HDF5LinkInformation extl_target = extl_reader.object().getLinkInformation(extl_paths[2]);
                    type = extl_target.getType();
                    extl_reader.close();
                }
                case DATASET: {
                    HDF5DataSetInformation dsInfo = reader.object().getDataSetInformation(info.getPath());
                    HDF5DataTypeInformation dsType = dsInfo.getTypeInformation();
                    String dimText = "";
                    if (dsInfo.getRank() == 0) {
                        dimText = "1";
                    } else {
                        dimText = dimText + dsInfo.getDimensions()[0];
                        for (int i = 1; i < dsInfo.getRank(); ++i) {
                            dimText = dimText + "x" + dsInfo.getDimensions()[i];
                        }
                    }
                    String typeText = HDF5ImageJ.dsInfoToTypeString(dsInfo);
                    String element_size_um_text = "unknown";
                    try {
                        float[] element_size_um = reader.float32().getArrayAttr(info.getPath(), "element_size_um");
                        element_size_um_text = "" + element_size_um[0] + "x" + element_size_um[1] + "x" + element_size_um[2];
                    }
                    catch (HDF5Exception err) {
                        IJ.log((String)("Warning: Can't read attribute 'element_size_um' from dataset '" + info.getPath() + "':\n" + (Object)((Object)err)));
                    }
                    IJ.log((String)(info.getPath() + ":" + dsInfo));
                    dataSets.add(new DataSetInfo(info.getPath(), dimText, typeText, element_size_um_text));
                    break;
                }
                case SOFT_LINK: {
                    IJ.log((String)(info.getPath() + "     -> " + info.tryGetSymbolicLinkTarget()));
                    break;
                }
                case GROUP: {
                    HDF5ImageJ.recursiveGetInfo(reader, info, dataSets);
                    break;
                }
            }
        }
    }

    static ImagePlus loadDataSetsToHyperStack(String filename, String[] dsetNames, int nFrames, int nChannels) {
        return HDF5ImageJ.loadDataSetsToHyperStack(filename, dsetNames, nFrames, nChannels, true);
    }

    static ImagePlus loadDataSetsToHyperStack(String filename, String[] dsetNames, int nFrames, int nChannels, boolean show) {
        String dsetName = "";
        try {
            IHDF5ReaderConfigurator conf = HDF5Factory.configureForReading((String)filename);
            conf.performNumericConversions();
            IHDF5Reader reader = conf.reader();
            ImagePlus imp = null;
            int rank = 0;
            int nLevels = 0;
            int nRows = 0;
            int nCols = 0;
            boolean isRGB = false;
            int nBits = 0;
            double maxGray = 1.0;
            String typeText = "";
            for (int frame = 0; frame < nFrames; ++frame) {
                for (int channel = 0; channel < nChannels; ++channel) {
                    int lev;
                    MDByteArray rawdata;
                    dsetName = dsetNames[frame * nChannels + channel];
                    IJ.showStatus((String)("Loading " + dsetName));
                    IJ.showProgress((int)(frame * nChannels + channel + 1), (int)(nFrames * nChannels));
                    HDF5DataSetInformation dsInfo = reader.object().getDataSetInformation(dsetName);
                    float[] element_size_um = new float[]{1.0f, 1.0f, 1.0f};
                    try {
                        element_size_um = reader.float32().getArrayAttr(dsetName, "element_size_um");
                    }
                    catch (HDF5Exception err) {
                        IJ.log((String)("Warning: Can't read attribute 'element_size_um' from file '" + filename + "', dataset '" + dsetName + "':\n" + (Object)((Object)err) + "\nAssuming element size of 1 x 1 x 1 um^3"));
                    }
                    if (imp == null) {
                        rank = dsInfo.getRank();
                        typeText = HDF5ImageJ.dsInfoToTypeString(dsInfo);
                        if (rank == 2) {
                            nLevels = 1;
                            nRows = (int)dsInfo.getDimensions()[0];
                            nCols = (int)dsInfo.getDimensions()[1];
                        } else if (rank == 3) {
                            nLevels = (int)dsInfo.getDimensions()[0];
                            nRows = (int)dsInfo.getDimensions()[1];
                            nCols = (int)dsInfo.getDimensions()[2];
                            if (typeText.equals("uint8") && nCols == 3) {
                                nLevels = 1;
                                nRows = (int)dsInfo.getDimensions()[0];
                                nCols = (int)dsInfo.getDimensions()[1];
                                isRGB = true;
                            }
                        } else if (rank == 4 && typeText.equals("uint8")) {
                            nLevels = (int)dsInfo.getDimensions()[0];
                            nRows = (int)dsInfo.getDimensions()[1];
                            nCols = (int)dsInfo.getDimensions()[2];
                            isRGB = true;
                        } else {
                            IJ.error((String)(dsetName + ": rank " + rank + " of type " + typeText + " not supported (yet)"));
                            return null;
                        }
                        nBits = HDF5ImageJ.assignHDF5TypeToImagePlusBitdepth(typeText, isRGB);
                        imp = IJ.createHyperStack((String)(filename + ": " + dsetName), (int)nCols, (int)nRows, (int)nChannels, (int)nLevels, (int)nFrames, (int)nBits);
                        imp.getCalibration().pixelDepth = element_size_um[0];
                        imp.getCalibration().pixelHeight = element_size_um[1];
                        imp.getCalibration().pixelWidth = element_size_um[2];
                        imp.getCalibration().setUnit("micrometer");
                        imp.setDisplayRange(0.0, 255.0);
                    }
                    int sliceSize = nCols * nRows;
                    if (typeText.equals("uint8") && !isRGB) {
                        rawdata = reader.uint8().readMDArray(dsetName);
                        for (lev = 0; lev < nLevels; ++lev) {
                            ImageProcessor ip = imp.getStack().getProcessor(imp.getStackIndex(channel + 1, lev + 1, frame + 1));
                            System.arraycopy(rawdata.getAsFlatArray(), lev * sliceSize, (byte[])ip.getPixels(), 0, sliceSize);
                        }
                        maxGray = 255.0;
                        continue;
                    }
                    if (typeText.equals("uint8") && isRGB) {
                        rawdata = reader.uint8().readMDArray(dsetName);
                        byte[] srcArray = rawdata.getAsFlatArray();
                        for (int lev2 = 0; lev2 < nLevels; ++lev2) {
                            ImageProcessor ip = imp.getStack().getProcessor(imp.getStackIndex(channel + 1, lev2 + 1, frame + 1));
                            int[] trgArray = (int[])ip.getPixels();
                            int srcOffset = lev2 * sliceSize * 3;
                            for (int rc = 0; rc < sliceSize; ++rc) {
                                int red = srcArray[srcOffset + rc * 3] & 0xFF;
                                int green = srcArray[srcOffset + rc * 3 + 1] & 0xFF;
                                int blue = srcArray[srcOffset + rc * 3 + 2] & 0xFF;
                                trgArray[rc] = (red << 16) + (green << 8) + blue;
                            }
                        }
                        maxGray = 255.0;
                        continue;
                    }
                    if (typeText.equals("uint16")) {
                        rawdata = reader.uint16().readMDArray(dsetName);
                        for (lev = 0; lev < nLevels; ++lev) {
                            ImageProcessor ip = imp.getStack().getProcessor(imp.getStackIndex(channel + 1, lev + 1, frame + 1));
                            System.arraycopy(rawdata.getAsFlatArray(), lev * sliceSize, (short[])ip.getPixels(), 0, sliceSize);
                        }
                        short[] data = rawdata.getAsFlatArray();
                        for (int i = 0; i < data.length; ++i) {
                            if (!((double)data[i] > maxGray)) continue;
                            maxGray = data[i];
                        }
                        continue;
                    }
                    if (typeText.equals("int16")) {
                        rawdata = reader.int16().readMDArray(dsetName);
                        for (lev = 0; lev < nLevels; ++lev) {
                            ImageProcessor ip = imp.getStack().getProcessor(imp.getStackIndex(channel + 1, lev + 1, frame + 1));
                            System.arraycopy(rawdata.getAsFlatArray(), lev * sliceSize, (short[])ip.getPixels(), 0, sliceSize);
                        }
                        short[] data = rawdata.getAsFlatArray();
                        for (int i = 0; i < data.length; ++i) {
                            if (!((double)data[i] > maxGray)) continue;
                            maxGray = data[i];
                        }
                        continue;
                    }
                    if (!typeText.equals("float32") && !typeText.equals("float64")) continue;
                    rawdata = reader.float32().readMDArray(dsetName);
                    for (lev = 0; lev < nLevels; ++lev) {
                        ImageProcessor ip = imp.getStack().getProcessor(imp.getStackIndex(channel + 1, lev + 1, frame + 1));
                        System.arraycopy(rawdata.getAsFlatArray(), lev * sliceSize, (float[])ip.getPixels(), 0, sliceSize);
                    }
                    float[] data = rawdata.getAsFlatArray();
                    for (int i = 0; i < data.length; ++i) {
                        if (!((double)data[i] > maxGray)) continue;
                        maxGray = data[i];
                    }
                }
            }
            reader.close();
            for (int c = 1; c <= nChannels; ++c) {
                imp.setC(c);
                imp.setDisplayRange(0.0, maxGray);
            }
            imp.setC(1);
            if (show) {
                try {
                    imp.show();
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
            return imp;
        }
        catch (HDF5Exception err) {
            IJ.error((String)("Error while opening '" + filename + "', dataset '" + dsetName + "':\n" + (Object)((Object)err)));
        }
        catch (Exception err) {
            IJ.error((String)("Error while opening '" + filename + "', dataset '" + dsetName + "':\n" + err));
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory((String)"Load HDF5");
        }
        return null;
    }

    static ImagePlus loadCustomLayoutDataSetToHyperStack(String filename, String dsetName, String layout) {
        return HDF5ImageJ.loadCustomLayoutDataSetToHyperStack(filename, dsetName, layout, true);
    }

    static ImagePlus loadCustomLayoutDataSetToHyperStack(String filename, String dsetName, String layout, boolean show) {
        try {
            IHDF5ReaderConfigurator conf = HDF5Factory.configureForReading((String)filename);
            conf.performNumericConversions();
            IHDF5Reader reader = conf.reader();
            ImagePlus imp = null;
            IJ.showStatus((String)("Loading " + dsetName));
            HDF5DataSetInformation dsInfo = reader.object().getDataSetInformation(dsetName);
            float[] element_size_um = new float[]{1.0f, 1.0f, 1.0f};
            try {
                element_size_um = reader.float32().getArrayAttr(dsetName, "element_size_um");
            }
            catch (HDF5Exception err) {
                IJ.log((String)("Warning: Can't read attribute 'element_size_um' from file '" + filename + "', dataset '" + dsetName + "':\n" + (Object)((Object)err) + "\nAssuming element size of 1 x 1 x 1 um^3"));
            }
            int rank = dsInfo.getRank();
            String typeText = HDF5ImageJ.dsInfoToTypeString(dsInfo);
            if (rank != layout.length()) {
                IJ.error((String)(dsetName + ": rank " + rank + " is incompatible with your given layout string '" + layout + "' (rank " + layout.length() + ")"));
                return null;
            }
            long[] dsetExtent = dsInfo.getDimensions();
            int[] stride = new int[rank];
            stride[rank - 1] = 1;
            for (int d = rank - 2; d >= 0; --d) {
                stride[d] = (int)dsetExtent[d + 1] * stride[d + 1];
            }
            int nLevels = 1;
            int nRows = 1;
            int nCols = 1;
            int nFrames = 1;
            int nChannels = 1;
            int levelToLevelOffset = 0;
            int rowToRowOffset = 0;
            int colToColOffset = 0;
            int frameToFrameOffset = 0;
            int channelToChannelOffset = 0;
            int nBits = 0;
            double maxGray = 1.0;
            block16: for (int d = 0; d < rank; ++d) {
                switch (layout.charAt(d)) {
                    case 'x': {
                        nCols = (int)dsetExtent[d];
                        colToColOffset = stride[d];
                        continue block16;
                    }
                    case 'y': {
                        nRows = (int)dsetExtent[d];
                        rowToRowOffset = stride[d];
                        continue block16;
                    }
                    case 'z': {
                        nLevels = (int)dsetExtent[d];
                        levelToLevelOffset = stride[d];
                        continue block16;
                    }
                    case 'c': {
                        nChannels = (int)dsetExtent[d];
                        channelToChannelOffset = stride[d];
                        continue block16;
                    }
                    case 't': {
                        nFrames = (int)dsetExtent[d];
                        frameToFrameOffset = stride[d];
                        continue block16;
                    }
                    default: {
                        IJ.error((String)("your given layout string '" + layout + "' contains the illegal character '" + layout.charAt(d) + "'. Allowed characters are 'xyzct'"));
                        return null;
                    }
                }
            }
            IJ.log((String)("Creating hyperstack with " + nFrames + " frames, " + nChannels + " channels, " + nLevels + " levels, " + nRows + " rows, and " + nCols + " cols"));
            boolean isRGB = false;
            nBits = HDF5ImageJ.assignHDF5TypeToImagePlusBitdepth(typeText, isRGB);
            imp = IJ.createHyperStack((String)(filename + ": " + dsetName), (int)nCols, (int)nRows, (int)nChannels, (int)nLevels, (int)nFrames, (int)nBits);
            imp.getCalibration().pixelDepth = element_size_um[0];
            imp.getCalibration().pixelHeight = element_size_um[1];
            imp.getCalibration().pixelWidth = element_size_um[2];
            imp.getCalibration().setUnit("micrometer");
            imp.setDisplayRange(0.0, 255.0);
            if (typeText.equals("uint8")) {
                byte[] rawdata = reader.uint8().readMDArray(dsetName).getAsFlatArray();
                for (int frame = 0; frame < nFrames; ++frame) {
                    for (int channel = 0; channel < nChannels; ++channel) {
                        for (int lev = 0; lev < nLevels; ++lev) {
                            ImageProcessor ip = imp.getStack().getProcessor(imp.getStackIndex(channel + 1, lev + 1, frame + 1));
                            for (int row = 0; row < nRows; ++row) {
                                byte[] trgData = (byte[])ip.getPixels();
                                int trgOffset = row * nCols;
                                int srcOffset = frame * frameToFrameOffset + channel * channelToChannelOffset + lev * levelToLevelOffset + row * rowToRowOffset;
                                for (int col = 0; col < nCols; ++col) {
                                    trgData[trgOffset] = rawdata[srcOffset];
                                    ++trgOffset;
                                    srcOffset += colToColOffset;
                                }
                            }
                        }
                    }
                }
                maxGray = 255.0;
            } else if (typeText.equals("uint16")) {
                short[] rawdata = reader.uint16().readMDArray(dsetName).getAsFlatArray();
                for (int frame = 0; frame < nFrames; ++frame) {
                    for (int channel = 0; channel < nChannels; ++channel) {
                        for (int lev = 0; lev < nLevels; ++lev) {
                            ImageProcessor ip = imp.getStack().getProcessor(imp.getStackIndex(channel + 1, lev + 1, frame + 1));
                            for (int row = 0; row < nRows; ++row) {
                                short[] trgData = (short[])ip.getPixels();
                                int trgOffset = row * nCols;
                                int srcOffset = frame * frameToFrameOffset + channel * channelToChannelOffset + lev * levelToLevelOffset + row * rowToRowOffset;
                                for (int col = 0; col < nCols; ++col) {
                                    trgData[trgOffset] = rawdata[srcOffset];
                                    ++trgOffset;
                                    srcOffset += colToColOffset;
                                }
                            }
                        }
                    }
                }
                for (int i = 0; i < rawdata.length; ++i) {
                    if (!((double)rawdata[i] > maxGray)) continue;
                    maxGray = rawdata[i];
                }
            } else if (typeText.equals("int16")) {
                short[] rawdata = reader.int16().readMDArray(dsetName).getAsFlatArray();
                for (int frame = 0; frame < nFrames; ++frame) {
                    for (int channel = 0; channel < nChannels; ++channel) {
                        for (int lev = 0; lev < nLevels; ++lev) {
                            ImageProcessor ip = imp.getStack().getProcessor(imp.getStackIndex(channel + 1, lev + 1, frame + 1));
                            for (int row = 0; row < nRows; ++row) {
                                short[] trgData = (short[])ip.getPixels();
                                int trgOffset = row * nCols;
                                int srcOffset = frame * frameToFrameOffset + channel * channelToChannelOffset + lev * levelToLevelOffset + row * rowToRowOffset;
                                for (int col = 0; col < nCols; ++col) {
                                    trgData[trgOffset] = rawdata[srcOffset];
                                    ++trgOffset;
                                    srcOffset += colToColOffset;
                                }
                            }
                        }
                    }
                }
                for (int i = 0; i < rawdata.length; ++i) {
                    if (!((double)rawdata[i] > maxGray)) continue;
                    maxGray = rawdata[i];
                }
            } else if (typeText.equals("float32") || typeText.equals("float64")) {
                float[] rawdata = reader.float32().readMDArray(dsetName).getAsFlatArray();
                for (int frame = 0; frame < nFrames; ++frame) {
                    for (int channel = 0; channel < nChannels; ++channel) {
                        for (int lev = 0; lev < nLevels; ++lev) {
                            ImageProcessor ip = imp.getStack().getProcessor(imp.getStackIndex(channel + 1, lev + 1, frame + 1));
                            for (int row = 0; row < nRows; ++row) {
                                float[] trgData = (float[])ip.getPixels();
                                int trgOffset = row * nCols;
                                int srcOffset = frame * frameToFrameOffset + channel * channelToChannelOffset + lev * levelToLevelOffset + row * rowToRowOffset;
                                for (int col = 0; col < nCols; ++col) {
                                    trgData[trgOffset] = rawdata[srcOffset];
                                    ++trgOffset;
                                    srcOffset += colToColOffset;
                                }
                            }
                        }
                    }
                }
                for (int i = 0; i < rawdata.length; ++i) {
                    if (!((double)rawdata[i] > maxGray)) continue;
                    maxGray = rawdata[i];
                }
            }
            reader.close();
            imp.setDisplayRange(0.0, maxGray);
            if (show) {
                try {
                    imp.show();
                }
                catch (HeadlessException headlessException) {
                    // empty catch block
                }
            }
            return imp;
        }
        catch (HDF5Exception err) {
            IJ.error((String)("Error while opening '" + filename + "', dataset '" + dsetName + "':\n" + (Object)((Object)err)));
        }
        catch (Exception err) {
            IJ.error((String)("Error while opening '" + filename + "', dataset '" + dsetName + "':\n" + err));
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory((String)"Load HDF5");
        }
        return null;
    }

    static void saveHyperStack(ImagePlus imp, String filename, String dsetNameTemplate, String formatTime, String formatChannel, int compressionLevel, String saveMode) {
        int nFrames = imp.getNFrames();
        int nChannels = imp.getNChannels();
        int nLevs = imp.getNSlices();
        int nRows = imp.getHeight();
        int nCols = imp.getWidth();
        String[] substT = HDF5ImageJ.createNameList(formatTime, nFrames);
        String[] substC = HDF5ImageJ.createNameList(formatChannel, nChannels);
        try {
            IHDF5Writer writer = saveMode.equals("append") ? HDF5Factory.configure((String)filename).useSimpleDataSpaceForAttributes().writer() : HDF5Factory.configure((String)filename).useSimpleDataSpaceForAttributes().overwrite().writer();
            Calibration cal = imp.getCalibration();
            float[] element_size_um = new float[]{(float)cal.pixelDepth, (float)cal.pixelHeight, (float)cal.pixelWidth};
            long[] channelDims = null;
            channelDims = nLevs > 1 ? new long[]{nLevs, nRows, nCols} : new long[]{nRows, nCols};
            for (int t = 0; t < nFrames; ++t) {
                for (int c = 0; c < nChannels; ++c) {
                    int stackIndex;
                    int lev;
                    Object[] flatArr;
                    ImageStack stack;
                    MDByteArray arr;
                    String dsetName = dsetNameTemplate;
                    dsetName = dsetName.replace("{t}", substT[t]);
                    dsetName = dsetName.replace("{c}", substC[c]);
                    System.out.println("t=" + t + ",c=" + c + " --> " + dsetName);
                    int imgColorType = imp.getType();
                    if (imgColorType == 0 || imgColorType == 3) {
                        arr = new MDByteArray(channelDims);
                        stack = imp.getStack();
                        flatArr = arr.getAsFlatArray();
                        int sliceSize = nRows * nCols;
                        for (lev = 0; lev < nLevs; ++lev) {
                            stackIndex = imp.getStackIndex(c + 1, lev + 1, t + 1);
                            System.arraycopy(stack.getPixels(stackIndex), 0, flatArr, lev * sliceSize, sliceSize);
                        }
                        writer.uint8().writeMDArray(dsetName, arr, HDF5IntStorageFeatures.createDeflationDelete((int)compressionLevel));
                    } else if (imgColorType == 1) {
                        arr = new MDShortArray(channelDims);
                        stack = imp.getStack();
                        flatArr = arr.getAsFlatArray();
                        int sliceSize = nRows * nCols;
                        for (lev = 0; lev < nLevs; ++lev) {
                            stackIndex = imp.getStackIndex(c + 1, lev + 1, t + 1);
                            System.arraycopy(stack.getPixels(stackIndex), 0, flatArr, lev * sliceSize, sliceSize);
                        }
                        writer.uint16().writeMDArray(dsetName, (MDShortArray)arr, HDF5IntStorageFeatures.createDeflationDelete((int)compressionLevel));
                    } else if (imgColorType == 2) {
                        arr = new MDFloatArray(channelDims);
                        stack = imp.getStack();
                        flatArr = arr.getAsFlatArray();
                        int sliceSize = nRows * nCols;
                        for (lev = 0; lev < nLevs; ++lev) {
                            stackIndex = imp.getStackIndex(c + 1, lev + 1, t + 1);
                            System.arraycopy(stack.getPixels(stackIndex), 0, flatArr, lev * sliceSize, sliceSize);
                        }
                        writer.float32().writeMDArray(dsetName, (MDFloatArray)arr, HDF5FloatStorageFeatures.createDeflationDelete((int)compressionLevel));
                    } else if (imgColorType == 4) {
                        long[] channelDimsRGB = null;
                        channelDimsRGB = nLevs > 1 ? new long[]{nLevs, nRows, nCols, 3L} : new long[]{nRows, nCols, 3L};
                        MDByteArray arr2 = new MDByteArray(channelDimsRGB);
                        ImageStack stack2 = imp.getStack();
                        byte[] flatArr2 = arr2.getAsFlatArray();
                        int sliceSize = nRows * nCols;
                        for (int lev2 = 0; lev2 < nLevs; ++lev2) {
                            int stackIndex2 = imp.getStackIndex(c + 1, lev2 + 1, t + 1);
                            ColorProcessor cp = (ColorProcessor)stack2.getProcessor(stackIndex2);
                            byte[] red = cp.getChannel(1);
                            byte[] green = cp.getChannel(2);
                            byte[] blue = cp.getChannel(3);
                            int offset = lev2 * sliceSize * 3;
                            for (int i = 0; i < sliceSize; ++i) {
                                flatArr2[offset + 3 * i + 0] = red[i];
                                flatArr2[offset + 3 * i + 1] = green[i];
                                flatArr2[offset + 3 * i + 2] = blue[i];
                            }
                        }
                        writer.uint8().writeMDArray(dsetName, arr2, HDF5IntStorageFeatures.createDeflationDelete((int)compressionLevel));
                    }
                    writer.float32().setArrayAttr(dsetName, "element_size_um", element_size_um);
                }
            }
            writer.close();
        }
        catch (HDF5Exception err) {
            IJ.error((String)("Error while saving '" + filename + "':\n" + (Object)((Object)err)));
        }
        catch (Exception err) {
            IJ.error((String)("Error while saving '" + filename + "':\n" + err));
        }
        catch (OutOfMemoryError o) {
            IJ.outOfMemory((String)("Error while saving '" + filename + "'"));
        }
    }

    static String dsInfoToTypeString(HDF5DataSetInformation dsInfo) {
        HDF5DataTypeInformation dsType = dsInfo.getTypeInformation();
        String typeText = "";
        if (!dsType.isSigned()) {
            typeText = typeText + "u";
        }
        switch (dsType.getDataClass()) {
            case INTEGER: {
                typeText = typeText + "int" + 8 * dsType.getElementSize();
                break;
            }
            case FLOAT: {
                typeText = typeText + "float" + 8 * dsType.getElementSize();
                break;
            }
            default: {
                typeText = typeText + dsInfo.toString();
            }
        }
        return typeText;
    }

    static int assignHDF5TypeToImagePlusBitdepth(String type, boolean isRGB) {
        int nBits = 0;
        if (type.equals("uint8")) {
            nBits = isRGB ? 24 : 8;
        } else if (type.equals("uint16") || type.equals("int16")) {
            nBits = 16;
        } else if (type.equals("float32") || type.equals("float64")) {
            nBits = 32;
        } else {
            IJ.error((String)("Type '" + type + "' Not handled yet!"));
        }
        return nBits;
    }

    static String[] createNameList(String formatString, int nElements) {
        String[] nameList = new String[nElements];
        if (formatString.startsWith("%")) {
            for (int i = 0; i < nElements; ++i) {
                nameList[i] = String.format(formatString, i);
            }
        } else {
            String[] tokens = formatString.split("[,\\s]+");
            if (tokens.length >= nElements) {
                nameList = tokens;
            } else {
                int i;
                IJ.log((String)("Warning: format-list \"" + formatString + "\" contains only " + tokens.length + " tokens, but yout dataset needs " + nElements + " unique entries! Appending numbers \"" + tokens.length + "\" to \"" + (nElements - 1) + "\"!"));
                for (i = 0; i < tokens.length; ++i) {
                    nameList[i] = tokens[i];
                }
                for (i = tokens.length; i < nElements; ++i) {
                    nameList[i] = String.format("%d", i);
                }
            }
        }
        return nameList;
    }
}

