/*
 * Decompiled with CFR 0.152.
 */
package org.bounce;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.security.ProtectionDomain;
import java.security.SecureClassLoader;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class JarClassLoader
extends SecureClassLoader {
    private boolean DEBUG = false;
    private static final String JAR_SCHEME = "jar";
    private static final String JAR_SEPARATOR = "!/";
    private static final String CLASS_EXTENSION = ".class";
    private static final char WINDOWS_SLASH = '\\';
    private static final char UNIX_SLASH = '/';
    private static final char DOT = '.';
    private HashMap<String, byte[]> contents;
    private URL url;

    public JarClassLoader(URL url) throws IOException {
        this(JarClassLoader.getSystemClassLoader(), url);
    }

    public JarClassLoader(ClassLoader parent, URL url) throws IOException {
        super(parent);
        if (this.DEBUG) {
            System.out.println("[" + this + "] JarClassLoader( " + parent + ", " + url + ")");
        }
        HashMap<String, Integer> sizes = new HashMap<String, Integer>();
        this.url = url;
        ZipFile zf = new ZipFile(url.getFile());
        Enumeration<? extends ZipEntry> entries = zf.entries();
        while (entries.hasMoreElements()) {
            ZipEntry entry = entries.nextElement();
            int size = (int)entry.getSize();
            String name = entry.getName();
            sizes.put(this.getEntryKey(name), new Integer(size));
        }
        zf.close();
        this.contents = new HashMap();
        FileInputStream fis = new FileInputStream(url.getFile());
        BufferedInputStream bis = new BufferedInputStream(fis);
        JarInputStream jar = new JarInputStream(bis);
        JarEntry entry = jar.getNextJarEntry();
        while (entry != null) {
            int totalRead;
            int read;
            String name = this.getEntryKey(entry.getName());
            int size = (int)entry.getSize();
            if (size < 0) {
                size = (Integer)sizes.get(name);
            }
            byte[] buffer = new byte[size];
            for (totalRead = 0; totalRead != size && (read = jar.read(buffer, totalRead, size - totalRead)) >= 0; totalRead += read) {
            }
            if (totalRead != size) {
                throw new IOException("Cannot read entry: " + name);
            }
            this.contents.put(name, buffer);
            entry = jar.getNextJarEntry();
        }
        jar.close();
    }

    public synchronized Class findClass(String name) throws ClassNotFoundException {
        Class<?> result;
        if (this.DEBUG) {
            System.out.println("[" + this + "] JarClassLoader.findClass( " + name + ")");
        }
        if ((result = super.findLoadedClass(name)) == null) {
            String key = name.replace('.', '/') + CLASS_EXTENSION;
            byte[] bytes = this.contents.get(key);
            if (bytes == null) {
                throw new ClassNotFoundException();
            }
            if (this.DEBUG) {
                System.out.println("[" + this + "] defineClass( " + name + ", " + bytes + ", 0, " + bytes.length + ")");
            }
            result = this.defineClass(name, bytes, 0, bytes.length, (ProtectionDomain)null);
        }
        return result;
    }

    public URL findResource(String name) {
        if (this.DEBUG) {
            System.out.println("[" + this + "] JarClassLoader.findResource( " + name + ")");
        }
        URL resource = null;
        if (this.contents.containsKey(name)) {
            try {
                StringBuffer buffer = new StringBuffer(this.url.toExternalForm());
                buffer.append(JAR_SEPARATOR);
                buffer.append(name);
                resource = new URL(JAR_SCHEME, null, buffer.toString());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (this.DEBUG) {
            System.out.println("[" + this + "] JarClassLoader.findResource( " + name + ") [" + resource + "]");
        }
        return resource;
    }

    private String getEntryKey(String name) {
        return name.replace('\\', '/');
    }
}

