/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.search.module;

import java.io.IOException;
import java.net.URL;
import org.scijava.log.LogService;
import org.scijava.module.ModuleInfo;
import org.scijava.platform.PlatformService;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;
import org.scijava.search.DefaultSearchAction;
import org.scijava.search.SearchAction;
import org.scijava.search.SearchActionFactory;
import org.scijava.search.SearchResult;
import org.scijava.search.module.ModuleSearchResult;
import org.scijava.util.POM;

@Plugin(type=SearchActionFactory.class)
public class HelpSearchActionFactory
implements SearchActionFactory {
    @Parameter
    private PlatformService platformService;
    @Parameter
    private LogService log;

    @Override
    public boolean supports(SearchResult result) {
        return result instanceof ModuleSearchResult;
    }

    @Override
    public SearchAction create(SearchResult result) {
        return new DefaultSearchAction("Help", () -> this.help((ModuleSearchResult)result));
    }

    private void help(ModuleSearchResult result) {
        try {
            ModuleInfo info = result.info();
            String url = POM.getPOM(info.loadDelegateClass()).getProjectURL();
            this.platformService.open(new URL(url));
        }
        catch (IOException | ClassNotFoundException exc) {
            this.log.error(exc);
        }
    }
}

