/*
 * Decompiled with CFR 0.152.
 */
package io.scif.formats;

import io.scif.AbstractChecker;
import io.scif.AbstractFormat;
import io.scif.AbstractMetadata;
import io.scif.AbstractParser;
import io.scif.ByteArrayPlane;
import io.scif.ByteArrayReader;
import io.scif.Field;
import io.scif.Format;
import io.scif.FormatException;
import io.scif.ImageMetadata;
import io.scif.config.SCIFIOConfig;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.ZoneOffset;
import net.imagej.axis.Axes;
import net.imagej.axis.CalibratedAxis;
import net.imagej.axis.DefaultLinearAxis;
import net.imglib2.Interval;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.location.Location;
import org.scijava.plugin.Plugin;

@Plugin(type=Format.class, name="Scanco ISQ")
public class ScancoISQFormat
extends AbstractFormat {
    public static final String ISQ_ID = "CTDATA-HEADER_V1";

    @Override
    protected String[] makeSuffixArray() {
        return new String[]{"isq"};
    }

    public static class Reader
    extends ByteArrayReader<Metadata> {
        @Override
        protected String[] createDomainArray() {
            return new String[]{"Medical Imaging"};
        }

        @Override
        public ByteArrayPlane openPlane(int imageIndex, long planeIndex, ByteArrayPlane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
            DataHandle<Location> stream = this.getHandle();
            Metadata metadata = (Metadata)this.getMetadata();
            int offset = (int)((long)metadata.dataOffset + (long)metadata.sliceBytes * planeIndex);
            stream.seek((long)offset);
            return this.readPlane(stream, imageIndex, bounds, plane);
        }
    }

    public static class Parser
    extends AbstractParser<Metadata> {
        @Override
        protected void typedParse(DataHandle<Location> stream, Metadata meta, SCIFIOConfig config) throws IOException, FormatException {
            config.imgOpenerSetComputeMinMax(true);
            stream.setOrder(DataHandle.ByteOrder.LITTLE_ENDIAN);
            stream.seek(28L);
            meta.setPatientIndex(stream.readInt());
            meta.setScannerId(stream.readInt());
            meta.setCreationDate(stream.readLong());
            meta.setWidth(stream.readInt());
            meta.setHeight(stream.readInt());
            meta.setSlices(stream.readInt());
            meta.setPhysicalWidth(stream.readInt());
            meta.setPhysicalHeight(stream.readInt());
            meta.setPhysicalDepth(stream.readInt());
            meta.setSliceThickness(stream.readInt());
            meta.setSliceSpacing(stream.readInt());
            meta.setFirstSlicePosition(stream.readInt());
            meta.setMinDataValue(stream.readInt());
            meta.setMaxDataValue(stream.readInt());
            meta.setMuScaling(stream.readInt());
            meta.setSamples(stream.readInt());
            meta.setProjections(stream.readInt());
            meta.setScanDistance(stream.readInt());
            meta.setScannerType(stream.readInt());
            meta.setSamplingTime(stream.readInt());
            meta.setMeasurementIndex(stream.readInt());
            meta.setSite(stream.readInt());
            meta.setReferenceLine(stream.readInt());
            meta.setReconstructionAlgorithm(stream.readInt());
            meta.setPatientName(stream.readString(40));
            meta.setEnergy(stream.readInt());
            meta.setIntensity(stream.readInt());
            stream.seek(508L);
            meta.setDataOffset(stream.readInt());
        }
    }

    public static class Metadata
    extends AbstractMetadata {
        public static final String UNIT = "um";
        public static final int HEADER_BLOCK = 512;
        public static final long UNIX_EPOCH = 35067168000000000L;
        @Field(label="Patient index")
        private int patientIndex;
        @Field(label="Scanner ID")
        private int scannerId;
        @Field(label="Creation date")
        private LocalDate creationDate;
        @Field(label="Slice width in pixels")
        private int width;
        @Field(label="Slice height in pixels")
        private int height;
        @Field(label="Slices in stack")
        private int slices;
        @Field(label="Physical width (\u00b5m)")
        private int physicalWidth;
        @Field(label="Physical height (\u00b5m)")
        private int physicalHeight;
        @Field(label="Physical depth (\u00b5m)")
        private int physicalDepth;
        @Field(label="Slice thickness (\u00b5m)")
        private int sliceThickness;
        @Field(label="Slice spacing (\u00b5m)")
        private int sliceSpacing;
        @Field(label="Location of first slice in sample (\u00b5m)")
        private int firstSlicePosition;
        @Field(label="Minimum value in the data")
        private int minDataValue;
        @Field(label="Maximum value in the data")
        private int maxDataValue;
        @Field(label="X-ray linear attenuation value scaling constant")
        private int muScaling;
        @Field(label="Number of samples")
        private int samples;
        @Field(label="Number of projections")
        private int projections;
        @Field(label="The physical distance the stack covers (\u00b5m)")
        private int scanDistance;
        @Field(label="Scanner type")
        private int scannerType;
        @Field(label="Time the sampling took (\u00b5s)")
        private int samplingTime;
        @Field(label="Index of measurement")
        private int measurementIndex;
        @Field(label="Sample site (coded value)")
        private int site;
        @Field(label="Length of the reference line (\u00b5m)")
        private int referenceLine;
        @Field(label="Reconstruction algorithm (coded value)")
        private int reconstructionAlgorithm;
        @Field(label="Patient name")
        private String patientName;
        @Field(label="Energy (V)")
        private int energy;
        @Field(label="Intensity (\u00b5A)")
        private int intensity;
        @Field(label="Starting byte of image data")
        private int dataOffset = 512;
        private double voxelWidth;
        private double voxelHeight;
        private double voxelDepth;
        private int sliceBytes;

        public LocalDate getCreationDate() {
            return this.creationDate;
        }

        public int getDataOffset() {
            return this.dataOffset;
        }

        public int getEnergy() {
            return this.energy;
        }

        public int getFirstSlicePosition() {
            return this.firstSlicePosition;
        }

        public int getHeight() {
            return this.height;
        }

        public int getIntensity() {
            return this.intensity;
        }

        public int getMaxDataValue() {
            return this.maxDataValue;
        }

        public int getMeasurementIndex() {
            return this.measurementIndex;
        }

        public int getMinDataValue() {
            return this.minDataValue;
        }

        public int getMuScaling() {
            return this.muScaling;
        }

        public int getPatientIndex() {
            return this.patientIndex;
        }

        public String getPatientName() {
            return this.patientName;
        }

        public int getPhysicalDepth() {
            return this.physicalDepth;
        }

        public int getPhysicalHeight() {
            return this.physicalHeight;
        }

        public int getPhysicalWidth() {
            return this.physicalWidth;
        }

        public int getProjections() {
            return this.projections;
        }

        public int getReconstructionAlgorithm() {
            return this.reconstructionAlgorithm;
        }

        public int getReferenceLine() {
            return this.referenceLine;
        }

        public int getSamples() {
            return this.samples;
        }

        public int getSamplingTime() {
            return this.samplingTime;
        }

        public int getScanDistance() {
            return this.scanDistance;
        }

        public int getScannerId() {
            return this.scannerId;
        }

        public int getScannerType() {
            return this.scannerType;
        }

        public int getSite() {
            return this.site;
        }

        public int getSliceSpacing() {
            return this.sliceSpacing;
        }

        public int getSliceThickness() {
            return this.sliceThickness;
        }

        public int getSlices() {
            return this.slices;
        }

        public int getWidth() {
            return this.width;
        }

        public int getSliceBytes() {
            return this.sliceBytes;
        }

        public void setCreationDate(long vmsTimestamp) {
            long unixTimestamp = (vmsTimestamp - 35067168000000000L) / 10000000L;
            this.creationDate = Instant.ofEpochSecond(unixTimestamp).atZone(ZoneId.ofOffset("", ZoneOffset.UTC)).toLocalDate();
        }

        public void setDataOffset(int optionalHeaders) {
            this.dataOffset = (optionalHeaders + 1) * 512;
        }

        public void setEnergy(int energy) {
            this.energy = energy;
        }

        public void setFirstSlicePosition(int firstSlicePosition) {
            this.firstSlicePosition = firstSlicePosition;
        }

        public void setHeight(int height) {
            this.height = height;
        }

        public void setIntensity(int intensity) {
            this.intensity = intensity;
        }

        public void setMaxDataValue(int maxDataValue) {
            this.maxDataValue = maxDataValue;
        }

        public void setMeasurementIndex(int measurementIndex) {
            this.measurementIndex = measurementIndex;
        }

        public void setMinDataValue(int minDataValue) {
            this.minDataValue = minDataValue;
        }

        public void setMuScaling(int muScaling) {
            this.muScaling = muScaling;
        }

        public void setPatientIndex(int patientIndex) {
            this.patientIndex = patientIndex;
        }

        public void setPatientName(String patientName) {
            this.patientName = patientName;
        }

        public void setPhysicalDepth(int physicalDepth) {
            this.physicalDepth = physicalDepth;
        }

        public void setPhysicalHeight(int physicalHeight) {
            this.physicalHeight = physicalHeight;
        }

        public void setPhysicalWidth(int physicalWidth) {
            this.physicalWidth = physicalWidth;
        }

        public void setProjections(int projections) {
            this.projections = projections;
        }

        public void setReconstructionAlgorithm(int reconstructionAlgorithm) {
            this.reconstructionAlgorithm = reconstructionAlgorithm;
        }

        public void setReferenceLine(int referenceLine) {
            this.referenceLine = referenceLine;
        }

        public void setSamples(int samples) {
            this.samples = samples;
        }

        public void setSamplingTime(int samplingTime) {
            this.samplingTime = samplingTime;
        }

        public void setScanDistance(int scanDistance) {
            this.scanDistance = scanDistance;
        }

        public void setScannerId(int scannerId) {
            this.scannerId = scannerId;
        }

        public void setScannerType(int scannerType) {
            this.scannerType = scannerType;
        }

        public void setSite(int site) {
            this.site = site;
        }

        public void setSliceSpacing(int sliceSpacing) {
            this.sliceSpacing = sliceSpacing;
        }

        public void setSliceThickness(int sliceThickness) {
            this.sliceThickness = sliceThickness;
        }

        public void setSlices(int slices) {
            this.slices = slices;
        }

        public void setWidth(int width) {
            this.width = width;
        }

        @Override
        public void populateImageMetadata() {
            this.createImageMetadata(1);
            ImageMetadata metadata = this.get(0);
            metadata.setLittleEndian(true);
            metadata.setBitsPerPixel(16);
            metadata.setPixelType(2);
            metadata.setOrderCertain(true);
            metadata.setPlanarAxisCount(2);
            this.setVoxelDimensions();
            metadata.setAxes(new CalibratedAxis[]{new DefaultLinearAxis(Axes.X, UNIT, this.voxelWidth), new DefaultLinearAxis(Axes.Y, UNIT, this.voxelHeight), new DefaultLinearAxis(Axes.Z, UNIT, this.voxelDepth)});
            metadata.setAxisLengths(new long[]{this.width, this.height, this.slices});
            this.setSliceBytes();
        }

        private void setSliceBytes() {
            ImageMetadata imageMetadata = this.get(0);
            if (imageMetadata == null) {
                return;
            }
            int bytesPerPixel = imageMetadata.getBitsPerPixel() / 8;
            this.sliceBytes = this.width * this.height * bytesPerPixel;
        }

        private void setVoxelDimensions() {
            this.voxelWidth = 1.0 * (double)this.physicalWidth / (double)this.width;
            this.voxelHeight = 1.0 * (double)this.physicalHeight / (double)this.height;
            this.voxelDepth = 1.0 * (double)this.physicalDepth / (double)this.slices;
        }
    }

    public static class Checker
    extends AbstractChecker {
        @Override
        public boolean suffixSufficient() {
            return false;
        }

        @Override
        public boolean isFormat(DataHandle<Location> stream) throws IOException {
            byte[] firstBytes = new byte[ScancoISQFormat.ISQ_ID.length()];
            stream.read(firstBytes);
            String fileStart = new String(firstBytes);
            return ScancoISQFormat.ISQ_ID.equals(fileStart);
        }
    }
}

