/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractSCIFIOPlugin;
import io.scif.ImageMetadata;
import io.scif.Metadata;
import io.scif.Translator;
import io.scif.util.SCIFIOMetadataTools;
import java.util.List;

public abstract class AbstractTranslator<M extends Metadata, N extends Metadata>
extends AbstractSCIFIOPlugin
implements Translator {
    @Override
    public void translate(Metadata source, Metadata dest) {
        this.translate(source, source.getAll(), dest);
    }

    @Override
    public void translate(Metadata source, List<ImageMetadata> sourceImgMeta, Metadata dest) {
        Metadata trueSource = SCIFIOMetadataTools.unwrapMetadata(source);
        Object typedSource = SCIFIOMetadataTools.castMeta(trueSource);
        Object typedDest = SCIFIOMetadataTools.castMeta(dest);
        this.typedTranslate(typedSource, sourceImgMeta, typedDest);
    }

    protected void typedTranslate(M typedSource, List<ImageMetadata> sourceImgMeta, N typedDest) {
        typedDest.setFiltered(typedSource.isFiltered());
        typedDest.setDatasetName(typedSource.getDatasetName());
        for (ImageMetadata imageMeta : sourceImgMeta) {
            typedDest.add(imageMeta.copy());
        }
        this.translateFormatMetadata(typedSource, typedDest);
        this.translateImageMetadata(sourceImgMeta, typedDest);
        typedDest.populateImageMetadata();
    }

    protected abstract void translateImageMetadata(List<ImageMetadata> var1, N var2);

    protected void translateFormatMetadata(M source, N dest) {
    }
}

