/*
 * Decompiled with CFR 0.152.
 */
package io.scif;

import io.scif.AbstractGroupable;
import io.scif.DataPlane;
import io.scif.FormatException;
import io.scif.Metadata;
import io.scif.Plane;
import io.scif.TypedMetadata;
import io.scif.TypedReader;
import io.scif.config.SCIFIOConfig;
import io.scif.util.FormatTools;
import io.scif.util.SCIFIOMetadataTools;
import java.io.IOException;
import net.imagej.axis.Axes;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.handle.DataHandleService;
import org.scijava.io.location.Location;
import org.scijava.plugin.Parameter;

public abstract class AbstractReader<M extends TypedMetadata, P extends DataPlane<?>>
extends AbstractGroupable
implements TypedReader<M, P> {
    @Parameter
    private DataHandleService handles;
    private M metadata;
    private boolean normalizeData;
    private String[] domains;
    private final Class<P> planeClass;

    public AbstractReader(Class<P> planeClass) {
        this.planeClass = planeClass;
    }

    protected abstract String[] createDomainArray();

    @Override
    public P openPlane(int imageIndex, long planeIndex) throws FormatException, IOException {
        return (P)this.openPlane(imageIndex, planeIndex, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, Interval bounds) throws FormatException, IOException {
        return (P)this.openPlane(imageIndex, planeIndex, bounds, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, Plane plane) throws FormatException, IOException {
        return (P)this.openPlane(imageIndex, planeIndex, (P)((DataPlane)this.castToTypedPlane(plane)));
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, Plane plane, Interval bounds) throws FormatException, IOException {
        return (P)this.openPlane(imageIndex, planeIndex, (P)((DataPlane)this.castToTypedPlane(plane)), bounds);
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, SCIFIOConfig config) throws FormatException, IOException {
        FinalInterval bounds = new FinalInterval(this.metadata.get(imageIndex).getAxesLengthsPlanar());
        return (P)this.openPlane(imageIndex, planeIndex, (Interval)bounds, config);
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
        DataPlane plane = null;
        try {
            plane = this.createPlane(bounds);
        }
        catch (IllegalArgumentException e) {
            throw new FormatException("Image plane too large. Only 2GB of data can be extracted at one time. You can workaround the problem by opening the plane in tiles; for further details, see: https://github.com/scifio/scifio-tutorials/blob/master/core/src/main/java/io/scif/tutorials/core/T1cReadingTilesGood.java", e);
        }
        return (P)this.openPlane(imageIndex, planeIndex, plane, bounds, config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, SCIFIOConfig config) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, (P)((DataPlane)this.castToTypedPlane(plane)), config);
    }

    @Override
    public Plane openPlane(int imageIndex, long planeIndex, Plane plane, Interval bounds, SCIFIOConfig config) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, (DataPlane)this.castToTypedPlane(plane), bounds, config);
    }

    @Override
    public Location getCurrentLocation() {
        return this.metadata == null ? null : this.metadata.getSourceLocation();
    }

    @Override
    public String[] getDomains() {
        if (this.domains == null) {
            this.domains = this.createDomainArray();
        }
        return this.domains;
    }

    @Override
    public DataHandle<Location> getHandle() {
        return this.metadata == null ? null : this.metadata.getSource();
    }

    @Override
    public long getOptimalTileWidth(int imageIndex) {
        return this.metadata.get(imageIndex).getAxisLength(Axes.X);
    }

    @Override
    public long getOptimalTileHeight(int imageIndex) {
        int bpp = FormatTools.getBytesPerPixel(this.metadata.get(imageIndex).getPixelType());
        long width = this.metadata.get(imageIndex).getAxisLength(Axes.X);
        long rgbcCount = this.metadata.get(imageIndex).getAxisLength(Axes.CHANNEL);
        long maxHeight = 0x100000L / (width * rgbcCount * (long)bpp);
        return Math.min(maxHeight, this.metadata.get(imageIndex).getAxisLength(Axes.Y));
    }

    @Override
    public void setMetadata(Metadata meta) throws IOException {
        this.setMetadata((M)((TypedMetadata)SCIFIOMetadataTools.castMeta(meta)));
    }

    @Override
    public M getMetadata() {
        return this.metadata;
    }

    @Override
    public void setNormalized(boolean normalize) {
        this.normalizeData = normalize;
    }

    @Override
    public boolean isNormalized() {
        return this.normalizeData;
    }

    @Override
    public boolean hasCompanionFiles() {
        return false;
    }

    @Override
    public void setSource(Location loc) throws IOException {
        this.setSource(loc, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public void setSource(DataHandle<Location> stream) throws IOException {
        this.setSource(stream, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public void setSource(Location loc, SCIFIOConfig config) throws IOException {
        if (this.getCurrentLocation() != null && this.getCurrentLocation().equals(loc)) {
            if (this.getHandle() != null) {
                this.getHandle().seek(0L);
            }
            return;
        }
        this.close();
        DataHandle stream = null;
        try {
            DataHandle dataHandle = stream = config.bufferedReadingEnabled() ? this.handles.readBuffer(loc) : (DataHandle)this.handles.create((Object)loc);
            if (stream == null) {
                this.setMetadata(this.getFormat().createParser().parse(loc, config));
            } else {
                this.setMetadata(this.getFormat().createParser().parse((DataHandle<Location>)stream, config));
                this.setSource((DataHandle<Location>)stream);
            }
        }
        catch (FormatException e) {
            if (stream != null) {
                stream.close();
            }
            throw new IOException(e);
        }
    }

    @Override
    public void setSource(DataHandle<Location> handle, SCIFIOConfig config) throws IOException {
        Location currentSource = this.getCurrentLocation();
        Location newSource = (Location)handle.get();
        if (!(this.metadata == null || currentSource != null && newSource != null && currentSource.equals(newSource))) {
            this.close();
        }
        if (this.metadata == null) {
            try {
                TypedMetadata meta = (TypedMetadata)this.getFormat().createParser().parse(handle, config);
                this.setMetadata((M)meta);
            }
            catch (FormatException e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    public Plane readPlane(DataHandle<Location> s, int imageIndex, Interval bounds, Plane plane) throws IOException {
        return this.readPlane(s, imageIndex, bounds, (P)((DataPlane)this.castToTypedPlane(plane)));
    }

    @Override
    public Plane readPlane(DataHandle<Location> s, int imageIndex, Interval bounds, int scanlinePad, Plane plane) throws IOException {
        return this.readPlane(s, imageIndex, bounds, scanlinePad, (P)((DataPlane)this.castToTypedPlane(plane)));
    }

    @Override
    public long getPlaneCount(int imageIndex) {
        return this.metadata.get(imageIndex).getPlaneCount();
    }

    @Override
    public int getImageCount() {
        return this.metadata.getImageCount();
    }

    public <T extends Plane> T castToTypedPlane(Plane plane) {
        if (!this.planeClass.isAssignableFrom(plane.getClass())) {
            throw new IllegalArgumentException("Incompatible plane types. Attempted to cast: " + plane.getClass() + " to: " + this.planeClass);
        }
        Plane p = plane;
        return (T)p;
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, P plane) throws FormatException, IOException {
        return this.openPlane(imageIndex, planeIndex, plane, new SCIFIOConfig(this.getContext()));
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, P plane, SCIFIOConfig config) throws FormatException, IOException {
        return (P)this.openPlane(imageIndex, planeIndex, (DataPlane)plane, plane.getBounds(), config);
    }

    @Override
    public P openPlane(int imageIndex, long planeIndex, P plane, Interval bounds) throws FormatException, IOException {
        return (P)this.openPlane(imageIndex, planeIndex, (DataPlane)plane, plane.getBounds(), new SCIFIOConfig(this.getContext()));
    }

    @Override
    public void setMetadata(M meta) throws IOException {
        if (this.metadata != null && this.metadata != meta) {
            this.close();
        }
        if (this.metadata == null) {
            this.metadata = meta;
        }
    }

    @Override
    public P readPlane(DataHandle<Location> s, int imageIndex, Interval bounds, P plane) throws IOException {
        return this.readPlane(s, imageIndex, bounds, 0, plane);
    }

    @Override
    public P readPlane(DataHandle<Location> s, int imageIndex, Interval bounds, int scanlinePad, P plane) throws IOException {
        int bpp = FormatTools.getBytesPerPixel(this.metadata.get(imageIndex).getPixelType());
        byte[] bytes = plane.getBytes();
        int xIndex = this.metadata.get(imageIndex).getAxisIndex(Axes.X);
        int yIndex = this.metadata.get(imageIndex).getAxisIndex(Axes.Y);
        if (SCIFIOMetadataTools.wholePlane(imageIndex, this.metadata, bounds) && scanlinePad == 0) {
            s.read(bytes);
        } else if (SCIFIOMetadataTools.wholeRow(imageIndex, this.metadata, bounds) && scanlinePad == 0) {
            if (this.metadata.get(imageIndex).getInterleavedAxisCount() > 0) {
                int bytesToSkip = bpp;
                int bytesToRead = bytesToSkip = (int)((long)bytesToSkip * bounds.max(xIndex));
                for (int i = 0; i < bounds.numDimensions(); ++i) {
                    if (i == xIndex) continue;
                    bytesToSkip = i == yIndex ? (int)((long)bytesToSkip * bounds.min(i)) : (int)((long)bytesToSkip * bounds.max(i));
                    bytesToRead = (int)((long)bytesToRead * bounds.max(i));
                }
                s.skip((long)bytesToSkip);
                s.read(bytes, 0, bytesToRead);
            } else {
                int rowLen = (int)((long)bpp * bounds.max(xIndex));
                int h = (int)bounds.max(yIndex);
                int y = (int)bounds.min(yIndex);
                long c = this.metadata.get(imageIndex).getAxisLength(Axes.CHANNEL);
                if (c <= 0L || !this.metadata.get(imageIndex).isMultichannel()) {
                    c = 1L;
                }
                int channel = 0;
                while ((long)channel < c) {
                    s.skipBytes(y * rowLen);
                    s.read(bytes, channel * h * rowLen, h * rowLen);
                    if ((long)channel < c - 1L) {
                        s.skipBytes((int)(this.metadata.get(imageIndex).getAxisLength(Axes.Y) - (long)y - (long)h) * rowLen);
                    }
                    ++channel;
                }
            }
        } else {
            int scanlineWidth = (int)this.metadata.get(imageIndex).getAxisLength(Axes.X) + scanlinePad;
            if (this.metadata.get(imageIndex).getInterleavedAxisCount() > 0) {
                long planeProduct = bpp;
                for (int i = 0; i < bounds.numDimensions(); ++i) {
                    if (i == xIndex || i == yIndex) continue;
                    planeProduct *= this.metadata.get(imageIndex).getAxisLength(i);
                }
                int bytesToSkip = scanlineWidth * (int)planeProduct;
                s.skipBytes((int)bounds.min(yIndex) * bytesToSkip);
                int bytesToRead = bytesToSkip = bpp;
                bytesToRead = (int)((long)bytesToRead * bounds.max(xIndex));
                bytesToRead = (int)((long)bytesToRead * planeProduct);
                bytesToSkip = (int)((long)bytesToSkip * bounds.min(xIndex));
                bytesToSkip = (int)((long)bytesToSkip * planeProduct);
                int row = 0;
                while ((long)row <= bounds.max(yIndex)) {
                    s.skipBytes(bytesToSkip);
                    s.read(bytes, row * bytesToRead, bytesToRead);
                    if ((long)row < bounds.max(yIndex)) {
                        s.skipBytes((int)(planeProduct * ((long)scanlineWidth - bounds.dimension(xIndex))));
                    }
                    ++row;
                }
            } else {
                long c = this.metadata.get(imageIndex).getAxisLength(Axes.CHANNEL);
                int w = (int)bounds.max(xIndex);
                int h = (int)bounds.max(yIndex);
                int x = (int)bounds.min(xIndex);
                int y = (int)bounds.min(yIndex);
                int channel = 0;
                while ((long)channel < c) {
                    s.skipBytes(y * scanlineWidth * bpp);
                    for (int row = 0; row < h; ++row) {
                        s.skipBytes(x * bpp);
                        s.read(bytes, channel * w * h * bpp + row * w * bpp, w * bpp);
                        if (row >= h - 1 && (long)channel >= c - 1L) continue;
                        s.skipBytes(bpp * (scanlineWidth - w - x));
                    }
                    if ((long)channel < c - 1L) {
                        s.skipBytes(scanlineWidth * bpp * (int)(this.metadata.get(imageIndex).getAxisLength(Axes.Y) - (long)y - (long)h));
                    }
                    ++channel;
                }
            }
        }
        return plane;
    }

    @Override
    public Class<P> getPlaneClass() {
        return this.planeClass;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        if (this.metadata != null) {
            this.metadata.close(fileOnly);
        }
        if (!fileOnly) {
            this.metadata = null;
        }
    }
}

