/*
 * Decompiled with CFR 0.152.
 */
package fiji.util;

import fiji.util.node.Leaf;
import fiji.util.node.Node;
import fiji.util.node.NonLeaf;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;

public class KDTree<T extends Leaf<T>> {
    protected final int medianLength;
    protected final int dimension;
    protected final Node<T> root;
    public static boolean debug = false;
    protected ArrayList<T> duplicates = new ArrayList();

    public KDTree(List<T> leaves) {
        this(leaves, 100000);
    }

    public KDTree(List<T> leaves, int maxMedianLength) {
        this.medianLength = maxMedianLength;
        this.dimension = ((Leaf)leaves.get(0)).getNumDimensions();
        int i = 0;
        for (Leaf leaf : leaves) {
            if (leaf.getNumDimensions() != this.dimension) {
                throw new RuntimeException("Dimensionality of nodes is not preserved, first entry has dimensionality " + this.dimension + " entry " + i + " has dimensionality " + leaf.getNumDimensions());
            }
            ++i;
        }
        this.root = this.makeNode(leaves, 0);
    }

    protected Node<T> makeNode(List<T> leaves, int depth) {
        Leaf leaf;
        int i;
        int length = leaves.size();
        if (length == 0) {
            return null;
        }
        if (length == 1) {
            return (Node)leaves.get(0);
        }
        int k = depth % this.dimension;
        float median = this.median(leaves, k);
        ArrayList<Leaf> left = new ArrayList<Leaf>();
        ArrayList<Leaf> right = new ArrayList<Leaf>();
        for (i = 0; i < length; ++i) {
            leaf = (Leaf)leaves.get(i);
            if (leaf.get(k) <= median) {
                left.add(leaf);
                continue;
            }
            right.add(leaf);
        }
        if (right.size() == 0) {
            if (this.allIdentical(left)) {
                Leaf result = (Leaf)leaves.get(0);
                left.remove(0);
                this.duplicates.addAll(left);
                return result;
            }
            left.clear();
            right.clear();
            for (i = 0; i < length; ++i) {
                leaf = (Leaf)leaves.get(i);
                if (leaf.get(k) < median) {
                    left.add(leaf);
                    continue;
                }
                right.add(leaf);
            }
        }
        return new NonLeaf(median, this.dimension, this.makeNode(left, depth + 1), this.makeNode(right, depth + 1));
    }

    protected boolean allIdentical(List<T> list) {
        Leaf first = null;
        for (Leaf leaf : list) {
            if (first == null) {
                first = leaf;
                continue;
            }
            Leaf next = leaf;
            for (int j = 0; j < this.dimension; ++j) {
                if (next.get(j) == first.get(j)) continue;
                return false;
            }
        }
        return true;
    }

    public ArrayList<T> getDuplicates() {
        return this.duplicates;
    }

    public boolean hasDuplicates() {
        return this.duplicates.size() > 0;
    }

    protected float median(List<T> leaves, int k) {
        float[] list;
        if (leaves.size() <= this.medianLength) {
            list = new float[leaves.size()];
            for (int i = 0; i < list.length; ++i) {
                Leaf leaf = (Leaf)leaves.get(i);
                list[i] = leaf.get(k);
            }
        } else {
            list = new float[this.medianLength];
            Random random = new Random();
            for (int i = 0; i < list.length; ++i) {
                int index = Math.abs(random.nextInt()) % list.length;
                Leaf leaf = (Leaf)leaves.get(index);
                list[i] = leaf.get(k);
            }
        }
        Arrays.sort(list);
        return (list.length & 1) == 1 ? list[list.length / 2] : (list[list.length / 2] + list[list.length / 2 - 1]) / 2.0f;
    }

    public Node<T> getRoot() {
        return this.root;
    }

    public int getDimension() {
        return this.dimension;
    }

    public String toString(Node<T> node, String indent) {
        if (node == null) {
            return indent + "null";
        }
        if (node instanceof Leaf) {
            return indent + node.toString();
        }
        NonLeaf nonLeaf = (NonLeaf)node;
        return this.toString(nonLeaf.left, indent + "\t") + "\n" + indent + nonLeaf.coordinate + "\n" + this.toString(nonLeaf.right, indent + "\t") + "\n";
    }

    public String toString() {
        return this.toString(this.root, "");
    }
}

