/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.ij.clahe;

import ij.IJ;
import ij.ImagePlus;
import ij.Undo;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.process.ByteProcessor;
import java.util.ArrayList;
import mpicbg.ij.clahe.Flat;

public class PlugIn
implements ij.plugin.PlugIn {
    private static int blockRadius = 63;
    private static int bins = 255;
    private static float slope = 3.0f;
    private static ByteProcessor mask = null;
    private static boolean fast = true;
    private static boolean composite = true;

    private static final boolean setup(ImagePlus imp) {
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ArrayList<String> titles = new ArrayList<String>();
        titles.add("*None*");
        ids.add(-1);
        for (int id : WindowManager.getIDList()) {
            ImagePlus impId = WindowManager.getImage((int)id);
            if (impId.getWidth() != imp.getWidth() || impId.getHeight() != imp.getHeight()) continue;
            titles.add(impId.getTitle());
            ids.add(id);
        }
        GenericDialog gd = new GenericDialog("CLAHE");
        gd.addNumericField("blocksize : ", (double)(blockRadius * 2 + 1), 0);
        gd.addNumericField("histogram bins : ", (double)(bins + 1), 0);
        gd.addNumericField("maximum slope : ", (double)slope, 2);
        gd.addChoice("mask : ", titles.toArray(new String[0]), (String)titles.get(0));
        gd.addCheckbox("fast_(less_accurate)", fast);
        if (imp.getNChannels() > 1) {
            gd.addCheckbox("process_as_composite", composite);
        }
        gd.addHelp("http://pacific.mpi-cbg.de/wiki/index.php/Enhance_Local_Contrast_(CLAHE)");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        blockRadius = ((int)gd.getNextNumber() - 1) / 2;
        bins = (int)gd.getNextNumber() - 1;
        slope = (float)gd.getNextNumber();
        int maskId = (Integer)ids.get(gd.getNextChoiceIndex());
        mask = maskId != -1 ? (ByteProcessor)WindowManager.getImage((int)maskId).getProcessor().convertToByte(true) : null;
        fast = gd.getNextBoolean();
        if (imp.isComposite()) {
            composite = gd.getNextBoolean();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(String arg) {
        ImagePlus imp;
        ImagePlus imagePlus = imp = IJ.getImage();
        synchronized (imagePlus) {
            if (imp.isLocked()) {
                IJ.error((String)("The image '" + imp.getTitle() + "' is in use currently.\nPlease wait until the process is done and try again."));
                return;
            }
            imp.lock();
        }
        if (!PlugIn.setup(imp)) {
            imp.unlock();
            return;
        }
        Undo.setup((int)6, (ImagePlus)imp);
        PlugIn.run(imp);
        imp.unlock();
    }

    public static final void run(ImagePlus imp) {
        if (fast) {
            Flat.getFastInstance().run(imp, blockRadius, bins, slope, mask, composite);
        } else {
            Flat.getInstance().run(imp, blockRadius, bins, slope, mask, composite);
        }
    }
}

