/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.overlay;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import net.imagej.axis.Axes;
import net.imagej.axis.DefaultLinearAxis;
import net.imagej.overlay.AbstractROIOverlay;
import net.imglib2.roi.GeneralPathRegionOfInterest;
import net.imglib2.roi.GeneralPathSegmentHandler;
import org.scijava.Context;

public class GeneralPathOverlay
extends AbstractROIOverlay<GeneralPathRegionOfInterest> {
    private static final long serialVersionUID = 1L;

    public GeneralPathOverlay(Context context) {
        super(context, new GeneralPathRegionOfInterest());
        this.setAxis(new DefaultLinearAxis(Axes.X), 0);
        this.setAxis(new DefaultLinearAxis(Axes.Y), 1);
    }

    @Override
    public void setRegionOfInterest(GeneralPathRegionOfInterest roi) {
        super.setRegionOfInterest(roi);
    }

    @Override
    public void writeExternal(final ObjectOutput out) throws IOException {
        super.writeExternal(out);
        GeneralPathRegionOfInterest roi = (GeneralPathRegionOfInterest)this.getRegionOfInterest();
        try {
            roi.iteratePath(new GeneralPathSegmentHandler(){

                public void moveTo(double x, double y) {
                    try {
                        out.writeChar(77);
                        out.writeDouble(x);
                        out.writeDouble(y);
                    }
                    catch (IOException e) {
                        throw new WrappedIOException(e);
                    }
                }

                public void lineTo(double x, double y) {
                    try {
                        out.writeChar(76);
                        out.writeDouble(x);
                        out.writeDouble(y);
                    }
                    catch (IOException e) {
                        throw new WrappedIOException(e);
                    }
                }

                public void quadTo(double x1, double y1, double x, double y) {
                    try {
                        out.writeChar(81);
                        out.writeDouble(x1);
                        out.writeDouble(y1);
                        out.writeDouble(x);
                        out.writeDouble(y);
                    }
                    catch (IOException e) {
                        throw new WrappedIOException(e);
                    }
                }

                public void cubicTo(double x1, double y1, double x2, double y2, double x, double y) {
                    try {
                        out.writeChar(67);
                        out.writeDouble(x1);
                        out.writeDouble(y1);
                        out.writeDouble(x2);
                        out.writeDouble(y2);
                        out.writeDouble(x);
                        out.writeDouble(y);
                    }
                    catch (IOException e) {
                        throw new WrappedIOException(e);
                    }
                }

                public void close() {
                    try {
                        out.writeChar(41);
                    }
                    catch (IOException e) {
                        throw new WrappedIOException(e);
                    }
                }
            });
        }
        catch (WrappedIOException e) {
            throw e.getIOException();
        }
        out.writeChar(46);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        GeneralPathRegionOfInterest roi = (GeneralPathRegionOfInterest)this.getRegionOfInterest();
        roi.reset();
        while (true) {
            char type = in.readChar();
            switch (type) {
                case 'M': {
                    roi.moveTo(in.readDouble(), in.readDouble());
                    break;
                }
                case 'L': {
                    roi.lineTo(in.readDouble(), in.readDouble());
                    break;
                }
                case 'Q': {
                    roi.quadTo(in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble());
                    break;
                }
                case 'C': {
                    roi.cubicTo(in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble(), in.readDouble());
                    break;
                }
                case ')': {
                    roi.close();
                    break;
                }
            }
        }
    }

    @Override
    public void move(double[] deltas) {
        throw new RuntimeException("TODO");
    }

    private class WrappedIOException
    extends RuntimeException {
        final IOException ioException;

        public WrappedIOException(IOException exception) {
            this.ioException = exception;
        }

        public IOException getIOException() {
            return this.ioException;
        }
    }
}

