/*
 * Decompiled with CFR 0.152.
 */
package net.imagej.lut;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import net.imagej.display.ColorTables;
import net.imagej.display.ImageDisplay;
import net.imagej.lut.ApplyLookupTable;
import net.imagej.lut.LUTService;
import net.imglib2.display.ColorTable;
import org.scijava.command.Command;
import org.scijava.command.CommandService;
import org.scijava.command.DynamicCommand;
import org.scijava.module.Module;
import org.scijava.module.MutableModuleItem;
import org.scijava.plugin.Attr;
import org.scijava.plugin.Menu;
import org.scijava.plugin.Parameter;
import org.scijava.plugin.Plugin;

@Plugin(type=Command.class, label="LUT Selector", initializer="init", menu={@Menu(label="Image", weight=2.0, mnemonic=105), @Menu(label="Lookup Tables", mnemonic=108), @Menu(label="Select...", weight=0.0, mnemonic=115)}, attrs={@Attr(name="no-legacy")})
public class LUTSelector
extends DynamicCommand {
    @Parameter
    private LUTService lutService;
    @Parameter
    private CommandService cmdService;
    @Parameter(required=false)
    private ImageDisplay display;
    @Parameter(label="LUT name", persist=false, callback="nameChanged")
    private String choice = "Gray";
    @Parameter(required=false, label="LUT", persist=false)
    private ColorTable table = ColorTables.GRAYS;
    private Map<String, URL> luts = null;

    public void run() {
        if (this.display != null) {
            this.cmdService.run(ApplyLookupTable.class, true, new Object[]{"display", this.display, "tableURL", this.luts.get(this.choice)});
        }
    }

    protected void init() {
        this.luts = this.lutService.findLUTs();
        ArrayList<String> choices = new ArrayList<String>();
        for (Map.Entry<String, URL> entry : this.luts.entrySet()) {
            choices.add(entry.getKey());
        }
        Collections.sort(choices);
        MutableModuleItem input = this.getInfo().getMutableInput("choice", String.class);
        input.setChoices(choices);
        input.setValue((Module)this, choices.get(0));
        this.nameChanged();
    }

    protected void nameChanged() {
        try {
            this.table = this.lutService.loadLUT(this.luts.get(this.choice));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

