/*
 * Decompiled with CFR 0.152.
 */
package net.imagej;

import java.util.Optional;
import net.imagej.Data;
import net.imagej.DatasetFactory;
import net.imagej.ImgPlus;
import net.imagej.ImgPlusMetadata;
import net.imagej.axis.Axes;
import net.imagej.axis.AxisType;
import net.imagej.axis.CalibratedAxis;
import net.imglib2.img.Img;
import net.imglib2.type.numeric.RealType;

public interface Dataset
extends Data,
ImgPlusMetadata,
Img<RealType<?>> {
    public boolean isDirty();

    public void setDirty(boolean var1);

    public ImgPlus<? extends RealType<?>> getImgPlus();

    default public <T extends RealType<T>> ImgPlus<T> typedImg(T t) {
        ImgPlus<RealType<?>> img = this.getImgPlus();
        if (t.getClass().isAssignableFrom(img.firstElement().getClass())) {
            ImgPlus<RealType<?>> typedImg = img;
            return typedImg;
        }
        return null;
    }

    public void setImgPlus(ImgPlus<? extends RealType<?>> var1);

    public Object getPlane(int var1);

    public Object getPlane(int var1, boolean var2);

    public boolean setPlane(int var1, Object var2);

    public boolean setPlaneSilently(int var1, Object var2);

    public RealType<?> getType();

    public boolean isSigned();

    public boolean isInteger();

    public String getTypeLabelShort();

    public String getTypeLabelLong();

    public Dataset duplicate();

    public Dataset duplicateBlank();

    public void copyInto(Dataset var1);

    public void setRGBMerged(boolean var1);

    public boolean isRGBMerged();

    public void typeChange();

    public void rgbChange();

    public void copyDataFrom(Dataset var1);

    public double getBytesOfInfo();

    public void setAxes(CalibratedAxis[] var1);

    default public long getWidth() {
        return this.dimension(Axes.X);
    }

    default public long getHeight() {
        return this.dimension(Axes.Y);
    }

    default public long getDepth() {
        return this.dimension(Axes.Z);
    }

    default public long getFrames() {
        return this.dimension(Axes.TIME);
    }

    default public long getChannels() {
        return this.dimension(Axes.CHANNEL);
    }

    default public long dimension(AxisType type) {
        int index = this.dimensionIndex(type);
        return index < 0 ? 1L : this.dimension(index);
    }

    default public Optional<CalibratedAxis> axis(AxisType type) {
        int index = this.dimensionIndex(type);
        return index < 0 ? Optional.empty() : Optional.of(this.axis(index));
    }

    @Override
    public void update();

    @Override
    public void rebuild();

    public Dataset copy();

    public DatasetFactory factory();
}

