/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.models;

import java.awt.Shape;
import java.awt.geom.GeneralPath;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import mpicbg.models.AffineModel2D;
import mpicbg.models.CoordinateTransform;
import mpicbg.models.IllDefinedDataPointsException;
import mpicbg.models.InvertibleCoordinateTransform;
import mpicbg.models.NoninvertibleModelException;
import mpicbg.models.NotEnoughDataPointsException;
import mpicbg.models.Point;
import mpicbg.models.PointFactory;
import mpicbg.models.PointMatch;
import mpicbg.models.PointMatchFactory;
import mpicbg.models.RigidModel2D;
import mpicbg.util.Util;

public class TransformMesh
implements InvertibleCoordinateTransform {
    private static final long serialVersionUID = 2557331683355356863L;
    protected final double width;
    protected final double height;
    protected final HashMap<AffineModel2D, ArrayList<PointMatch>> av = new HashMap();
    protected final HashMap<PointMatch, ArrayList<AffineModel2D>> va = new HashMap();
    protected static final PointFactory<Point> defaultPointFactory = new PointFactory<Point>(){
        private static final long serialVersionUID = -8338916724246569904L;

        @Override
        public final Point createPoint(double[] l) {
            return new Point(l);
        }
    };
    protected static final PointMatchFactory<PointMatch> defaultPointMatchFactory = new PointMatchFactory<PointMatch>(){
        private static final long serialVersionUID = -3034111068615619105L;

        @Override
        public final PointMatch createPointMatch(Point p1, Point p2) {
            return new PointMatch(p1, p2);
        }

        @Override
        public final PointMatch createPointMatch(Point p1, Point p2, double w) {
            return new PointMatch(p1, p2, w);
        }
    };

    public double getWidth() {
        return this.width;
    }

    public double getHeight() {
        return this.height;
    }

    public HashMap<AffineModel2D, ArrayList<PointMatch>> getAV() {
        return this.av;
    }

    public HashMap<PointMatch, ArrayList<AffineModel2D>> getVA() {
        return this.va;
    }

    protected TransformMesh(int numX, int numY, double width, double height, PointFactory<?> pointFactory, PointMatchFactory<?> pointMatchFactory) {
        int numXs = Math.max(2, numX);
        int numYs = Math.max(2, numY);
        double w = width * height / (double)numXs / (double)numYs;
        PointMatch[] pq = new PointMatch[numXs * numYs + (numXs - 1) * (numYs - 1)];
        this.width = width;
        this.height = height;
        double dy = (height - 1.0) / (double)(numYs - 1);
        double dx = (width - 1.0) / (double)(numXs - 1);
        int i = 0;
        for (int xi = 0; xi < numXs; ++xi) {
            double xip = (double)xi * dx;
            Object p = pointFactory.createPoint(new double[]{xip, 0.0});
            pq[i] = pointMatchFactory.createPointMatch((Point)p, ((Point)p).clone(), w);
            ++i;
        }
        for (int yi = 1; yi < numYs; ++yi) {
            int i3;
            ArrayList<PointMatch> t2;
            double xip;
            int xi;
            double yip = (double)yi * dy - dy / 2.0;
            Object p = pointFactory.createPoint(new double[]{dx - dx / 2.0, yip});
            pq[i] = pointMatchFactory.createPointMatch((Point)p, ((Point)p).clone(), w);
            int i1 = i - numXs;
            int i2 = i1 + 1;
            ArrayList<PointMatch> t1 = new ArrayList<PointMatch>();
            t1.add(pq[i1]);
            t1.add(pq[i2]);
            t1.add(pq[i]);
            this.addTriangle(t1);
            ++i;
            for (xi = 2; xi < numXs; ++xi) {
                xip = (double)xi * dx - dx / 2.0;
                p = pointFactory.createPoint(new double[]{xip, yip});
                pq[i] = pointMatchFactory.createPointMatch((Point)p, ((Point)p).clone(), w);
                i1 = i - numXs;
                i2 = i1 + 1;
                int i32 = i - 1;
                t1 = new ArrayList();
                t1.add(pq[i1]);
                t1.add(pq[i2]);
                t1.add(pq[i]);
                this.addTriangle(t1);
                t2 = new ArrayList<PointMatch>();
                t2.add(pq[i1]);
                t2.add(pq[i]);
                t2.add(pq[i32]);
                this.addTriangle(t2);
                ++i;
            }
            yip = (double)yi * dy;
            p = pointFactory.createPoint(new double[]{0.0, yip});
            pq[i] = pointMatchFactory.createPointMatch((Point)p, ((Point)p).clone(), w);
            i1 = i - numXs + 1;
            i2 = i1 - numXs;
            t1 = new ArrayList();
            t1.add(pq[i2]);
            t1.add(pq[i1]);
            t1.add(pq[i]);
            this.addTriangle(t1);
            ++i;
            for (xi = 1; xi < numXs - 1; ++xi) {
                xip = (double)xi * dx;
                p = pointFactory.createPoint(new double[]{xip, yip});
                pq[i] = pointMatchFactory.createPointMatch((Point)p, ((Point)p).clone(), w);
                i1 = i - numXs;
                i2 = i1 + 1;
                i3 = i - 1;
                t1 = new ArrayList();
                t1.add(pq[i1]);
                t1.add(pq[i]);
                t1.add(pq[i3]);
                this.addTriangle(t1);
                t2 = new ArrayList();
                t2.add(pq[i1]);
                t2.add(pq[i2]);
                t2.add(pq[i]);
                this.addTriangle(t2);
                ++i;
            }
            p = pointFactory.createPoint(new double[]{width - 1.0, yip});
            pq[i] = pointMatchFactory.createPointMatch((Point)p, ((Point)p).clone(), w);
            i1 = i - numXs;
            i2 = i1 - numXs + 1;
            i3 = i - 1;
            t1 = new ArrayList();
            t1.add(pq[i3]);
            t1.add(pq[i1]);
            t1.add(pq[i]);
            this.addTriangle(t1);
            t2 = new ArrayList();
            t2.add(pq[i1]);
            t2.add(pq[i2]);
            t2.add(pq[i]);
            this.addTriangle(t2);
            ++i;
        }
    }

    public TransformMesh(int numX, int numY, double width, double height) {
        this(numX, numY, width, height, defaultPointFactory, defaultPointMatchFactory);
    }

    protected static final int numY(int numX, double width, double height) {
        int numXs = Math.max(2, numX);
        double dx = width / (double)(numXs - 1);
        double dy = 2.0 * Math.sqrt(0.75 * dx * dx);
        return Math.max(2, Util.roundPos(height / dy) + 1);
    }

    public TransformMesh(int numX, double width, double height) {
        this(numX, TransformMesh.numY(numX, width, height), width, height);
    }

    public void addTriangle(ArrayList<PointMatch> t) {
        AffineModel2D m = new AffineModel2D();
        try {
            m.fit(t);
        }
        catch (NotEnoughDataPointsException e) {
            e.printStackTrace();
        }
        catch (IllDefinedDataPointsException e) {
            e.printStackTrace();
        }
        this.av.put(m, t);
        for (PointMatch pm : t) {
            if (!this.va.containsKey(pm)) {
                this.va.put(pm, new ArrayList());
            }
            this.va.get(pm).add(m);
        }
    }

    protected void illustrateTriangle(AffineModel2D ai, GeneralPath path) {
        ArrayList<PointMatch> m = this.av.get(ai);
        double[] w = m.get(0).getP2().getW();
        path.moveTo(w[0], w[1]);
        for (int i = 1; i < m.size(); ++i) {
            double[] wi = m.get(i).getP2().getW();
            path.lineTo(wi[0], wi[1]);
        }
        path.closePath();
    }

    public Shape illustrateMesh() {
        GeneralPath path = new GeneralPath();
        Set<AffineModel2D> s = this.av.keySet();
        for (AffineModel2D ai : s) {
            this.illustrateTriangle(ai, path);
        }
        return path;
    }

    private String illustrateTriangleSVG(AffineModel2D ai) {
        String svg = "";
        ArrayList<PointMatch> m = this.av.get(ai);
        double[] w = m.get(0).getP2().getW();
        svg = svg + "M " + w[0] + " " + w[1] + " ";
        for (int i = 1; i < m.size(); ++i) {
            double[] wi = m.get(i).getP2().getW();
            svg = svg + "L " + wi[0] + " " + wi[1] + " ";
        }
        svg = svg + "Z ";
        return svg;
    }

    public String illustrateMeshSVG() {
        String svg = "<path style=\"fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" d=\"";
        Set<AffineModel2D> s = this.av.keySet();
        for (AffineModel2D ai : s) {
            svg = svg + this.illustrateTriangleSVG(ai);
        }
        svg = svg + "\" />";
        return svg;
    }

    public String illustrateBestRigidSVG() {
        String svg = "<path style=\"fill:none;fill-rule:evenodd;stroke:#000000;stroke-width:1px;stroke-linecap:butt;stroke-linejoin:miter;stroke-opacity:1\" d=\"";
        Set<PointMatch> s = this.va.keySet();
        RigidModel2D m = new RigidModel2D();
        try {
            m.fit(s);
        }
        catch (NotEnoughDataPointsException ex) {
            ex.printStackTrace();
            return "";
        }
        double[] l = new double[]{0.0, 0.0};
        m.applyInPlace(l);
        svg = svg + "M " + l[0] + " " + l[1] + " ";
        l[0] = this.width;
        l[1] = 0.0;
        m.applyInPlace(l);
        svg = svg + "L " + l[0] + " " + l[1] + " ";
        l[0] = this.width;
        l[1] = this.height;
        m.applyInPlace(l);
        svg = svg + "L " + l[0] + " " + l[1] + " ";
        l[0] = 0.0;
        l[1] = this.height;
        m.applyInPlace(l);
        svg = svg + "L " + l[0] + " " + l[1] + " ";
        svg = svg + "Z";
        svg = svg + "\" />";
        return svg;
    }

    public void updateAffine(PointMatch p) {
        for (AffineModel2D ai : this.va.get(p)) {
            try {
                ai.fit((Collection)this.av.get(ai));
            }
            catch (NotEnoughDataPointsException e) {
                e.printStackTrace();
            }
            catch (IllDefinedDataPointsException e) {
                e.printStackTrace();
            }
        }
    }

    public void updateAffines() {
        Set<AffineModel2D> s = this.av.keySet();
        for (AffineModel2D ai : s) {
            try {
                ai.fit((Collection)this.av.get(ai));
            }
            catch (NotEnoughDataPointsException e) {
                e.printStackTrace();
            }
            catch (IllDefinedDataPointsException e) {
                e.printStackTrace();
            }
        }
    }

    public PointMatch findClosestSourcePoint(double[] there) {
        Set<PointMatch> points = this.va.keySet();
        PointMatch closest = null;
        double cd = Double.MAX_VALUE;
        for (PointMatch m : points) {
            double dy;
            double[] here = m.getP1().getL();
            double dx = here[0] - there[0];
            double d = dx * dx + (dy = here[1] - there[1]) * dy;
            if (!(d < cd)) continue;
            cd = d;
            closest = m;
        }
        return closest;
    }

    public PointMatch findClosestTargetPoint(double[] there) {
        Set<PointMatch> points = this.va.keySet();
        PointMatch closest = null;
        double cd = Double.MAX_VALUE;
        for (PointMatch m : points) {
            double dy;
            double[] here = m.getP2().getW();
            double dx = here[0] - there[0];
            double d = dx * dx + (dy = here[1] - there[1]) * dy;
            if (!(d < cd)) continue;
            cd = d;
            closest = m;
        }
        return closest;
    }

    public static boolean isInConvexTargetPolygon(ArrayList<PointMatch> pm, double[] t) {
        assert (t.length == 2) : "2d transform meshs can be applied to 2d points only.";
        for (int i = 0; i < pm.size(); ++i) {
            double x2;
            double y1;
            double y2;
            PointMatch r1 = pm.get(i);
            PointMatch r2 = pm.get((i + 1) % pm.size());
            double[] t1 = r1.getP2().getW();
            double[] t2 = r2.getP2().getW();
            double x1 = t2[0] - t1[0];
            if (!(x1 * (y2 = t[1] - t1[1]) - (y1 = t2[1] - t1[1]) * (x2 = t[0] - t1[0]) < 0.0)) continue;
            return false;
        }
        return true;
    }

    public static final boolean isInSourcePolygon(ArrayList<PointMatch> pm, double[] t) {
        assert (t.length == 2) : "2d transform meshs can be applied to 2d points only.";
        for (int i = 0; i < pm.size(); ++i) {
            double x2;
            double y1;
            double y2;
            PointMatch r1 = pm.get(i);
            PointMatch r2 = pm.get((i + 1) % pm.size());
            double[] t1 = r1.getP1().getL();
            double[] t2 = r2.getP1().getL();
            double x1 = t2[0] - t1[0];
            if (!(x1 * (y2 = t[1] - t1[1]) - (y1 = t2[1] - t1[1]) * (x2 = t[0] - t1[0]) < 0.0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public double[] apply(double[] location) {
        assert (location.length == 2) : "2d transform meshs can be applied to 2d points only.";
        double[] transformed = (double[])location.clone();
        this.applyInPlace(transformed);
        return transformed;
    }

    @Override
    public void applyInPlace(double[] location) {
        assert (location.length == 2) : "2d transform meshs can be applied to 2d points only.";
        Set<AffineModel2D> s = this.av.keySet();
        for (AffineModel2D ai : s) {
            ArrayList<PointMatch> pm = this.av.get(ai);
            if (!TransformMesh.isInSourcePolygon(pm, location)) continue;
            ai.applyInPlace(location);
            return;
        }
    }

    @Override
    public double[] applyInverse(double[] location) throws NoninvertibleModelException {
        assert (location.length == 2) : "2d transform meshs can be applied to 2d points only.";
        double[] transformed = (double[])location.clone();
        this.applyInverseInPlace(transformed);
        return transformed;
    }

    @Override
    public void applyInverseInPlace(double[] location) throws NoninvertibleModelException {
        assert (location.length == 2) : "2d transform meshs can be applied to 2d points only.";
        Set<AffineModel2D> s = this.av.keySet();
        for (AffineModel2D ai : s) {
            ArrayList<PointMatch> pm = this.av.get(ai);
            if (!TransformMesh.isInConvexTargetPolygon(pm, location)) continue;
            ai.applyInverseInPlace(location);
            return;
        }
        throw new NoninvertibleModelException("Noninvertible location ( " + location[0] + ", " + location[1] + " )");
    }

    @Override
    public TransformMesh createInverse() {
        TransformMesh ict = new TransformMesh(0, 0, this.width, this.height);
        Set<PointMatch> v = this.va.keySet();
        HashMap<PointMatch, PointMatch> vv = new HashMap<PointMatch, PointMatch>();
        for (PointMatch pointMatch : v) {
            double[] l = pointMatch.getP1().getL();
            double[] w = pointMatch.getP2().getW();
            Point pi1 = new Point((double[])w.clone());
            Point pi2 = new Point((double[])w.clone());
            double[] pi2w = pi2.getW();
            for (int i = 0; i < pi2w.length; ++i) {
                pi2w[i] = l[i];
            }
            PointMatch pim = new PointMatch(pi1, pi2);
            vv.put(pointMatch, pim);
        }
        ict.va.clear();
        ict.av.clear();
        for (Map.Entry entry : vv.entrySet()) {
            ict.va.put((PointMatch)entry.getValue(), new ArrayList());
        }
        for (Map.Entry entry : this.av.entrySet()) {
            ArrayList<PointMatch> pm = new ArrayList<PointMatch>();
            AffineModel2D a = new AffineModel2D();
            for (PointMatch p : (ArrayList)entry.getValue()) {
                PointMatch q = (PointMatch)vv.get(p);
                this.va.get(q).add(a);
                pm.add(q);
            }
            ict.av.put(a, pm);
        }
        ict.updateAffines();
        return ict;
    }

    public void init(CoordinateTransform t) {
        Set<PointMatch> vertices = this.va.keySet();
        for (PointMatch vertex : vertices) {
            vertex.getP2().apply(t);
        }
        this.updateAffines();
    }

    public void scale(double scale) {
        for (PointMatch m : this.va.keySet()) {
            Point p1 = m.getP1();
            Point p2 = m.getP2();
            double[] l1 = p1.getL();
            double[] w1 = p1.getW();
            double[] l2 = p2.getL();
            double[] w2 = p2.getW();
            int i = 0;
            while (i < l1.length) {
                int n = i;
                l1[n] = l1[n] * scale;
                int n2 = i;
                w1[n2] = w1[n2] * scale;
                int n3 = i;
                l2[n3] = l2[n3] * scale;
                int n4 = i++;
                w2[n4] = w2[n4] * scale;
            }
            this.updateAffines();
        }
    }

    public void bounds(double[] min, double[] max) {
        min[1] = Double.MAX_VALUE;
        min[0] = Double.MAX_VALUE;
        max[1] = -1.7976931348623157E308;
        max[0] = -1.7976931348623157E308;
        Set<PointMatch> vertices = this.va.keySet();
        for (PointMatch vertex : vertices) {
            double[] w = vertex.getP2().getW();
            if (w[0] < min[0]) {
                min[0] = w[0];
            }
            if (w[0] > max[0]) {
                max[0] = w[0];
            }
            if (w[1] < min[1]) {
                min[1] = w[1];
            }
            if (!(w[1] > max[1])) continue;
            max[1] = w[1];
        }
    }
}

