/*
 * Decompiled with CFR 0.152.
 */
package org.perf4j;

import org.perf4j.StopWatch;

public class LoggingStopWatch
extends StopWatch {
    private long timeThreshold = 0L;
    private boolean normalAndSlowSuffixesEnabled = false;
    private String normalSuffix = ".normal";
    private String slowSuffix = ".slow";

    public LoggingStopWatch() {
    }

    public LoggingStopWatch(String tag) {
        super(tag);
    }

    public LoggingStopWatch(String tag, String message) {
        super(tag, message);
    }

    public LoggingStopWatch(long startTime, long elapsedTime, String tag, String message) {
        super(startTime, elapsedTime, tag, message);
    }

    public long getTimeThreshold() {
        return this.timeThreshold;
    }

    public LoggingStopWatch setTimeThreshold(long timeThreshold) {
        this.timeThreshold = timeThreshold;
        return this;
    }

    public boolean isNormalAndSlowSuffixesEnabled() {
        return this.normalAndSlowSuffixesEnabled;
    }

    public LoggingStopWatch setNormalAndSlowSuffixesEnabled(boolean normalAndSlowSuffixesEnabled) {
        this.normalAndSlowSuffixesEnabled = normalAndSlowSuffixesEnabled;
        return this;
    }

    public String getNormalSuffix() {
        return this.normalSuffix;
    }

    public LoggingStopWatch setNormalSuffix(String normalSuffix) {
        if (normalSuffix == null || "".equals(normalSuffix)) {
            throw new IllegalArgumentException("normalSuffix cannot be blank. param=" + normalSuffix);
        }
        this.normalSuffix = normalSuffix;
        return this;
    }

    public String getSlowSuffix() {
        return this.slowSuffix;
    }

    public LoggingStopWatch setSlowSuffix(String slowSuffix) {
        if (slowSuffix == null || "".equals(slowSuffix)) {
            throw new IllegalArgumentException("slowSuffix cannot be blank. param=" + slowSuffix);
        }
        this.slowSuffix = slowSuffix;
        return this;
    }

    public String getTag() {
        long timeThreshold = this.getTimeThreshold();
        return this.isNormalAndSlowSuffixesEnabled() ? super.getTag() + (this.getElapsedTime() >= timeThreshold ? this.getSlowSuffix() : this.getNormalSuffix()) : super.getTag();
    }

    public LoggingStopWatch setTag(String tag) {
        super.setTag(tag);
        return this;
    }

    public LoggingStopWatch setMessage(String message) {
        super.setMessage(message);
        return this;
    }

    public String stop() {
        String retVal = super.stop();
        this.doLogInternal(retVal, null);
        return retVal;
    }

    public String stop(Throwable exception) {
        String retVal = super.stop();
        this.doLogInternal(retVal, exception);
        return retVal;
    }

    public String stop(String tag, Throwable exception) {
        this.setTag(tag);
        return this.stop(exception);
    }

    public String stop(String tag, String message, Throwable exception) {
        this.setTag(tag);
        this.setMessage(message);
        return this.stop(exception);
    }

    public String lap(String tag, Throwable exception) {
        String retVal = this.stop(tag, exception);
        this.start();
        return retVal;
    }

    public String lap(String tag, String message, Throwable exception) {
        String retVal = this.stop(tag, message, exception);
        this.start();
        return retVal;
    }

    public boolean isLogging() {
        return true;
    }

    protected void log(String stopWatchAsString, Throwable exception) {
        System.err.println(stopWatchAsString);
        if (exception != null) {
            exception.printStackTrace();
        }
    }

    public LoggingStopWatch clone() {
        return (LoggingStopWatch)super.clone();
    }

    private void doLogInternal(String stopWatchAsString, Throwable exception) {
        long elapsedTime = this.getElapsedTime();
        long timeThreshold = this.getTimeThreshold();
        if (timeThreshold == 0L || this.isNormalAndSlowSuffixesEnabled() || elapsedTime >= timeThreshold) {
            this.log(stopWatchAsString, exception);
        }
    }
}

