/*
 * Decompiled with CFR 0.152.
 */
package org.jhotdraw.gui;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.MenuElement;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.jhotdraw.gui.VerticalGridLayout;
import org.jhotdraw.gui.plaf.palette.PaletteMenuItemUI;

public class JPopupButton
extends JButton {
    public static final String CLOSE_AUTOMATICALLY_PROPERTY = "closeAutomatically";
    public static final String COLUMN_COUNT_PROPERTY = "columnCount";
    public static final String ITEM_FONT_PROPERTY = "itemFont";
    private JPopupMenu popupMenu;
    private int columnCount = 1;
    private Action action;
    private Rectangle actionArea;
    private Font itemFont;
    public static final Font ITEM_FONT = new Font("Dialog", 0, 10);
    private int popupAnchor = 6;
    private long popupBecameInvisible;
    private boolean isCloseAutomatically;
    private Handler handler = new Handler();

    public JPopupButton() {
        this.initComponents();
        this.setFocusable(false);
        this.itemFont = ITEM_FONT;
    }

    public void setItemFont(Font newValue) {
        Font oldValue = this.itemFont;
        this.itemFont = newValue;
        if (this.popupMenu != null) {
            this.updateItemFont(this.popupMenu);
        }
        this.firePropertyChange(ITEM_FONT_PROPERTY, oldValue, newValue);
    }

    private void updateItemFont(MenuElement menu) {
        menu.getComponent().setFont(this.itemFont);
        for (MenuElement child : menu.getSubElements()) {
            this.updateItemFont(child);
        }
    }

    public void setAction(Action action, Rectangle actionClickArea) {
        if (this.action != null) {
            this.action.removePropertyChangeListener(this.handler);
        }
        this.action = action;
        this.actionArea = actionClickArea;
        if (action != null) {
            action.addPropertyChangeListener(this.handler);
        }
    }

    public int getColumnCount() {
        return this.columnCount;
    }

    public void setColumnCount(int newValue, boolean isVertical) {
        int oldValue = this.columnCount;
        this.columnCount = newValue;
        this.getPopupMenu().setLayout(new VerticalGridLayout(0, this.getColumnCount(), isVertical));
        this.firePropertyChange(COLUMN_COUNT_PROPERTY, oldValue, newValue);
    }

    public AbstractButton add(Action action) {
        JMenuItem item = this.getPopupMenu().add(action);
        if (this.getColumnCount() > 1) {
            item.setUI(new PaletteMenuItemUI());
        }
        item.setFont(this.itemFont);
        return item;
    }

    public void add(JMenu submenu) {
        this.updateItemFont(submenu);
    }

    public void add(JComponent submenu) {
        this.getPopupMenu().add(submenu);
    }

    public void add(JMenuItem item) {
        this.getPopupMenu().add(item);
        item.setFont(this.itemFont);
    }

    public void addSeparator() {
        this.getPopupMenu().addSeparator();
    }

    @Override
    public void removeAll() {
        this.getPopupMenu().removeAll();
    }

    public void setPopupMenu(JPopupMenu popupMenu) {
        if (this.popupMenu != null) {
            popupMenu.removePopupMenuListener(this.handler);
        }
        this.popupMenu = popupMenu;
        if (this.popupMenu != null) {
            popupMenu.addPopupMenuListener(this.handler);
        }
    }

    public JPopupMenu getPopupMenu() {
        if (this.popupMenu == null) {
            this.popupMenu = new JPopupMenu();
            this.popupMenu.setLayout(new VerticalGridLayout(0, this.getColumnCount()));
            this.popupMenu.addPopupMenuListener(this.handler);
            this.popupMenu.setLightWeightPopupEnabled(false);
        }
        return this.popupMenu;
    }

    public void setPopupAlpha(float newValue) {
        float oldValue = this.getPopupAlpha();
        this.getPopupMenu().putClientProperty("Quaqua.PopupMenu.windowAlpha", Float.valueOf(newValue));
        this.firePropertyChange("popupAlpha", oldValue, newValue);
    }

    public float getPopupAlpha() {
        Float value = (Float)this.getPopupMenu().getClientProperty("Quaqua.PopupMenu.windowAlpha");
        return value == null ? 0.948f : value.floatValue();
    }

    public int getPopupAnchor() {
        return this.popupAnchor;
    }

    public void setPopupAnchor(int newValue) {
        this.popupAnchor = newValue;
    }

    protected void togglePopup(MouseEvent evt) {
        if (this.popupMenu != null && this.popupMenu.isShowing() || this.popupBecameInvisible >= evt.getWhen()) {
            this.popupMenu.setVisible(false);
        } else {
            this.showPopup(evt);
        }
    }

    protected void showPopup(MouseEvent evt) {
        if (!(this.popupMenu == null || this.actionArea != null && this.actionArea.contains(evt.getX() - this.getInsets().left, evt.getY() - this.getInsets().top))) {
            int y;
            int x;
            switch (this.popupAnchor) {
                case 4: {
                    x = this.getWidth() - this.popupMenu.getPreferredSize().width;
                    y = this.getHeight();
                    break;
                }
                default: {
                    x = 0;
                    y = this.getHeight();
                }
            }
            if (this.getParent() instanceof JToolBar) {
                JToolBar toolbar = (JToolBar)this.getParent();
                if (toolbar.getOrientation() == 1) {
                    y = 0;
                    x = toolbar.getX() > toolbar.getParent().getInsets().left ? -this.popupMenu.getPreferredSize().width : this.getWidth();
                } else if (toolbar.getY() > toolbar.getParent().getInsets().top) {
                    y = -this.popupMenu.getPreferredSize().height;
                }
            }
            this.popupMenu.show(this, x, y);
            this.popupMenu.repaint();
        }
    }

    private void initComponents() {
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                JPopupButton.this.handleMousePressed(evt);
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                JPopupButton.this.performAction(evt);
            }
        });
    }

    private void performAction(MouseEvent evt) {
        if (this.actionArea != null && this.actionArea.contains(evt.getX() - this.getInsets().left, evt.getY() - this.getInsets().top)) {
            this.action.actionPerformed(new ActionEvent(this, 1001, null, evt.getWhen(), evt.getModifiers()));
        }
    }

    private void handleMousePressed(MouseEvent evt) {
        this.togglePopup(evt);
    }

    private class Handler
    implements PropertyChangeListener,
    PopupMenuListener,
    AWTEventListener {
        private Handler() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                JPopupButton.this.setEnabled((Boolean)evt.getNewValue());
            } else {
                JPopupButton.this.repaint();
            }
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            JPopupButton.this.popupBecameInvisible = System.currentTimeMillis();
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
        }

        @Override
        public void eventDispatched(AWTEvent ev) {
            if (!(ev instanceof MouseEvent) || !(ev.getSource() instanceof Component)) {
                return;
            }
            Component src = (Component)ev.getSource();
            if (ev.getID() == 501 && SwingUtilities.getWindowAncestor(src) == SwingUtilities.getWindowAncestor(JPopupButton.this)) {
                JLayeredPane srcLP = (JLayeredPane)SwingUtilities.getAncestorOfClass(JLayeredPane.class, src);
                Component srcLPChild = src;
                while (srcLPChild.getParent() != srcLP) {
                    srcLPChild = srcLPChild.getParent();
                }
                if (srcLP.getLayer(srcLPChild) < JLayeredPane.POPUP_LAYER) {
                    JPopupButton.this.popupMenu.setVisible(false);
                }
            }
        }
    }
}

